/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.dashboards.dialogs.helpers;

import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.dashboards.dialogs.helpers.DciIdMatchingData;
import org.netxms.nxmc.modules.dashboards.dialogs.helpers.IdMatchingData;
import org.netxms.nxmc.modules.dashboards.dialogs.helpers.ObjectIdMatchingData;
import org.netxms.nxmc.modules.objects.ObjectIcons;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.resources.ThemeEngine;
import org.xnap.commons.i18n.I18n;

public class IdMatchingLabelProvider
extends LabelProvider
implements ITableLabelProvider,
IColorProvider {
    private I18n i18n = LocalizationHelper.getI18n(IdMatchingLabelProvider.class);
    private Image dciImage = ResourceManager.getImage((String)"icons/dci/dc-object.png");
    private ObjectIcons objectIcons = (ObjectIcons)Registry.getSingleton(ObjectIcons.class);

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex != 0) {
            return null;
        }
        if (element instanceof ObjectIdMatchingData) {
            return this.objectIcons.getImage(((ObjectIdMatchingData)element).objectClass);
        }
        if (element instanceof DciIdMatchingData) {
            return this.dciImage;
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return Long.toString(((IdMatchingData)element).getSourceId());
            }
            case 1: {
                return ((IdMatchingData)element).getSourceName();
            }
            case 2: {
                long id = ((IdMatchingData)element).getDestinationId();
                return id > 0L ? Long.toString(id) : this.i18n.tr("no match");
            }
            case 3: {
                return ((IdMatchingData)element).getDestinationName();
            }
        }
        return null;
    }

    public Color getForeground(Object element) {
        return ((IdMatchingData)element).getDestinationId() != 0L ? null : ThemeEngine.getForegroundColor((String)"List.Error");
    }

    public Color getBackground(Object element) {
        return null;
    }

    public void dispose() {
        this.dciImage.dispose();
        super.dispose();
    }
}

