/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.dashboards.propertypages;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Spinner;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Dashboard;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.dashboards.config.DashboardElementConfig;
import org.netxms.nxmc.modules.dashboards.config.EmbeddedDashboardConfig;
import org.netxms.nxmc.modules.dashboards.propertypages.DashboardElementPropertyPage;
import org.netxms.nxmc.modules.dashboards.widgets.TitleConfigurator;
import org.netxms.nxmc.modules.objects.dialogs.ObjectSelectionDialog;
import org.netxms.nxmc.modules.objects.widgets.helpers.BaseObjectLabelProvider;
import org.xnap.commons.i18n.I18n;

public class EmbeddedDashboard
extends DashboardElementPropertyPage {
    private static final I18n i18n = LocalizationHelper.getI18n(EmbeddedDashboard.class);
    private EmbeddedDashboardConfig config;
    private List<AbstractObject> dashboardObjects;
    private TitleConfigurator title;
    private TableViewer viewer;
    private Button addButton;
    private Button deleteButton;
    private Button upButton;
    private Button downButton;
    private Scale refreshIntervalScale;
    private Spinner refreshIntervalSpinner;

    public EmbeddedDashboard(DashboardElementConfig elementConfig) {
        super(i18n.tr("Dashboard"), elementConfig);
    }

    public String getId() {
        return "dashboard";
    }

    public boolean isVisible() {
        return this.elementConfig instanceof EmbeddedDashboardConfig;
    }

    public int getPriority() {
        return 0;
    }

    protected Control createContents(Composite parent) {
        this.config = (EmbeddedDashboardConfig)this.elementConfig;
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        this.title = new TitleConfigurator(dialogArea, (DashboardElementConfig)this.config);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.title.setLayoutData((Object)gd);
        Label label = new Label(dialogArea, 0);
        label.setText(i18n.tr("Dashboards"));
        gd = new GridData();
        gd.horizontalAlignment = 16384;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.viewer = new TableViewer(dialogArea, 67586);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new BaseObjectLabelProvider());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.heightHint = 0;
        this.viewer.getTable().setLayoutData((Object)gd);
        NXCSession session = Registry.getSession();
        this.dashboardObjects = session.findMultipleObjects(this.config.getDashboardObjects(), Dashboard.class, false);
        this.viewer.setInput((Object)this.dashboardObjects.toArray());
        Composite leftButtons = new Composite(dialogArea, 0);
        RowLayout buttonLayout = new RowLayout();
        buttonLayout.type = 256;
        buttonLayout.pack = false;
        buttonLayout.marginWidth = 0;
        buttonLayout.marginLeft = 0;
        leftButtons.setLayout((Layout)buttonLayout);
        gd = new GridData();
        gd.horizontalAlignment = 16384;
        leftButtons.setLayoutData((Object)gd);
        this.upButton = new Button(leftButtons, 8);
        this.upButton.setText(i18n.tr("&Up"));
        RowData rd = new RowData();
        rd.width = 90;
        this.upButton.setLayoutData((Object)rd);
        this.upButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.upButton.setEnabled(false);
        this.downButton = new Button(leftButtons, 8);
        this.downButton.setText(i18n.tr("Dow&n"));
        rd = new RowData();
        rd.width = 90;
        this.downButton.setLayoutData((Object)rd);
        this.downButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.downButton.setEnabled(false);
        Composite rightButtons = new Composite(dialogArea, 0);
        buttonLayout = new RowLayout();
        buttonLayout.type = 256;
        buttonLayout.pack = false;
        buttonLayout.marginWidth = 0;
        buttonLayout.marginRight = 0;
        rightButtons.setLayout((Layout)buttonLayout);
        gd = new GridData();
        gd.horizontalAlignment = 131072;
        rightButtons.setLayoutData((Object)gd);
        this.addButton = new Button(rightButtons, 8);
        this.addButton.setText(i18n.tr("&Add..."));
        rd = new RowData();
        rd.width = 90;
        this.addButton.setLayoutData((Object)rd);
        this.addButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.deleteButton = new Button(rightButtons, 8);
        this.deleteButton.setText(i18n.tr("&Delete"));
        rd = new RowData();
        rd.width = 90;
        this.deleteButton.setLayoutData((Object)rd);
        this.deleteButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.deleteButton.setEnabled(false);
        Composite refreshIntervalGroup = new Composite(dialogArea, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.horizontalSpacing = 4;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginTop = 4;
        refreshIntervalGroup.setLayout((Layout)layout);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        refreshIntervalGroup.setLayoutData((Object)gd);
        label = new Label(refreshIntervalGroup, 0);
        label.setText(i18n.tr("Display time (seconds)"));
        gd = new GridData();
        gd.horizontalAlignment = 16384;
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.refreshIntervalScale = new Scale(refreshIntervalGroup, 256);
        this.refreshIntervalScale.setMinimum(1);
        this.refreshIntervalScale.setMaximum(600);
        this.refreshIntervalScale.setSelection(this.config.getDisplayInterval());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.refreshIntervalScale.setLayoutData((Object)gd);
        this.refreshIntervalScale.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.refreshIntervalSpinner = new Spinner(refreshIntervalGroup, 2048);
        this.refreshIntervalSpinner.setMinimum(1);
        this.refreshIntervalSpinner.setMaximum(600);
        this.refreshIntervalSpinner.setSelection(this.config.getDisplayInterval());
        this.refreshIntervalSpinner.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        return dialogArea;
    }

    protected void moveDown() {
        Object element;
        int index;
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() == 1 && (index = this.dashboardObjects.indexOf(element = selection.getFirstElement())) < this.dashboardObjects.size() - 1 && index >= 0) {
            Collections.swap(this.dashboardObjects, index + 1, index);
            this.viewer.setInput((Object)this.dashboardObjects.toArray());
            this.viewer.setSelection((ISelection)new StructuredSelection(element));
        }
    }

    protected void moveUp() {
        Object element;
        int index;
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() == 1 && (index = this.dashboardObjects.indexOf(element = selection.getFirstElement())) > 0) {
            Collections.swap(this.dashboardObjects, index - 1, index);
            this.viewer.setInput((Object)this.dashboardObjects.toArray());
            this.viewer.setSelection((ISelection)new StructuredSelection(element));
        }
    }

    protected void deleteDashboards() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        for (Object o : selection.toList()) {
            this.dashboardObjects.remove(o);
        }
        this.viewer.setInput((Object)this.dashboardObjects.toArray());
    }

    protected void addDashboard() {
        ObjectSelectionDialog dlg = new ObjectSelectionDialog(this.getShell(), ObjectSelectionDialog.createDashboardSelectionFilter());
        if (dlg.open() == 0) {
            this.dashboardObjects.addAll(Arrays.asList(dlg.getSelectedObjects(Dashboard.class)));
            this.viewer.setInput((Object)this.dashboardObjects.toArray());
        }
    }

    protected boolean applyChanges(boolean isApply) {
        this.title.updateConfiguration((DashboardElementConfig)this.config);
        long[] idList = new long[this.dashboardObjects.size()];
        for (int i = 0; i < this.dashboardObjects.size(); ++i) {
            idList[i] = ((AbstractObject)this.dashboardObjects.get(i)).getObjectId();
        }
        this.config.setDashboardObjects(idList);
        this.config.setDisplayInterval(this.refreshIntervalSpinner.getSelection());
        return true;
    }
}

