/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.dashboards.propertypages;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.netxms.nxmc.base.widgets.LabeledSpinner;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.dashboards.config.DashboardElementConfig;
import org.netxms.nxmc.modules.dashboards.config.DashboardElementLayout;
import org.netxms.nxmc.modules.dashboards.propertypages.DashboardElementPropertyPage;
import org.xnap.commons.i18n.I18n;

public class Layout
extends DashboardElementPropertyPage {
    private static final I18n i18n = LocalizationHelper.getI18n(Layout.class);
    private Button checkGrabVerticalSpace;
    private LabeledSpinner spinnerHorizontalSpan;
    private LabeledSpinner spinnerVerticalSpan;
    private LabeledSpinner spinnerHeightHint;
    private DashboardElementLayout elementLayout;

    public Layout(DashboardElementConfig elementConfig) {
        super(i18n.tr("Layout"), elementConfig);
    }

    public String getId() {
        return "layout";
    }

    protected Control createContents(Composite parent) {
        this.elementLayout = this.elementConfig.getLayout();
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        dialogArea.setLayout((org.eclipse.swt.widgets.Layout)layout);
        this.spinnerHorizontalSpan = new LabeledSpinner(dialogArea, 0);
        this.spinnerHorizontalSpan.setLabel(i18n.tr("Horizontal span"));
        this.spinnerHorizontalSpan.setRange(1, 128);
        this.spinnerHorizontalSpan.setSelection(this.elementLayout.horizontalSpan);
        this.spinnerHorizontalSpan.setLayoutData((Object)new GridData(4, 1024, true, false));
        this.spinnerHeightHint = new LabeledSpinner(dialogArea, 0);
        this.spinnerHeightHint.setLabel(i18n.tr("Height hint"));
        this.spinnerHeightHint.setRange(-1, 8192);
        this.spinnerHeightHint.setSelection(this.elementLayout.heightHint);
        this.spinnerHeightHint.setLayoutData((Object)new GridData(4, 1024, true, false));
        this.spinnerVerticalSpan = new LabeledSpinner(dialogArea, 0);
        this.spinnerVerticalSpan.setLabel(i18n.tr("Vertical span"));
        this.spinnerVerticalSpan.setRange(1, 128);
        this.spinnerVerticalSpan.setSelection(this.elementLayout.verticalSpan);
        this.spinnerVerticalSpan.setLayoutData((Object)new GridData(4, 1024, true, false));
        this.checkGrabVerticalSpace = new Button(dialogArea, 32);
        this.checkGrabVerticalSpace.setText(i18n.tr("Grab excessive vertical space"));
        this.checkGrabVerticalSpace.setSelection(this.elementLayout.grabVerticalSpace);
        this.checkGrabVerticalSpace.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        return dialogArea;
    }

    protected boolean applyChanges(boolean isApply) {
        this.elementLayout.grabVerticalSpace = this.checkGrabVerticalSpace.getSelection();
        this.elementLayout.horizontalSpan = this.spinnerHorizontalSpan.getSelection();
        this.elementLayout.verticalSpan = this.spinnerVerticalSpan.getSelection();
        this.elementLayout.heightHint = this.spinnerHeightHint.getSelection();
        return true;
    }
}

