/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.dashboards.propertypages;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.netxms.nxmc.base.widgets.LabeledSpinner;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.dashboards.config.DashboardElementConfig;
import org.netxms.nxmc.modules.dashboards.config.ObjectToolsConfig;
import org.netxms.nxmc.modules.dashboards.dialogs.EditToolDialog;
import org.netxms.nxmc.modules.dashboards.propertypages.DashboardElementPropertyPage;
import org.netxms.nxmc.modules.dashboards.propertypages.helpers.ToolListLabelProvider;
import org.netxms.nxmc.modules.dashboards.widgets.TitleConfigurator;
import org.xnap.commons.i18n.I18n;

public class ObjectTools
extends DashboardElementPropertyPage {
    private static final I18n i18n = LocalizationHelper.getI18n(ObjectTools.class);
    private ObjectToolsConfig config;
    private TitleConfigurator title;
    private LabeledSpinner columns;
    private List<ObjectToolsConfig.Tool> tools;
    private TableViewer viewer;
    private Button addButton;
    private Button deleteButton;
    private Button upButton;
    private Button downButton;

    public ObjectTools(DashboardElementConfig elementConfig) {
        super(i18n.tr("Object Tools"), elementConfig);
    }

    public String getId() {
        return "object-tools";
    }

    public boolean isVisible() {
        return this.elementConfig instanceof ObjectToolsConfig;
    }

    public int getPriority() {
        return 0;
    }

    protected Control createContents(Composite parent) {
        this.config = (ObjectToolsConfig)this.elementConfig;
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 2;
        dialogArea.setLayout((Layout)layout);
        this.title = new TitleConfigurator(dialogArea, (DashboardElementConfig)this.config);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.title.setLayoutData((Object)gd);
        this.columns = new LabeledSpinner(dialogArea, 0);
        this.columns.setLabel("Columns");
        this.columns.setRange(1, 32);
        this.columns.setSelection(this.config.getNumColumns());
        Label label = new Label(dialogArea, 0);
        label.setText("Tools");
        gd = new GridData();
        gd.horizontalAlignment = 16384;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        gd.verticalIndent = 2;
        label.setLayoutData((Object)gd);
        this.viewer = new TableViewer(dialogArea, 67586);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ToolListLabelProvider());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.heightHint = 0;
        this.viewer.getTable().setLayoutData((Object)gd);
        this.tools = new ArrayList();
        if (this.config.getTools() != null) {
            for (ObjectToolsConfig.Tool t : this.config.getTools()) {
                if (t == null) continue;
                this.tools.add(new ObjectToolsConfig.Tool(t));
            }
        }
        this.viewer.setInput((Object)this.tools.toArray());
        Composite buttonsArea = new Composite(dialogArea, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        buttonsArea.setLayout((Layout)layout);
        gd = new GridData();
        gd.horizontalSpan = 2;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        buttonsArea.setLayoutData((Object)gd);
        Composite leftButtons = new Composite(buttonsArea, 0);
        RowLayout buttonLayout = new RowLayout();
        buttonLayout.type = 256;
        buttonLayout.pack = false;
        buttonLayout.marginWidth = 0;
        buttonLayout.marginLeft = 0;
        leftButtons.setLayout((Layout)buttonLayout);
        gd = new GridData();
        gd.horizontalAlignment = 16384;
        gd.grabExcessHorizontalSpace = true;
        leftButtons.setLayoutData((Object)gd);
        this.upButton = new Button(leftButtons, 8);
        this.upButton.setText(i18n.tr("&Up"));
        RowData rd = new RowData();
        rd.width = 90;
        this.upButton.setLayoutData((Object)rd);
        this.upButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.upButton.setEnabled(false);
        this.downButton = new Button(leftButtons, 8);
        this.downButton.setText(i18n.tr("Dow&n"));
        rd = new RowData();
        rd.width = 90;
        this.downButton.setLayoutData((Object)rd);
        this.downButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.downButton.setEnabled(false);
        Composite rightButtons = new Composite(buttonsArea, 0);
        buttonLayout = new RowLayout();
        buttonLayout.type = 256;
        buttonLayout.pack = false;
        buttonLayout.marginWidth = 0;
        buttonLayout.marginRight = 0;
        rightButtons.setLayout((Layout)buttonLayout);
        gd = new GridData();
        gd.horizontalAlignment = 131072;
        rightButtons.setLayoutData((Object)gd);
        this.addButton = new Button(rightButtons, 8);
        this.addButton.setText(i18n.tr("&Add..."));
        rd = new RowData();
        rd.width = 90;
        this.addButton.setLayoutData((Object)rd);
        this.addButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.deleteButton = new Button(rightButtons, 8);
        this.deleteButton.setText(i18n.tr("&Delete"));
        rd = new RowData();
        rd.width = 90;
        this.deleteButton.setLayoutData((Object)rd);
        this.deleteButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.deleteButton.setEnabled(false);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        return dialogArea;
    }

    protected void moveDown() {
        Object element;
        int index;
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() == 1 && (index = this.tools.indexOf(element = selection.getFirstElement())) < this.tools.size() - 1 && index >= 0) {
            Collections.swap(this.tools, index + 1, index);
            this.viewer.setInput((Object)this.tools.toArray());
            this.viewer.setSelection((ISelection)new StructuredSelection(element));
        }
    }

    protected void moveUp() {
        Object element;
        int index;
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() == 1 && (index = this.tools.indexOf(element = selection.getFirstElement())) > 0) {
            Collections.swap(this.tools, index - 1, index);
            this.viewer.setInput((Object)this.tools.toArray());
            this.viewer.setSelection((ISelection)new StructuredSelection(element));
        }
    }

    protected void deleteTools() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        for (Object o : selection.toList()) {
            this.tools.remove(o);
        }
        this.viewer.setInput((Object)this.tools.toArray());
    }

    protected void addTool() {
        EditToolDialog dlg = new EditToolDialog(this.getShell(), new ObjectToolsConfig.Tool());
        if (dlg.open() == 0) {
            this.tools.add(dlg.getTool());
            this.viewer.setInput((Object)this.tools.toArray());
        }
    }

    protected boolean applyChanges(boolean isApply) {
        this.title.updateConfiguration((DashboardElementConfig)this.config);
        this.config.setNumColumns(this.columns.getSelection());
        this.config.setTools(this.tools.toArray(new ObjectToolsConfig.Tool[this.tools.size()]));
        return true;
    }
}

