/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.dashboards.propertypages;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.netxms.nxmc.base.widgets.LabeledSpinner;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.dashboards.config.DashboardElementConfig;
import org.netxms.nxmc.modules.dashboards.config.StatusIndicatorConfig;
import org.netxms.nxmc.modules.dashboards.propertypages.DashboardElementPropertyPage;
import org.netxms.nxmc.modules.dashboards.widgets.TitleConfigurator;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class StatusIndicator
extends DashboardElementPropertyPage {
    private static final I18n i18n = LocalizationHelper.getI18n(StatusIndicator.class);
    private StatusIndicatorConfig config;
    private TitleConfigurator title;
    private LabeledSpinner numColumns;
    private Combo shape;
    private Combo labelType;
    private Button checkFullColors;

    public StatusIndicator(DashboardElementConfig elementConfig) {
        super(i18n.tr("Status Indicator"), elementConfig);
    }

    public String getId() {
        return "status-indicator";
    }

    public boolean isVisible() {
        return this.elementConfig instanceof StatusIndicatorConfig;
    }

    public int getPriority() {
        return 0;
    }

    protected Control createContents(Composite parent) {
        this.config = (StatusIndicatorConfig)this.elementConfig;
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = true;
        dialogArea.setLayout((Layout)layout);
        this.title = new TitleConfigurator(dialogArea, (DashboardElementConfig)this.config);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = layout.numColumns;
        this.title.setLayoutData((Object)gd);
        this.shape = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)8, (String)i18n.tr("Shape"), (Object)"WidgetHelper::default_layout_data");
        this.shape.add(i18n.tr("Circle"));
        this.shape.add(i18n.tr("Rectangle"));
        this.shape.add(i18n.tr("Rounded rectangle"));
        this.shape.select(this.config.getShape());
        this.labelType = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)8, (String)i18n.tr("Label"), (Object)"WidgetHelper::default_layout_data");
        this.labelType.add(i18n.tr("None"));
        this.labelType.add(i18n.tr("Inside"));
        this.labelType.add(i18n.tr("Outside"));
        this.labelType.select(this.config.getLabelType());
        this.numColumns = new LabeledSpinner(dialogArea, 0);
        this.numColumns.setLabel("Columns");
        this.numColumns.setRange(1, 64);
        this.numColumns.setSelection(this.config.getNumColumns());
        this.checkFullColors = new Button(dialogArea, 32);
        this.checkFullColors.setText(i18n.tr("Use &full status color range"));
        this.checkFullColors.setSelection(this.config.isFullColorRange());
        return dialogArea;
    }

    protected boolean applyChanges(boolean isApply) {
        this.title.updateConfiguration((DashboardElementConfig)this.config);
        this.config.setLabelType(this.labelType.getSelectionIndex());
        this.config.setShape(this.shape.getSelectionIndex());
        this.config.setNumColumns(this.numColumns.getSelection());
        this.config.setFullColorRange(this.checkFullColors.getSelection());
        return true;
    }
}

