/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.dashboards.propertypages;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.objects.AbstractObject;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.dashboards.config.DashboardElementConfig;
import org.netxms.nxmc.modules.dashboards.config.StatusIndicatorConfig;
import org.netxms.nxmc.modules.dashboards.propertypages.DashboardElementPropertyPage;
import org.netxms.nxmc.modules.nxsl.widgets.ScriptEditor;
import org.netxms.nxmc.modules.objects.widgets.ObjectSelector;
import org.xnap.commons.i18n.I18n;

public class StatusIndicatorScript
extends DashboardElementPropertyPage {
    private static final I18n i18n = LocalizationHelper.getI18n(StatusIndicatorScript.class);
    private StatusIndicatorConfig config;
    private ObjectSelector objectSelector;
    private ScriptEditor scriptEditor;

    public StatusIndicatorScript(DashboardElementConfig elementConfig) {
        super(i18n.tr("Script"), elementConfig);
    }

    public String getId() {
        return "status-indicator-script";
    }

    public boolean isVisible() {
        return this.elementConfig instanceof StatusIndicatorConfig;
    }

    public int getPriority() {
        return 20;
    }

    protected Control createContents(Composite parent) {
        this.config = (StatusIndicatorConfig)this.elementConfig;
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        dialogArea.setLayout((Layout)layout);
        this.objectSelector = new ObjectSelector(dialogArea, 0, true, true);
        this.objectSelector.setLabel(i18n.tr("Context object"));
        this.objectSelector.setObjectClass(AbstractObject.class);
        this.objectSelector.setObjectId(this.config.getScriptContextObjectId());
        this.objectSelector.setEmptySelectionName(i18n.tr("<dashboard>"));
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.objectSelector.setLayoutData((Object)gd);
        new Label(dialogArea, 0).setText(i18n.tr("Script"));
        this.scriptEditor = new ScriptEditor(dialogArea, 2048, 770, true, i18n.tr("Variables:\r\n\t$object\tcontext object\r\n\t$node\tcontext object if it is a node, otherwise null\r\n\r\nReturn value: map with keys referring to element tags and values containing status codes"));
        this.scriptEditor.setText(this.config.getScript());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        this.scriptEditor.setLayoutData((Object)gd);
        return dialogArea;
    }

    protected boolean applyChanges(boolean isApply) {
        this.config.setScriptContextObjectId(this.objectSelector.getObjectId());
        this.config.setScript(this.scriptEditor.getText());
        return true;
    }
}

