/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.dashboards.views;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Dashboard;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.dashboards.views.AbstractDashboardView;
import org.netxms.nxmc.modules.dashboards.widgets.DashboardModifyListener;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.resources.SharedIcons;
import org.xnap.commons.i18n.I18n;

public class DashboardView
extends AbstractDashboardView {
    private static final I18n i18n = LocalizationHelper.getI18n(DashboardView.class);
    private DashboardModifyListener dbcModifyListener;
    private Action actionEditMode;
    private Action actionAddColumn;
    private Action actionRemoveColumn;
    private Action actionSave;
    private boolean readOnly;

    public DashboardView() {
        super(i18n.tr("Dashboard"), ResourceManager.getImageDescriptor((String)"icons/object-views/dashboard.png"), "DashboardView");
    }

    public boolean isValidForContext(Object context) {
        return context != null && context instanceof Dashboard;
    }

    public int getPriority() {
        return 1;
    }

    protected void createActions() {
        super.createActions();
        this.actionSave = new /* Unavailable Anonymous Inner Class!! */;
        this.actionSave.setEnabled(false);
        this.actionEditMode = new /* Unavailable Anonymous Inner Class!! */;
        this.actionEditMode.setImageDescriptor(SharedIcons.EDIT);
        this.actionAddColumn = new /* Unavailable Anonymous Inner Class!! */;
        this.actionRemoveColumn = new /* Unavailable Anonymous Inner Class!! */;
        this.dbcModifyListener = new /* Unavailable Anonymous Inner Class!! */;
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionEditMode);
        manager.add((IAction)this.actionSave);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionAddColumn);
        manager.add((IAction)this.actionRemoveColumn);
        manager.add((IContributionItem)new Separator());
        super.fillLocalToolBar(manager);
    }

    protected void fillLocalMenu(IMenuManager manager) {
        manager.add((IAction)this.actionEditMode);
        manager.add((IAction)this.actionSave);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionAddColumn);
        manager.add((IAction)this.actionRemoveColumn);
        manager.add((IContributionItem)new Separator());
        super.fillLocalMenu(manager);
    }

    protected void onObjectChange(AbstractObject object) {
        this.readOnly = (object.getEffectiveRights() & 2) == 0;
        this.rebuildDashboard((Dashboard)object, null);
    }

    protected void rebuildDashboard(Dashboard dashboard, AbstractObject dashboardContext) {
        super.rebuildDashboard(dashboard, dashboardContext);
        if (this.dbc != null && !this.readOnly) {
            this.actionAddColumn.setEnabled(this.dbc.getColumnCount() < 128);
            this.actionRemoveColumn.setEnabled(this.dbc.getColumnCount() != this.dbc.getMinimalColumnCount());
            this.actionSave.setEnabled(this.dbc.isModified());
            this.dbc.setModifyListener(this.dbcModifyListener);
            this.actionEditMode.setEnabled(true);
        } else {
            this.actionAddColumn.setEnabled(false);
            this.actionRemoveColumn.setEnabled(false);
            this.actionSave.setEnabled(false);
            this.actionEditMode.setEnabled(false);
        }
    }
}

