/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.dashboards.widgets;

import org.netxms.client.dashboards.DashboardElement;
import org.netxms.client.datacollection.ChartConfiguration;
import org.netxms.client.xml.XMLTools;
import org.netxms.nxmc.modules.charts.api.ChartType;
import org.netxms.nxmc.modules.charts.widgets.Chart;
import org.netxms.nxmc.modules.dashboards.config.DashboardElementConfig;
import org.netxms.nxmc.modules.dashboards.config.ScriptedBarChartConfig;
import org.netxms.nxmc.modules.dashboards.views.AbstractDashboardView;
import org.netxms.nxmc.modules.dashboards.widgets.DashboardControl;
import org.netxms.nxmc.modules.dashboards.widgets.ScriptedComparisonChartElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptedBarChartElement
extends ScriptedComparisonChartElement {
    private static final Logger logger = LoggerFactory.getLogger(ScriptedBarChartElement.class);
    private ScriptedBarChartConfig elementConfig;

    public ScriptedBarChartElement(DashboardControl parent, DashboardElement element, AbstractDashboardView view) {
        super(parent, element, view);
        try {
            this.elementConfig = (ScriptedBarChartConfig)XMLTools.createFromXml(ScriptedBarChartConfig.class, (String)element.getData());
        }
        catch (Exception e) {
            logger.error("Cannot parse dashboard element configuration", (Throwable)e);
            this.elementConfig = new ScriptedBarChartConfig();
        }
        this.processCommonSettings((DashboardElementConfig)this.elementConfig);
        this.script = this.elementConfig.getScript();
        this.objectId = this.getEffectiveObjectId(this.elementConfig.getObjectId());
        this.refreshInterval = this.elementConfig.getRefreshRate();
        ChartConfiguration chartConfig = new ChartConfiguration();
        chartConfig.setTitleVisible(false);
        chartConfig.setLegendPosition(this.elementConfig.getLegendPosition());
        chartConfig.setLegendVisible(this.elementConfig.isShowLegend());
        chartConfig.setExtendedLegend(this.elementConfig.isExtendedLegend());
        chartConfig.setTransposed(this.elementConfig.isTransposed());
        chartConfig.setTranslucent(this.elementConfig.isTranslucent());
        chartConfig.setAutoScale(this.elementConfig.isAutoScale());
        chartConfig.setMinYScaleValue(this.elementConfig.getMinYScaleValue());
        chartConfig.setMaxYScaleValue(this.elementConfig.getMaxYScaleValue());
        this.chart = new Chart(this.getContentArea(), 0, ChartType.BAR, chartConfig);
        this.chart.setDrillDownObjectId(this.elementConfig.getDrillDownObjectId());
        this.chart.rebuild();
        this.startRefreshTimer();
    }
}

