/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.datacollection.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class CreateSnmpDciDialog
extends Dialog {
    private static I18n i18n = LocalizationHelper.getI18n(CreateSnmpDciDialog.class);
    private LabeledText textDescription;
    private LabeledText textInterval;
    private LabeledText textRetention;
    private Combo deltaCalculationSelector;
    private String description;
    private int pollingInterval;
    private int retentionTime;
    private int deltaCalculation = 0;

    public CreateSnmpDciDialog(Shell parentShell, String initialDescription) {
        super(parentShell);
        this.description = initialDescription;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(i18n.tr("Create SNMP DCI"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        dialogArea.setLayout((Layout)layout);
        this.textDescription = new LabeledText(dialogArea, 0);
        this.textDescription.setLabel(i18n.tr("Description"));
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.textDescription.setLayoutData((Object)gd);
        this.textDescription.setText(this.description);
        Composite optionsGroup = new Composite(dialogArea, 0);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        optionsGroup.setLayoutData((Object)gd);
        layout = new GridLayout();
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = true;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        optionsGroup.setLayout((Layout)layout);
        this.textInterval = new LabeledText(optionsGroup, 0);
        this.textInterval.setLabel(i18n.tr("Polling pollingInterval (seconds)"));
        this.textInterval.setText("60");
        this.textInterval.getTextControl().setTextLimit(5);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.textInterval.setLayoutData((Object)gd);
        this.textRetention = new LabeledText(optionsGroup, 0);
        this.textRetention.setLabel(i18n.tr("Retention time (days)"));
        this.textRetention.setText("30");
        this.textRetention.getTextControl().setTextLimit(5);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.textRetention.setLayoutData((Object)gd);
        this.deltaCalculationSelector = WidgetHelper.createLabeledCombo((Composite)optionsGroup, (int)2056, (String)i18n.tr("Delta calculation"), (Object)"WidgetHelper::default_layout_data");
        this.deltaCalculationSelector.add(i18n.tr("None (keep original value)"));
        this.deltaCalculationSelector.add(i18n.tr("Simple delta"));
        this.deltaCalculationSelector.add(i18n.tr("Average delta per second"));
        this.deltaCalculationSelector.add(i18n.tr("Average delta per minute"));
        this.deltaCalculationSelector.select(this.deltaCalculation);
        return dialogArea;
    }

    public final String getDescription() {
        return this.description;
    }

    public final int getPollingInterval() {
        return this.pollingInterval;
    }

    public final int getRetentionTime() {
        return this.retentionTime;
    }

    public final int getDeltaCalculation() {
        return this.deltaCalculation;
    }

    protected void okPressed() {
        try {
            this.pollingInterval = Integer.parseInt(this.textInterval.getText());
            if (this.pollingInterval < 2 || this.pollingInterval > 10000) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            MessageDialogHelper.openError((Shell)this.getShell(), (String)i18n.tr("Error"), (String)i18n.tr("Please enter polling pollingInterval as integer in range 2 .. 10000"));
        }
        try {
            this.retentionTime = Integer.parseInt(this.textRetention.getText());
            if (this.retentionTime < 1 || this.retentionTime > 10000) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            MessageDialogHelper.openError((Shell)this.getShell(), (String)i18n.tr("Error"), (String)i18n.tr("Please enter retention time as integer in range 1 .. 10000"));
        }
        this.description = this.textDescription.getText().trim();
        this.deltaCalculation = this.deltaCalculationSelector.getSelectionIndex();
        super.okPressed();
    }
}

