/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.datacollection.propertypages;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.DataOrigin;
import org.netxms.client.datacollection.ColumnDefinition;
import org.netxms.client.datacollection.DataCollectionTable;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Cluster;
import org.netxms.client.objects.Template;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.datacollection.DataCollectionObjectEditor;
import org.netxms.nxmc.modules.datacollection.DataCollectionObjectListener;
import org.netxms.nxmc.modules.datacollection.TableColumnEnumerator;
import org.netxms.nxmc.modules.datacollection.dialogs.EditColumnDialog;
import org.netxms.nxmc.modules.datacollection.propertypages.AbstractDCIPropertyPage;
import org.netxms.nxmc.modules.datacollection.propertypages.TableColumns;
import org.netxms.nxmc.modules.datacollection.propertypages.helpers.TableColumnLabelProvider;
import org.netxms.nxmc.modules.objects.dialogs.ObjectSelectionDialog;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.netxms.nxmc.tools.WidgetHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;

public class TableColumns
extends AbstractDCIPropertyPage {
    private static final I18n i18n = LocalizationHelper.getI18n(TableColumns.class);
    private static Logger logger = LoggerFactory.getLogger(TableColumns.class);
    private static final String COLUMN_SETTINGS_PREFIX = "TableColumns.ColumnList";
    private DataCollectionTable dci;
    private List<ColumnDefinition> columns;
    private TableViewer columnList = null;
    private Button queryButton;
    private Button addButton;
    private Button modifyButton;
    private Button deleteButton;
    private Button upButton;
    private Button downButton;

    public TableColumns(DataCollectionObjectEditor editor) {
        super(i18n.tr("Table Columns"), editor);
    }

    protected Control createContents(Composite parent) {
        Composite dialogArea = (Composite)super.createContents(parent);
        this.dci = this.editor.getObjectAsTable();
        this.editor.setTableColumnEnumerator((TableColumnEnumerator)new /* Unavailable Anonymous Inner Class!! */);
        this.columns = new ArrayList();
        for (ColumnDefinition c : this.dci.getColumns()) {
            this.columns.add(new ColumnDefinition(c));
        }
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        Composite columnListArea = new Composite(dialogArea, 0);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalSpan = 2;
        columnListArea.setLayoutData((Object)gd);
        layout = new GridLayout();
        layout.verticalSpacing = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        columnListArea.setLayout((Layout)layout);
        new Label(columnListArea, 0).setText(i18n.tr("Columns"));
        this.columnList = new TableViewer(columnListArea, 67586);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalSpan = 2;
        this.columnList.getControl().setLayoutData((Object)gd);
        this.setupColumnList();
        this.columnList.setInput((Object)this.columns);
        Composite leftButtons = new Composite(columnListArea, 0);
        gd = new GridData();
        gd.horizontalAlignment = 16384;
        leftButtons.setLayoutData((Object)gd);
        RowLayout buttonsLayout = new RowLayout(256);
        buttonsLayout.marginBottom = 0;
        buttonsLayout.marginLeft = 0;
        buttonsLayout.marginRight = 0;
        buttonsLayout.marginTop = 0;
        buttonsLayout.spacing = 4;
        buttonsLayout.fill = true;
        buttonsLayout.pack = false;
        leftButtons.setLayout((Layout)buttonsLayout);
        this.upButton = new Button(leftButtons, 8);
        this.upButton.setText(i18n.tr("&Up"));
        RowData rd = new RowData();
        rd.width = 90;
        this.upButton.setLayoutData((Object)rd);
        this.upButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.downButton = new Button(leftButtons, 8);
        this.downButton.setText(i18n.tr("Dow&n"));
        rd = new RowData();
        rd.width = 90;
        this.downButton.setLayoutData((Object)rd);
        this.downButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        Composite buttons = new Composite(columnListArea, 0);
        gd = new GridData();
        gd.horizontalAlignment = 131072;
        buttons.setLayoutData((Object)gd);
        buttonsLayout = new RowLayout(256);
        buttonsLayout.marginBottom = 0;
        buttonsLayout.marginLeft = 0;
        buttonsLayout.marginRight = 0;
        buttonsLayout.marginTop = 0;
        buttonsLayout.spacing = 4;
        buttonsLayout.fill = true;
        buttonsLayout.pack = false;
        buttons.setLayout((Layout)buttonsLayout);
        this.queryButton = new Button(buttons, 8);
        this.queryButton.setText("&Query...");
        rd = new RowData();
        rd.width = 90;
        this.queryButton.setLayoutData((Object)rd);
        this.queryButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.addButton = new Button(buttons, 8);
        this.addButton.setText(i18n.tr("&Add..."));
        rd = new RowData();
        rd.width = 90;
        this.addButton.setLayoutData((Object)rd);
        this.addButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.modifyButton = new Button(buttons, 8);
        this.modifyButton.setText(i18n.tr("&Edit..."));
        rd = new RowData();
        rd.width = 90;
        this.modifyButton.setLayoutData((Object)rd);
        this.modifyButton.setEnabled(false);
        this.modifyButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.deleteButton = new Button(buttons, 8);
        this.deleteButton.setText(i18n.tr("&Delete"));
        rd = new RowData();
        rd.width = 90;
        this.deleteButton.setLayoutData((Object)rd);
        this.deleteButton.setEnabled(false);
        this.deleteButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.columnList.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        this.columnList.addDoubleClickListener((IDoubleClickListener)new /* Unavailable Anonymous Inner Class!! */);
        10 listener = new /* Unavailable Anonymous Inner Class!! */;
        dialogArea.addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.editor.addListener((DataCollectionObjectListener)listener);
        return dialogArea;
    }

    private void setupColumnList() {
        Table table = this.columnList.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableColumn column = new TableColumn(table, 16384);
        column.setText(i18n.tr("Name"));
        column.setWidth(150);
        column = new TableColumn(table, 16384);
        column.setText(i18n.tr("Display Name"));
        column.setWidth(150);
        column = new TableColumn(table, 16384);
        column.setText(i18n.tr("Type"));
        column.setWidth(80);
        column = new TableColumn(table, 16384);
        column.setText(i18n.tr("Instance"));
        column.setWidth(50);
        column = new TableColumn(table, 16384);
        column.setText(i18n.tr("Aggregation"));
        column.setWidth(80);
        column = new TableColumn(table, 16384);
        column.setText(i18n.tr("SNMP OID"));
        column.setWidth(200);
        WidgetHelper.restoreColumnSettings((Table)table, (String)COLUMN_SETTINGS_PREFIX);
        this.columnList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.columnList.setLabelProvider((IBaseLabelProvider)new TableColumnLabelProvider());
    }

    private void deleteColumns() {
        IStructuredSelection selection = this.columnList.getStructuredSelection();
        if (!selection.isEmpty()) {
            Iterator it = selection.iterator();
            while (it.hasNext()) {
                this.columns.remove(it.next());
            }
            this.columnList.refresh();
        }
    }

    private void editColumn() {
        IStructuredSelection selection = this.columnList.getStructuredSelection();
        if (selection.size() == 1) {
            ColumnDefinition column = (ColumnDefinition)selection.getFirstElement();
            EditColumnDialog dlg = new EditColumnDialog(this.getShell(), column);
            if (dlg.open() == 0) {
                this.columnList.update((Object)column, null);
            }
        }
    }

    private void addColumn() {
        ColumnDefinition column = new ColumnDefinition();
        EditColumnDialog dlg = new EditColumnDialog(this.getShell(), column);
        if (dlg.open() == 0) {
            this.columns.add(column);
            this.columnList.refresh();
            this.columnList.setSelection((ISelection)new StructuredSelection((Object)column));
        }
    }

    private void moveSelectionUp() {
        IStructuredSelection selection = (IStructuredSelection)this.columnList.getSelection();
        if (selection.size() != 1) {
            return;
        }
        ColumnDefinition column = (ColumnDefinition)selection.getFirstElement();
        int index = this.columns.indexOf(column);
        if (index > 0) {
            Collections.swap(this.columns, index, index - 1);
            this.columnList.refresh();
        }
    }

    private void moveSelectionDown() {
        IStructuredSelection selection = (IStructuredSelection)this.columnList.getSelection();
        if (selection.size() != 1) {
            return;
        }
        ColumnDefinition column = (ColumnDefinition)selection.getFirstElement();
        int index = this.columns.indexOf(column);
        if (index < this.columns.size() - 1) {
            Collections.swap(this.columns, index, index + 1);
            this.columnList.refresh();
        }
    }

    protected boolean applyChanges(boolean isApply) {
        this.saveSettings();
        this.dci.getColumns().clear();
        this.dci.getColumns().addAll(this.columns);
        this.editor.modify();
        return true;
    }

    public boolean performCancel() {
        this.saveSettings();
        return true;
    }

    private void saveSettings() {
        if (this.columnList != null) {
            WidgetHelper.saveColumnSettings((Table)this.columnList.getTable(), (String)COLUMN_SETTINGS_PREFIX);
        }
    }

    private void queryColumns() {
        if (!MessageDialogHelper.openQuestion((Shell)this.getShell(), (String)"Warning", (String)"Current column definition will be replaced by definition provided by agent. Continue?")) {
            return;
        }
        AbstractObject object = Registry.getSession().findObjectById(this.dci.getNodeId());
        if (this.editor.getSourceNode() == 0L && (object instanceof Template || object instanceof Cluster)) {
            ObjectSelectionDialog dlg = new ObjectSelectionDialog(this.getShell(), ObjectSelectionDialog.createNodeSelectionFilter((boolean)false));
            if (dlg.open() != 0) {
                return;
            }
            object = (AbstractObject)dlg.getSelectedObjects().get(0);
        }
        if (this.dci.getOrigin() == DataOrigin.AGENT) {
            this.updateColumnsFromAgent(this.dci.getName(), true, object);
        } else if (this.dci.getOrigin() == DataOrigin.SNMP) {
            this.updateColumnsFromSnmp(this.dci.getName(), true, object);
        }
    }

    private void updateColumnsFromAgent(String name, boolean interactive, AbstractObject queryObject) {
        NXCSession session = Registry.getSession();
        12 job = new /* Unavailable Anonymous Inner Class!! */;
        job.setUser(false);
        job.start();
    }

    private void updateColumnsFromSnmp(String name, boolean interactive, AbstractObject queryObject) {
        NXCSession session = Registry.getSession();
        13 job = new /* Unavailable Anonymous Inner Class!! */;
        job.setUser(false);
        job.start();
    }
}

