/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.datacollection.views;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.swt.widgets.Composite;
import org.netxms.client.NXCSession;
import org.netxms.client.Table;
import org.netxms.client.objects.AbstractObject;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.actions.ExportToCsvAction;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.datacollection.views.PerformanceView;
import org.netxms.nxmc.modules.datacollection.widgets.SummaryTableWidget;
import org.netxms.nxmc.modules.objects.views.AdHocObjectView;
import org.netxms.nxmc.resources.ResourceManager;
import org.xnap.commons.i18n.I18n;

public class SummaryTable
extends AdHocObjectView {
    public static final String ID = "SummaryTable";
    private static I18n i18n = LocalizationHelper.getI18n(PerformanceView.class);
    private NXCSession session;
    private int tableId;
    private long baseObjectId;
    private SummaryTableWidget viewer;
    private Action actionExportAllToCsv;

    public SummaryTable(int tableId, long baseObjectId, long contextId) {
        super(i18n.tr("Summary Table"), ResourceManager.getImageDescriptor((String)"icons/config-views/summary_table.png"), ID, baseObjectId, contextId, false);
        this.session = Registry.getSession();
        this.baseObjectId = baseObjectId;
        this.tableId = tableId;
    }

    protected SummaryTable() {
        super(null, null, null, 0L, 0L, false);
    }

    public View cloneView() {
        SummaryTable view = (SummaryTable)super.cloneView();
        view.tableId = this.tableId;
        view.baseObjectId = this.baseObjectId;
        return view;
    }

    protected void postClone(View origin) {
        super.postClone(origin);
        this.viewer.refresh();
    }

    protected void createContent(Composite parent) {
        this.viewer = new SummaryTableWidget(parent, 0, (View)this, this.tableId, this.baseObjectId);
        this.createActions();
    }

    private void createActions() {
        this.actionExportAllToCsv = new ExportToCsvAction((View)this, (ColumnViewer)this.viewer.getViewer(), false);
    }

    protected void fillLocalMenu(IMenuManager manager) {
        manager.add((IAction)this.viewer.getActionUseMultipliers());
        manager.add((IAction)this.actionExportAllToCsv);
    }

    public void refresh() {
        this.viewer.refresh();
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionExportAllToCsv);
    }

    public void setTable(Table table) {
        AbstractObject object = this.session.findObjectById(this.baseObjectId);
        this.setName(table.getTitle() + " - " + (String)(object != null ? object.getObjectName() : "[" + this.baseObjectId + "]"));
        this.viewer.update(table);
    }
}

