/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.datacollection.widgets;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.AgentPolicy;
import org.netxms.nxmc.base.widgets.LabeledSpinner;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.base.widgets.SortableTreeViewer;
import org.netxms.nxmc.modules.datacollection.dialogs.MenuItemDialog;
import org.netxms.nxmc.modules.datacollection.views.PolicyEditorView;
import org.netxms.nxmc.modules.datacollection.widgets.AbstractPolicyEditor;
import org.netxms.nxmc.modules.datacollection.widgets.SupportAppPolicyEditor;
import org.netxms.nxmc.modules.datacollection.widgets.helpers.AppMenuItem;
import org.netxms.nxmc.modules.datacollection.widgets.helpers.SupportAppMenuItemLabelProvider;
import org.netxms.nxmc.modules.datacollection.widgets.helpers.SupportAppMenuItemProvider;
import org.netxms.nxmc.modules.datacollection.widgets.helpers.SupportAppPolicy;
import org.netxms.nxmc.resources.SharedIcons;
import org.netxms.nxmc.tools.ColorConverter;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.netxms.nxmc.tools.WidgetHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class SupportAppPolicyEditor
extends AbstractPolicyEditor {
    private static final Logger logger = LoggerFactory.getLogger(SupportAppPolicy.class);
    public static final int NAME = 0;
    public static final int DISCRIPTION = 1;
    public static final int COMMAND = 2;
    public static final int ICON = 3;
    private static final int[] IMAGE_SIZE = new int[]{128, 64, 32, 16};
    private static final Integer[] WINDOW_POSITION_CODES = new Integer[]{null, 0, 17, 18, 19, 33, 34, 35, 49, 50, 51};
    private ColorSelector backgroundColor;
    private ColorSelector borderColor;
    private ColorSelector highlightColor;
    private ColorSelector textColor;
    private ColorSelector menuBackgroundColor;
    private ColorSelector menuHighligtColor;
    private ColorSelector menuSelectionColor;
    private ColorSelector menuTextColor;
    private ColorSelector notificationBackgroundColor;
    private ColorSelector notificationHighligtColor;
    private ColorSelector notificationSelectionColor;
    private ColorSelector notificationTextColor;
    private LabeledText desktopWallpaperFile;
    private LabeledText welcomeMessageText;
    private LabeledText tooltipMessageText;
    private Button customColorSchemaCheckbox;
    private Button closeOnDeactivateCheckbox;
    private Combo windowPositioning;
    private LabeledSpinner notificationTimeout;
    private Action addSubMenuAction;
    private Action addItemAction;
    private Action deleteAction;
    private Action editAction;
    private SortableTreeViewer viewer;
    private SupportAppPolicy policyData;
    private Label[] iconBox = new Label[4];
    private Image[] iconPreview = new Image[4];
    private byte[] iconFile = null;

    private static int windowPositionIndexFromValue(Integer value) {
        for (int i = 0; i < WINDOW_POSITION_CODES.length; ++i) {
            if (value != WINDOW_POSITION_CODES[i]) continue;
            return i;
        }
        return 0;
    }

    public SupportAppPolicyEditor(Composite parent, int style, AgentPolicy policy, PolicyEditorView view) {
        super(parent, style, policy, view);
        try {
            this.policyData = SupportAppPolicy.createFromXml((String)policy.getContent());
        }
        catch (Exception e) {
            logger.error("Cannot parse support application policy XML", (Throwable)e);
            this.policyData = new SupportAppPolicy();
        }
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.setLayout((Layout)layout);
        Composite topArea = new Composite((Composite)this, 0);
        layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.numColumns = 2;
        topArea.setLayout((Layout)layout);
        topArea.setLayoutData((Object)new GridData(4, 128, true, false));
        this.createIconSelector(topArea);
        Group colorSelectors = new Group(topArea, 0);
        colorSelectors.setText("Color schema");
        layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = true;
        colorSelectors.setLayout((Layout)layout);
        colorSelectors.setLayoutData((Object)new GridData(4, 4, false, false));
        GridData gd = new GridData();
        gd.horizontalSpan = layout.numColumns;
        this.customColorSchemaCheckbox = new Button((Composite)colorSelectors, 32);
        this.customColorSchemaCheckbox.setText("Use custom color schema");
        this.customColorSchemaCheckbox.setLayoutData((Object)gd);
        this.customColorSchemaCheckbox.setSelection(this.policyData.menuBackgroundColor != null);
        this.backgroundColor = WidgetHelper.createLabeledColorSelector((Composite)colorSelectors, (String)"Background", (Object)"WidgetHelper::default_layout_data");
        this.textColor = WidgetHelper.createLabeledColorSelector((Composite)colorSelectors, (String)"Text", (Object)"WidgetHelper::default_layout_data");
        this.borderColor = WidgetHelper.createLabeledColorSelector((Composite)colorSelectors, (String)"Border", (Object)"WidgetHelper::default_layout_data");
        this.highlightColor = WidgetHelper.createLabeledColorSelector((Composite)colorSelectors, (String)"Highlight", (Object)"WidgetHelper::default_layout_data");
        this.menuBackgroundColor = WidgetHelper.createLabeledColorSelector((Composite)colorSelectors, (String)"Menu background", (Object)"WidgetHelper::default_layout_data");
        this.menuTextColor = WidgetHelper.createLabeledColorSelector((Composite)colorSelectors, (String)"Menu text", (Object)"WidgetHelper::default_layout_data");
        this.menuSelectionColor = WidgetHelper.createLabeledColorSelector((Composite)colorSelectors, (String)"Menu selection", (Object)"WidgetHelper::default_layout_data");
        this.menuHighligtColor = WidgetHelper.createLabeledColorSelector((Composite)colorSelectors, (String)"Menu highlight", (Object)"WidgetHelper::default_layout_data");
        this.notificationBackgroundColor = WidgetHelper.createLabeledColorSelector((Composite)colorSelectors, (String)"Notification background", (Object)"WidgetHelper::default_layout_data");
        this.notificationTextColor = WidgetHelper.createLabeledColorSelector((Composite)colorSelectors, (String)"Notification text", (Object)"WidgetHelper::default_layout_data");
        this.notificationSelectionColor = WidgetHelper.createLabeledColorSelector((Composite)colorSelectors, (String)"Notification selection", (Object)"WidgetHelper::default_layout_data");
        this.notificationHighligtColor = WidgetHelper.createLabeledColorSelector((Composite)colorSelectors, (String)"Notification highlight", (Object)"WidgetHelper::default_layout_data");
        Composite messageArea = new Composite(topArea, 0);
        messageArea.setLayoutData((Object)new GridData(4, 4, true, false));
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        messageArea.setLayout((Layout)layout);
        this.welcomeMessageText = new LabeledText(messageArea, 0, 2050);
        this.welcomeMessageText.setLabel("Welcome message");
        this.welcomeMessageText.setLayoutData((Object)new GridData(4, 4, true, true));
        this.tooltipMessageText = new LabeledText(messageArea, 0, 2050);
        this.tooltipMessageText.setLabel("Tooltip message");
        this.tooltipMessageText.setLayoutData((Object)new GridData(4, 4, true, true));
        Group windowBehaviorGroup = new Group(topArea, 0);
        windowBehaviorGroup.setText("Window behavior");
        windowBehaviorGroup.setLayoutData((Object)new GridData(4, 4, false, false));
        layout = new GridLayout();
        layout.numColumns = 2;
        windowBehaviorGroup.setLayout((Layout)layout);
        this.closeOnDeactivateCheckbox = new Button((Composite)windowBehaviorGroup, 32);
        this.closeOnDeactivateCheckbox.setText("Close on &deactivate");
        gd = new GridData();
        gd.horizontalSpan = layout.numColumns;
        this.closeOnDeactivateCheckbox.setLayoutData((Object)gd);
        this.windowPositioning = WidgetHelper.createLabeledCombo((Composite)windowBehaviorGroup, (int)12, (String)"Positioning", (Object)new GridData(4, 1024, true, false));
        this.windowPositioning.add("Undefined");
        this.windowPositioning.add("Automatic");
        this.windowPositioning.add("Top - Left");
        this.windowPositioning.add("Top - Center");
        this.windowPositioning.add("Top - Right");
        this.windowPositioning.add("Middle - Left");
        this.windowPositioning.add("Middle - Center");
        this.windowPositioning.add("Middle - Right");
        this.windowPositioning.add("Bottom - Left");
        this.windowPositioning.add("Bottom - Center");
        this.windowPositioning.add("Bottom - Right");
        this.windowPositioning.select(0);
        this.notificationTimeout = new LabeledSpinner((Composite)windowBehaviorGroup, 0);
        this.notificationTimeout.setLabel("Notification timeout");
        this.notificationTimeout.setRange(0, 3600);
        this.notificationTimeout.setLayoutData((Object)new GridData(4, 1024, true, false));
        this.desktopWallpaperFile = new LabeledText(topArea, 0);
        this.desktopWallpaperFile.setLabel("Desktop wallpaper file name");
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.desktopWallpaperFile.setLayoutData((Object)gd);
        String[] columnNames = new String[]{"Name", "Display name", "Command", "Icon"};
        int[] columnWidths = new int[]{300, 300, 300, 300};
        this.viewer = new SortableTreeViewer((Composite)this, columnNames, columnWidths, 0, 128, -1);
        this.viewer.setContentProvider((IContentProvider)new SupportAppMenuItemProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new SupportAppMenuItemLabelProvider());
        this.viewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        this.updateControlFromPolicy();
        2 colorChangeListener = new /* Unavailable Anonymous Inner Class!! */;
        this.backgroundColor.addListener((IPropertyChangeListener)colorChangeListener);
        this.textColor.addListener((IPropertyChangeListener)colorChangeListener);
        this.borderColor.addListener((IPropertyChangeListener)colorChangeListener);
        this.highlightColor.addListener((IPropertyChangeListener)colorChangeListener);
        this.menuBackgroundColor.addListener((IPropertyChangeListener)colorChangeListener);
        this.menuTextColor.addListener((IPropertyChangeListener)colorChangeListener);
        this.menuHighligtColor.addListener((IPropertyChangeListener)colorChangeListener);
        this.menuSelectionColor.addListener((IPropertyChangeListener)colorChangeListener);
        this.notificationBackgroundColor.addListener((IPropertyChangeListener)colorChangeListener);
        this.notificationTextColor.addListener((IPropertyChangeListener)colorChangeListener);
        this.notificationHighligtColor.addListener((IPropertyChangeListener)colorChangeListener);
        this.notificationSelectionColor.addListener((IPropertyChangeListener)colorChangeListener);
        3 textModifyListener = new /* Unavailable Anonymous Inner Class!! */;
        this.welcomeMessageText.getTextControl().addModifyListener((ModifyListener)textModifyListener);
        this.tooltipMessageText.getTextControl().addModifyListener((ModifyListener)textModifyListener);
        this.desktopWallpaperFile.getTextControl().addModifyListener((ModifyListener)textModifyListener);
        this.notificationTimeout.getSpinnerControl().addModifyListener((ModifyListener)textModifyListener);
        this.customColorSchemaCheckbox.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        5 selectionListener = new /* Unavailable Anonymous Inner Class!! */;
        this.closeOnDeactivateCheckbox.addSelectionListener((SelectionListener)selectionListener);
        this.windowPositioning.addSelectionListener((SelectionListener)selectionListener);
        this.createActions();
        this.createPopupMenu();
    }

    private void createIconSelector(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText("Application Icon");
        GridData gd = new GridData(4, 4, false, false);
        group.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        layout.makeColumnsEqualWidth = true;
        group.setLayout((Layout)layout);
        for (int i = 0; i < IMAGE_SIZE.length; ++i) {
            this.createIconPreviewControl((Composite)group, i);
        }
        Button link = new Button((Composite)group, 8);
        link.setImage(SharedIcons.IMG_FIND);
        link.setText("Select");
        link.setToolTipText("Select");
        link.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        link.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        link = new Button((Composite)group, 8);
        link.setImage(SharedIcons.IMG_CLEAR);
        link.setText("Clear");
        link.setToolTipText("Clear");
        link.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        link.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
    }

    private void createIconPreviewControl(Composite parent, int sizeIndex) {
        Composite selector = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        selector.setLayout((Layout)layout);
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        selector.setLayoutData((Object)new GridData(4, 4, true, true));
        Label title = new Label(selector, 0x1000000);
        title.setText(String.format("%dx%d", IMAGE_SIZE[sizeIndex], IMAGE_SIZE[sizeIndex]));
        GridData gd = new GridData(0x1000000, 4, true, false);
        gd.horizontalSpan = 2;
        title.setLayoutData((Object)gd);
        this.iconBox[sizeIndex] = new Label(selector, 0x1000800);
        gd = new GridData(4, 4, true, true);
        gd.widthHint = 128;
        gd.heightHint = 128;
        gd.horizontalSpan = 2;
        this.iconBox[sizeIndex].setLayoutData((Object)gd);
    }

    protected void createActions() {
        this.addSubMenuAction = new /* Unavailable Anonymous Inner Class!! */;
        this.addItemAction = new /* Unavailable Anonymous Inner Class!! */;
        this.editAction = new /* Unavailable Anonymous Inner Class!! */;
        this.deleteAction = new /* Unavailable Anonymous Inner Class!! */;
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)new /* Unavailable Anonymous Inner Class!! */);
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    private void deleteMenuItems() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        for (Object o : selection.toList()) {
            ((AppMenuItem)o).delete();
        }
        this.fireModifyListeners();
    }

    private void editMenuItem() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() != 1) {
            return;
        }
        AppMenuItem menuItem = (AppMenuItem)selection.getFirstElement();
        MenuItemDialog dlg = new MenuItemDialog(this.getShell(), menuItem);
        if (dlg.open() != 0) {
            return;
        }
        this.viewer.refresh((Object)menuItem);
        this.fireModifyListeners();
    }

    private void createMenuItem(boolean isSubMenu) {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        MenuItemDialog dlg = new MenuItemDialog(this.getShell(), isSubMenu);
        if (dlg.open() != 0) {
            return;
        }
        if (selection.isEmpty()) {
            this.policyData.menu.addSubItem(dlg.getItem());
        } else {
            ((AppMenuItem)selection.getFirstElement()).addSubItem(dlg.getItem());
        }
        this.viewer.refresh();
        this.fireModifyListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectIcon() {
        FileDialog dlg = new FileDialog(this.getShell(), 4096);
        WidgetHelper.setFileDialogFilterExtensions((FileDialog)dlg, (String[])new String[]{"*.ico", "*.*"});
        WidgetHelper.setFileDialogFilterNames((FileDialog)dlg, (String[])new String[]{"Icon files", "All files"});
        String fileName = dlg.open();
        if (fileName == null) {
            return;
        }
        InputStream in = null;
        try {
            int bytes;
            in = new FileInputStream(new File(fileName));
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buffer = new byte[8192];
            while ((bytes = in.read(buffer)) > 0) {
                out.write(buffer, 0, bytes);
            }
            this.iconFile = out.toByteArray();
            this.updateIconPreview();
            this.fireModifyListeners();
        }
        catch (Exception e) {
            MessageDialogHelper.openError((Shell)this.getShell(), (String)"Error", (String)String.format("Cannot load image: %s", e.getLocalizedMessage()));
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void updateIconPreview() {
        int i;
        for (i = 0; i < IMAGE_SIZE.length; ++i) {
            if (this.iconPreview[i] == null) continue;
            this.iconPreview[i].dispose();
            this.iconPreview[i] = null;
        }
        if (this.iconFile != null && this.iconFile.length != 0) {
            ByteArrayInputStream input = new ByteArrayInputStream(this.iconFile);
            try {
                ImageLoader loader = new ImageLoader();
                ImageData[] data = loader.load((InputStream)input);
                block3: for (int i2 = 0; i2 < data.length; ++i2) {
                    for (int j = 0; j < IMAGE_SIZE.length; ++j) {
                        int size = IMAGE_SIZE[j];
                        if (data[i2].width != size || data[i2].height != size) continue;
                        if (this.iconPreview[j] != null) {
                            this.iconPreview[j].dispose();
                        }
                        this.iconPreview[j] = new Image((Device)this.getDisplay(), data[i2]);
                        continue block3;
                    }
                }
            }
            catch (Exception e) {
                logger.error("Exception while updating ", (Throwable)e);
            }
        }
        for (i = 0; i < IMAGE_SIZE.length; ++i) {
            this.iconBox[i].setImage(this.iconPreview[i]);
        }
    }

    private void updateIconFromPolicy() {
        this.iconFile = this.policyData.getIcon();
        this.updateIconPreview();
    }

    public void updateControlFromPolicy() {
        this.updateIconFromPolicy();
        if (this.policyData.backgroundColor != null) {
            this.backgroundColor.setColorValue(ColorConverter.rgbFromInt((int)this.policyData.backgroundColor));
        }
        if (this.policyData.borderColor != null) {
            this.borderColor.setColorValue(ColorConverter.rgbFromInt((int)this.policyData.borderColor));
        }
        if (this.policyData.highlightColor != null) {
            this.highlightColor.setColorValue(ColorConverter.rgbFromInt((int)this.policyData.highlightColor));
        }
        if (this.policyData.textColor != null) {
            this.textColor.setColorValue(ColorConverter.rgbFromInt((int)this.policyData.textColor));
        }
        if (this.policyData.menuBackgroundColor != null) {
            this.menuBackgroundColor.setColorValue(ColorConverter.rgbFromInt((int)this.policyData.menuBackgroundColor));
        }
        if (this.policyData.menuHighligtColor != null) {
            this.menuHighligtColor.setColorValue(ColorConverter.rgbFromInt((int)this.policyData.menuHighligtColor));
        }
        if (this.policyData.menuSelectionColor != null) {
            this.menuSelectionColor.setColorValue(ColorConverter.rgbFromInt((int)this.policyData.menuSelectionColor));
        }
        if (this.policyData.menuTextColor != null) {
            this.menuTextColor.setColorValue(ColorConverter.rgbFromInt((int)this.policyData.menuTextColor));
        }
        if (this.policyData.notificationBackgroundColor != null) {
            this.notificationBackgroundColor.setColorValue(ColorConverter.rgbFromInt((int)this.policyData.notificationBackgroundColor));
        }
        if (this.policyData.notificationHighligtColor != null) {
            this.notificationHighligtColor.setColorValue(ColorConverter.rgbFromInt((int)this.policyData.notificationHighligtColor));
        }
        if (this.policyData.notificationSelectionColor != null) {
            this.notificationSelectionColor.setColorValue(ColorConverter.rgbFromInt((int)this.policyData.notificationSelectionColor));
        }
        if (this.policyData.notificationTextColor != null) {
            this.notificationTextColor.setColorValue(ColorConverter.rgbFromInt((int)this.policyData.notificationTextColor));
        }
        this.customColorSchemaCheckbox.setSelection(this.policyData.customColorSchema);
        this.backgroundColor.setEnabled(this.policyData.customColorSchema);
        this.textColor.setEnabled(this.policyData.customColorSchema);
        this.borderColor.setEnabled(this.policyData.customColorSchema);
        this.highlightColor.setEnabled(this.policyData.customColorSchema);
        this.menuBackgroundColor.setEnabled(this.policyData.customColorSchema);
        this.menuTextColor.setEnabled(this.policyData.customColorSchema);
        this.menuHighligtColor.setEnabled(this.policyData.customColorSchema);
        this.menuSelectionColor.setEnabled(this.policyData.customColorSchema);
        this.notificationBackgroundColor.setEnabled(this.policyData.customColorSchema);
        this.notificationTextColor.setEnabled(this.policyData.customColorSchema);
        this.notificationHighligtColor.setEnabled(this.policyData.customColorSchema);
        this.notificationSelectionColor.setEnabled(this.policyData.customColorSchema);
        this.welcomeMessageText.setText(this.policyData.welcomeMessage != null ? this.policyData.welcomeMessage : "");
        this.tooltipMessageText.setText(this.policyData.tooltipMessage != null ? this.policyData.tooltipMessage : "");
        this.desktopWallpaperFile.setText(this.policyData.desktopWallpaper);
        this.closeOnDeactivateCheckbox.setSelection(this.policyData.closeOnDeactivate);
        this.windowPositioning.select(SupportAppPolicyEditor.windowPositionIndexFromValue((Integer)this.policyData.mainWindowPosition));
        this.notificationTimeout.setSelection(this.policyData.notificationTimeout != null ? this.policyData.notificationTimeout / 1000 : 0);
        this.viewer.setInput((Object)new Object[]{this.policyData.menu});
    }

    public void updatePolicyFromControl() {
        this.policyData.setIcon(this.iconFile != null && this.iconFile.length > 0 ? this.iconFile : null);
        this.policyData.welcomeMessage = this.welcomeMessageText.getText();
        this.policyData.tooltipMessage = this.tooltipMessageText.getText();
        this.policyData.desktopWallpaper = this.desktopWallpaperFile.getText();
        this.policyData.customColorSchema = this.customColorSchemaCheckbox.getSelection();
        this.policyData.backgroundColor = ColorConverter.rgbToInt((RGB)this.backgroundColor.getColorValue());
        this.policyData.borderColor = ColorConverter.rgbToInt((RGB)this.borderColor.getColorValue());
        this.policyData.highlightColor = ColorConverter.rgbToInt((RGB)this.highlightColor.getColorValue());
        this.policyData.textColor = ColorConverter.rgbToInt((RGB)this.textColor.getColorValue());
        this.policyData.menuBackgroundColor = ColorConverter.rgbToInt((RGB)this.menuBackgroundColor.getColorValue());
        this.policyData.menuHighligtColor = ColorConverter.rgbToInt((RGB)this.menuHighligtColor.getColorValue());
        this.policyData.menuSelectionColor = ColorConverter.rgbToInt((RGB)this.menuSelectionColor.getColorValue());
        this.policyData.menuTextColor = ColorConverter.rgbToInt((RGB)this.menuTextColor.getColorValue());
        this.policyData.notificationBackgroundColor = ColorConverter.rgbToInt((RGB)this.notificationBackgroundColor.getColorValue());
        this.policyData.notificationHighligtColor = ColorConverter.rgbToInt((RGB)this.notificationHighligtColor.getColorValue());
        this.policyData.notificationSelectionColor = ColorConverter.rgbToInt((RGB)this.notificationSelectionColor.getColorValue());
        this.policyData.notificationTextColor = ColorConverter.rgbToInt((RGB)this.notificationTextColor.getColorValue());
        this.policyData.closeOnDeactivate = this.closeOnDeactivateCheckbox.getSelection();
        this.policyData.mainWindowPosition = WINDOW_POSITION_CODES[this.windowPositioning.getSelectionIndex()];
        int timeout = this.notificationTimeout.getSelection();
        this.policyData.notificationTimeout = timeout > 0 ? Integer.valueOf(timeout * 1000) : null;
        try {
            this.policy.setContent(this.policyData.createXml());
        }
        catch (Exception e) {
            this.policy.setContent("");
            e.printStackTrace();
        }
    }
}

