/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.events.propertypages;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.netxms.nxmc.base.dialogs.KeyValuePairEditDialog;
import org.netxms.nxmc.base.widgets.KeyValueSetEditor;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.events.propertypages.RuleBasePropertyPage;
import org.netxms.nxmc.modules.events.widgets.RuleEditor;
import org.netxms.nxmc.tools.ElementLabelComparator;
import org.xnap.commons.i18n.I18n;

public class RulePersistentStorage
extends RuleBasePropertyPage {
    private static final I18n i18n = LocalizationHelper.getI18n(RulePersistentStorage.class);
    private KeyValueSetEditor keysToSetEditor;
    private SortableTableViewer keysToDeleteViewer;
    private Button addToDeleteListButton;
    private Button editDeleteListButton;
    private Button removeFromDeleteListButton;
    private List<String> keysToDelete = new ArrayList(0);

    public RulePersistentStorage(RuleEditor editor) {
        super(editor, i18n.tr("Persistent Storage"));
    }

    protected Control createContents(Composite parent) {
        this.keysToDelete.addAll(this.rule.getPStorageDelete());
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        int vInd = 2;
        Label label = new Label(dialogArea, 0);
        label.setText(i18n.tr("Set persistent storage values"));
        GridData gd = new GridData();
        gd.verticalIndent = 2;
        label.setLayoutData((Object)gd);
        this.keysToSetEditor = new KeyValueSetEditor(dialogArea, 0, i18n.tr("Key"));
        this.keysToSetEditor.addAll(this.rule.getPStorageSet());
        gd = new GridData();
        gd.verticalIndent = 2;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.keysToSetEditor.setLayoutData((Object)gd);
        label = new Label(dialogArea, 0);
        label.setText("Delete persistent storage entries");
        gd = new GridData();
        gd.verticalIndent = 2;
        label.setLayoutData((Object)gd);
        String[] deleteColumnNames = new String[]{"Key"};
        int[] deleteColumnWidths = new int[]{150};
        this.keysToDeleteViewer = new SortableTableViewer(dialogArea, deleteColumnNames, deleteColumnWidths, 0, 128, 67586);
        this.keysToDeleteViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.keysToDeleteViewer.setComparator((ViewerComparator)new ElementLabelComparator((ILabelProvider)this.keysToDeleteViewer.getLabelProvider()));
        this.keysToDeleteViewer.setInput((Object)this.keysToDelete.toArray());
        this.keysToDeleteViewer.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        gd = new GridData();
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.keysToDeleteViewer.getControl().setLayoutData((Object)gd);
        Composite buttonsDeleteValue = new Composite(dialogArea, 0);
        RowLayout buttonLayout = new RowLayout();
        buttonLayout.type = 256;
        buttonLayout.pack = false;
        buttonLayout.marginLeft = 0;
        buttonLayout.marginRight = 0;
        buttonsDeleteValue.setLayout((Layout)buttonLayout);
        gd = new GridData();
        gd.horizontalAlignment = 131072;
        buttonsDeleteValue.setLayoutData((Object)gd);
        this.addToDeleteListButton = new Button(buttonsDeleteValue, 8);
        this.addToDeleteListButton.setText(i18n.tr("&Add..."));
        this.addToDeleteListButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        RowData rd = new RowData();
        rd.width = 90;
        this.addToDeleteListButton.setLayoutData((Object)rd);
        this.editDeleteListButton = new Button(buttonsDeleteValue, 8);
        this.editDeleteListButton.setText(i18n.tr("&Edit..."));
        this.editDeleteListButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        rd = new RowData();
        rd.width = 90;
        this.editDeleteListButton.setLayoutData((Object)rd);
        this.editDeleteListButton.setEnabled(false);
        this.removeFromDeleteListButton = new Button(buttonsDeleteValue, 8);
        this.removeFromDeleteListButton.setText(i18n.tr("&Delete"));
        this.removeFromDeleteListButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        rd = new RowData();
        rd.width = 90;
        this.removeFromDeleteListButton.setLayoutData((Object)rd);
        this.removeFromDeleteListButton.setEnabled(false);
        return dialogArea;
    }

    private void addPStorageDeleteAction() {
        KeyValuePairEditDialog dlg = new KeyValuePairEditDialog(this.getShell(), null, null, false, false, i18n.tr("Key"));
        if (dlg.open() == 0) {
            this.keysToDelete.add(dlg.getKey());
            this.keysToDeleteViewer.setInput((Object)this.keysToDelete.toArray());
        }
    }

    private void editPStorageDeleteAction() {
        IStructuredSelection selection = this.keysToDeleteViewer.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        String attr = (String)selection.getFirstElement();
        KeyValuePairEditDialog dlg = new KeyValuePairEditDialog(this.getShell(), attr, null, false, false, i18n.tr("Key"));
        if (dlg.open() == 0) {
            this.keysToDelete.set(this.keysToDelete.indexOf(attr), dlg.getKey());
            this.keysToDeleteViewer.setInput((Object)this.keysToDelete.toArray());
        }
    }

    private void deletePStorageDeleteAction() {
        IStructuredSelection selection = this.keysToDeleteViewer.getStructuredSelection();
        Iterator it = selection.iterator();
        if (it.hasNext()) {
            while (it.hasNext()) {
                String e = (String)it.next();
                this.keysToDelete.remove(e);
            }
            this.keysToDeleteViewer.setInput((Object)this.keysToDelete.toArray());
        }
    }

    protected boolean applyChanges(boolean isApply) {
        this.rule.setPStorageSet(this.keysToSetEditor.getContent());
        this.rule.setPStorageDelete(this.keysToDelete);
        this.editor.setModified(true);
        return true;
    }
}

