/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.events.propertypages;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.ServerAction;
import org.netxms.client.events.ActionExecutionConfiguration;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.actions.dialogs.ActionSelectionDialog;
import org.netxms.nxmc.modules.events.dialogs.ActionExecutionConfigurationDialog;
import org.netxms.nxmc.modules.events.propertypages.RuleBasePropertyPage;
import org.netxms.nxmc.modules.events.propertypages.helpers.ActionListLabelProvider;
import org.netxms.nxmc.modules.events.widgets.RuleEditor;
import org.netxms.nxmc.tools.ElementLabelComparator;
import org.xnap.commons.i18n.I18n;

public class RuleServerActions
extends RuleBasePropertyPage {
    private static final I18n i18n = LocalizationHelper.getI18n(RuleServerActions.class);
    private SortableTableViewer viewer;
    private List<ActionExecutionConfiguration> actions = new ArrayList();
    private Button addButton;
    private Button editButton;
    private Button deleteButton;

    public RuleServerActions(RuleEditor editor) {
        super(editor, i18n.tr("Server Actions"));
    }

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        String[] columnNames = new String[]{i18n.tr("Action"), i18n.tr("Delay"), i18n.tr("Delay timer key"), i18n.tr("Snooze time"), i18n.tr("Snooze/blocking timer key")};
        int[] columnWidths = new int[]{300, 90, 200, 90, 200};
        this.viewer = new SortableTableViewer(dialogArea, columnNames, columnWidths, 0, 128, 67586);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ActionListLabelProvider(this.editor.getEditorView()));
        this.viewer.setComparator((ViewerComparator)new ElementLabelComparator((ILabelProvider)this.viewer.getLabelProvider()));
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.addDoubleClickListener((IDoubleClickListener)new /* Unavailable Anonymous Inner Class!! */);
        for (ActionExecutionConfiguration c : this.rule.getActions()) {
            this.actions.add(new ActionExecutionConfiguration(c));
        }
        this.viewer.setInput((Object)this.actions);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.heightHint = 0;
        this.viewer.getControl().setLayoutData((Object)gridData);
        Composite buttons = new Composite(dialogArea, 0);
        RowLayout buttonLayout = new RowLayout();
        buttonLayout.type = 256;
        buttonLayout.pack = false;
        buttonLayout.marginLeft = 0;
        buttonLayout.marginRight = 0;
        buttons.setLayout((Layout)buttonLayout);
        gridData = new GridData();
        gridData.horizontalAlignment = 131072;
        buttons.setLayoutData((Object)gridData);
        this.addButton = new Button(buttons, 8);
        this.addButton.setText(i18n.tr("&Add..."));
        this.addButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        RowData rd = new RowData();
        rd.width = 90;
        this.addButton.setLayoutData((Object)rd);
        this.editButton = new Button(buttons, 8);
        this.editButton.setText(i18n.tr("&Edit..."));
        this.editButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        rd = new RowData();
        rd.width = 90;
        this.editButton.setLayoutData((Object)rd);
        this.deleteButton = new Button(buttons, 8);
        this.deleteButton.setText(i18n.tr("Delete"));
        this.deleteButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        rd = new RowData();
        rd.width = 90;
        this.deleteButton.setLayoutData((Object)rd);
        this.deleteButton.setEnabled(false);
        return dialogArea;
    }

    private void addAction() {
        ActionSelectionDialog dlg = new ActionSelectionDialog(this.getShell(), this.editor.getEditorView().getActions());
        if (dlg.open() == 0) {
            for (ServerAction a : dlg.getSelection()) {
                this.actions.add(new ActionExecutionConfiguration(a.getId(), null, null, null, null));
            }
        }
        this.viewer.refresh();
    }

    private void editAction() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        ActionExecutionConfigurationDialog dlg = new ActionExecutionConfigurationDialog(this.getShell(), (ActionExecutionConfiguration)selection.getFirstElement());
        if (dlg.open() == 0) {
            this.viewer.update(selection.getFirstElement(), null);
        }
    }

    private void deleteAction() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        Iterator it = selection.iterator();
        if (it.hasNext()) {
            while (it.hasNext()) {
                ActionExecutionConfiguration a = (ActionExecutionConfiguration)it.next();
                this.actions.remove(a);
            }
            this.viewer.refresh();
        }
    }

    protected boolean applyChanges(boolean isApply) {
        this.rule.setActions(this.actions);
        this.editor.setModified(true);
        return true;
    }
}

