/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.events.widgets;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.netxms.client.NXCSession;
import org.netxms.client.ServerAction;
import org.netxms.client.constants.Severity;
import org.netxms.client.events.ActionExecutionConfiguration;
import org.netxms.client.events.AlarmCategory;
import org.netxms.client.events.EventProcessingPolicyRule;
import org.netxms.client.events.EventTemplate;
import org.netxms.client.events.TimeFrame;
import org.netxms.client.objects.AbstractObject;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.widgets.Card;
import org.netxms.nxmc.base.widgets.helpers.DashboardElementButton;
import org.netxms.nxmc.localization.DateFormatFactory;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.events.propertypages.RuleAction;
import org.netxms.nxmc.modules.events.propertypages.RuleActionScript;
import org.netxms.nxmc.modules.events.propertypages.RuleAlarm;
import org.netxms.nxmc.modules.events.propertypages.RuleComments;
import org.netxms.nxmc.modules.events.propertypages.RuleCondition;
import org.netxms.nxmc.modules.events.propertypages.RuleCustomAttribute;
import org.netxms.nxmc.modules.events.propertypages.RuleEvents;
import org.netxms.nxmc.modules.events.propertypages.RuleFilteringScript;
import org.netxms.nxmc.modules.events.propertypages.RulePersistentStorage;
import org.netxms.nxmc.modules.events.propertypages.RuleServerActions;
import org.netxms.nxmc.modules.events.propertypages.RuleSeverityFilter;
import org.netxms.nxmc.modules.events.propertypages.RuleSourceObjects;
import org.netxms.nxmc.modules.events.propertypages.RuleTimeFilter;
import org.netxms.nxmc.modules.events.propertypages.RuleTimerCancellations;
import org.netxms.nxmc.modules.events.views.EventProcessingPolicyEditor;
import org.netxms.nxmc.modules.events.widgets.RuleEditor;
import org.netxms.nxmc.modules.nxsl.widgets.ScriptEditor;
import org.netxms.nxmc.resources.SharedIcons;
import org.netxms.nxmc.resources.StatusDisplayInfo;
import org.netxms.nxmc.resources.ThemeEngine;
import org.xnap.commons.i18n.I18n;

public class RuleEditor
extends Composite {
    private static final int INDENT = 20;
    private final I18n i18n = LocalizationHelper.getI18n(RuleEditor.class);
    private EventProcessingPolicyRule rule;
    private int ruleNumber;
    private EventProcessingPolicyEditor editor;
    private NXCSession session;
    private boolean collapsed = true;
    private boolean verticalLayout = false;
    private Composite leftPanel;
    private Label ruleNumberLabel;
    private Composite header;
    private Label headerLabel;
    private Composite mainArea;
    private Card condition;
    private Card action;
    private Label expandButton;
    private Label editButton;
    private boolean modified = false;
    private boolean selected = false;
    private MouseListener ruleMouseListener;

    public RuleEditor(Composite parent, EventProcessingPolicyRule rule, EventProcessingPolicyEditor editor) {
        super(parent, 0);
        this.rule = rule;
        this.ruleNumber = rule.getRuleNumber();
        this.editor = editor;
        this.session = Registry.getSession();
        this.setBackground(ThemeEngine.getBackgroundColor((String)"RuleEditor.Border.Rule"));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 1;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 1;
        layout.verticalSpacing = 1;
        this.setLayout((Layout)layout);
        this.ruleMouseListener = new /* Unavailable Anonymous Inner Class!! */;
        this.createLeftPanel();
        this.createHeader();
        this.createMainArea();
        this.createPopupMenu(new Control[]{this.leftPanel, this.ruleNumberLabel, this.header, this.headerLabel});
        this.condition = new /* Unavailable Anonymous Inner Class!! */;
        this.configureLayout((Control)this.condition);
        3 editRuleCondition = new /* Unavailable Anonymous Inner Class!! */;
        this.condition.addButton(new DashboardElementButton(this.i18n.tr("Edit condition"), SharedIcons.IMG_EDIT, (Action)editRuleCondition));
        this.condition.setDoubleClickAction((Action)editRuleCondition);
        this.action = new /* Unavailable Anonymous Inner Class!! */;
        this.configureLayout((Control)this.action);
        5 editRuleAction = new /* Unavailable Anonymous Inner Class!! */;
        this.action.addButton(new DashboardElementButton(this.i18n.tr("Edit actions"), SharedIcons.IMG_EDIT, (Action)editRuleAction));
        this.action.setDoubleClickAction((Action)editRuleAction);
        this.dragEnable();
        this.dropEnable();
    }

    private void dragEnable() {
        DragSource source = new DragSource((Control)this.headerLabel, 2);
        source.setTransfer(new Transfer[]{LocalSelectionTransfer.getTransfer()});
        source.addDragListener((DragSourceListener)new RuleDragSourceListener(this));
    }

    private void dropEnable() {
        DropTarget target = new DropTarget((Control)this, 2);
        target.setTransfer(new Transfer[]{LocalSelectionTransfer.getTransfer()});
        target.addDropListener((DropTargetListener)new RuleDropTargetListener(this));
    }

    private void createMainArea() {
        this.mainArea = new Composite((Composite)this, 0);
        this.mainArea.setBackground(ThemeEngine.getBackgroundColor((String)"Dashboard"));
        GridLayout layout = new GridLayout();
        layout.numColumns = this.verticalLayout ? 1 : 2;
        layout.marginHeight = 4;
        layout.marginWidth = 4;
        layout.makeColumnsEqualWidth = true;
        this.mainArea.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.exclude = this.collapsed;
        this.mainArea.setLayoutData((Object)gd);
    }

    private void createLeftPanel() {
        this.leftPanel = new Composite((Composite)this, 0);
        this.leftPanel.setBackground(ThemeEngine.getBackgroundColor((String)(this.rule.isDisabled() ? "RuleEditor.Title.Disabled" : "RuleEditor.Title.Normal")));
        this.leftPanel.addMouseListener(this.ruleMouseListener);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.leftPanel.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.verticalSpan = this.collapsed ? 1 : 2;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        this.leftPanel.setLayoutData((Object)gd);
        this.ruleNumberLabel = new Label(this.leftPanel, 0);
        this.ruleNumberLabel.setText(Integer.toString(this.ruleNumber));
        this.ruleNumberLabel.setFont(this.editor.getBoldFont());
        this.ruleNumberLabel.setBackground(this.leftPanel.getBackground());
        this.ruleNumberLabel.setForeground(ThemeEngine.getForegroundColor((String)"RuleEditor.Title"));
        this.ruleNumberLabel.setAlignment(0x1000000);
        this.ruleNumberLabel.addMouseListener(this.ruleMouseListener);
        gd = new GridData();
        gd.horizontalAlignment = 0x1000000;
        gd.verticalAlignment = 0x1000000;
        gd.grabExcessVerticalSpace = true;
        gd.widthHint = 30;
        this.ruleNumberLabel.setLayoutData((Object)gd);
    }

    private void createPopupMenu(Control[] controls) {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)new /* Unavailable Anonymous Inner Class!! */);
        for (Control c : controls) {
            Menu menu = menuMgr.createContextMenu(c);
            c.setMenu(menu);
        }
    }

    private void createHeader() {
        7 headerMouseListener = new /* Unavailable Anonymous Inner Class!! */;
        this.header = new Composite((Composite)this, 0);
        this.header.setBackground(ThemeEngine.getBackgroundColor((String)(this.rule.isDisabled() ? "RuleEditor.Title.Disabled" : "RuleEditor.Title.Normal")));
        this.header.addMouseListener((MouseListener)headerMouseListener);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        this.header.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.header.setLayoutData((Object)gd);
        this.headerLabel = new Label(this.header, 0);
        if (this.rule.isDisabled()) {
            this.headerLabel.setText(this.rule.getComments() + this.i18n.tr(" (disabled)"));
        } else {
            this.headerLabel.setText(this.rule.getComments());
        }
        this.headerLabel.setBackground(this.header.getBackground());
        this.headerLabel.setForeground(ThemeEngine.getForegroundColor((String)"RuleEditor.Title"));
        this.headerLabel.setFont(this.editor.getNormalFont());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.headerLabel.setLayoutData((Object)gd);
        this.headerLabel.addMouseListener((MouseListener)headerMouseListener);
        this.editButton = new Label(this.header, 0);
        this.editButton.setBackground(this.header.getBackground());
        this.editButton.setCursor(this.getDisplay().getSystemCursor(21));
        this.editButton.setImage(SharedIcons.IMG_EDIT);
        this.editButton.setToolTipText(this.i18n.tr("Edit rule"));
        this.editButton.addMouseListener((MouseListener)new /* Unavailable Anonymous Inner Class!! */);
        this.expandButton = new Label(this.header, 0);
        this.expandButton.setBackground(this.header.getBackground());
        this.expandButton.setCursor(this.getDisplay().getSystemCursor(21));
        this.expandButton.setImage(this.collapsed ? SharedIcons.IMG_EXPAND : SharedIcons.IMG_COLLAPSE);
        this.expandButton.setToolTipText(this.collapsed ? this.i18n.tr("Expand rule") : this.i18n.tr("Collapse rule"));
        this.expandButton.addMouseListener((MouseListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void configureLayout(Control ctrl) {
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        ctrl.setLayoutData((Object)gd);
    }

    private MouseListener createMouseListener(String pageId) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private Control createConditionControl(Composite parent, EventProcessingPolicyRule rule) {
        CLabel clabel;
        MouseListener listener;
        Composite clientArea = new Composite(parent, 0);
        clientArea.setBackground(ThemeEngine.getBackgroundColor((String)"RuleEditor"));
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 0;
        clientArea.setLayout((Layout)layout);
        boolean needAnd = false;
        if ((rule.getSources().size() > 0 || rule.getSourceExclusions().size() > 0) && rule.isSourceInverted() || rule.getSources().size() == 0 && rule.getSourceExclusions().size() == 0 && rule.getEvents().size() > 0 && rule.isEventsInverted()) {
            this.createLabel(clientArea, 0, true, this.i18n.tr("IF NOT"), null);
        } else {
            this.createLabel(clientArea, 0, true, this.i18n.tr("IF"), null);
        }
        if (rule.getSources().size() > 0 || rule.getSourceExclusions().size() > 0) {
            listener = this.createMouseListener("SourceObjects");
            this.addConditionGroupLabel(clientArea, this.i18n.tr("source object is one of the following:"), needAnd, rule.isSourceInverted(), listener);
            List sortedObjects = this.session.findMultipleObjects((Collection)rule.getSources(), true);
            sortedObjects.sort(new /* Unavailable Anonymous Inner Class!! */);
            for (AbstractObject object : sortedObjects) {
                clabel = this.createCLabel(clientArea, 2, false);
                clabel.addMouseListener(listener);
                clabel.setText(object.getObjectName());
                clabel.setImage(this.editor.getObjectLabelProvider().getImage((Object)object));
            }
            if (rule.getSourceExclusions().size() > 0) {
                this.addConditionGroupLabel(clientArea, "except:", needAnd, rule.isSourceInverted(), listener);
            }
            sortedObjects = this.session.findMultipleObjects((Collection)rule.getSourceExclusions(), true);
            sortedObjects.sort(new /* Unavailable Anonymous Inner Class!! */);
            for (AbstractObject object : sortedObjects) {
                clabel = this.createCLabel(clientArea, 2, false);
                clabel.addMouseListener(listener);
                clabel.setText(object.getObjectName());
                clabel.setImage(this.editor.getObjectLabelProvider().getImage((Object)object));
            }
            needAnd = true;
        }
        if (rule.getEvents().size() > 0) {
            listener = this.createMouseListener("Events");
            this.addConditionGroupLabel(clientArea, this.i18n.tr("event code is one of the following:"), needAnd, rule.isEventsInverted(), listener);
            ArrayList<EventTemplate> sortedEvents = new ArrayList<EventTemplate>(rule.getEvents().size());
            for (Long code : rule.getEvents()) {
                EventTemplate event = this.session.findEventTemplateByCode(code.longValue());
                if (event == null) {
                    event = new EventTemplate(code.longValue());
                    event.setSeverity(Severity.UNKNOWN);
                    event.setName("[" + code.toString() + "]");
                }
                sortedEvents.add(event);
            }
            Collections.sort(sortedEvents, new /* Unavailable Anonymous Inner Class!! */);
            for (EventTemplate e : sortedEvents) {
                clabel = this.createCLabel(clientArea, 2, false);
                clabel.addMouseListener(listener);
                clabel.setText(e.getName());
                clabel.setImage(StatusDisplayInfo.getStatusImage((Severity)e.getSeverity()));
            }
            needAnd = true;
        }
        if (rule.getTimeFrames().size() != 0) {
            listener = this.createMouseListener("TimeFilter");
            this.addConditionGroupLabel(clientArea, "current time is within:", needAnd, rule.isTimeFramesInverted(), listener);
            DateFormat dfTime = DateFormatFactory.getShortTimeFormat();
            for (TimeFrame tf : rule.getTimeFrames()) {
                clabel = this.createCLabel(clientArea, 2, false);
                clabel.addMouseListener(listener);
                clabel.setText(tf.getFormattedDateString(dfTime, Locale.getDefault()));
            }
            needAnd = true;
        }
        if ((rule.getFlags() & 0x1F00) != 7936) {
            listener = this.createMouseListener("SeverityFilter");
            this.addConditionGroupLabel(clientArea, this.i18n.tr("event severity is one of the following:"), needAnd, false, listener);
            if ((rule.getFlags() & 0x100) != 0) {
                this.addSeverityLabel(clientArea, Severity.NORMAL, listener);
            }
            if ((rule.getFlags() & 0x200) != 0) {
                this.addSeverityLabel(clientArea, Severity.WARNING, listener);
            }
            if ((rule.getFlags() & 0x400) != 0) {
                this.addSeverityLabel(clientArea, Severity.MINOR, listener);
            }
            if ((rule.getFlags() & 0x800) != 0) {
                this.addSeverityLabel(clientArea, Severity.MAJOR, listener);
            }
            if ((rule.getFlags() & 0x1000) != 0) {
                this.addSeverityLabel(clientArea, Severity.CRITICAL, listener);
            }
            needAnd = true;
        }
        if (rule.getFilterScript() != null && !rule.getFilterScript().isEmpty()) {
            listener = this.createMouseListener("FilteringScript");
            this.addConditionGroupLabel(clientArea, this.i18n.tr("the following script returns true:"), needAnd, false, listener);
            ScriptEditor scriptEditor = new ScriptEditor(clientArea, 2048, 0, true, false);
            GridData gd = new GridData();
            gd.horizontalIndent = 40;
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            scriptEditor.setLayoutData((Object)gd);
            scriptEditor.setText(rule.getFilterScript());
            scriptEditor.getTextWidget().setEditable(false);
            scriptEditor.getTextWidget().addMouseListener(listener);
        }
        return clientArea;
    }

    private Label createLabel(Composite parent, int indent, boolean bold, String text, MouseListener mouseListener) {
        Label label = new Label(parent, 0);
        label.setBackground(ThemeEngine.getBackgroundColor((String)"RuleEditor"));
        label.setFont(bold ? this.editor.getBoldFont() : this.editor.getNormalFont());
        label.setText(text);
        GridData gd = new GridData();
        gd.horizontalIndent = 20 * indent;
        label.setLayoutData((Object)gd);
        if (mouseListener != null) {
            label.addMouseListener(mouseListener);
        }
        return label;
    }

    private CLabel createCLabel(Composite parent, int indent, boolean bold) {
        CLabel label = new CLabel(parent, 0);
        label.setBackground(ThemeEngine.getBackgroundColor((String)"RuleEditor"));
        label.setFont(bold ? this.editor.getBoldFont() : this.editor.getNormalFont());
        GridData gd = new GridData();
        gd.horizontalIndent = 20 * indent;
        label.setLayoutData((Object)gd);
        return label;
    }

    private void addConditionGroupLabel(Composite parent, String title, boolean needAnd, boolean inverted, MouseListener mouseListener) {
        if (needAnd) {
            this.createLabel(parent, 0, true, inverted ? this.i18n.tr("AND NOT") : this.i18n.tr("AND"), null);
        }
        this.createLabel(parent, 1, false, title, mouseListener);
    }

    private void addSeverityLabel(Composite parent, Severity severity, MouseListener mouseListener) {
        CLabel clabel = this.createCLabel(parent, 2, false);
        clabel.setText(StatusDisplayInfo.getStatusText((Severity)severity));
        clabel.setImage(StatusDisplayInfo.getStatusImage((Severity)severity));
        clabel.addMouseListener(mouseListener);
    }

    /*
     * WARNING - void declaration
     */
    private Control createActionControl(Composite parent, EventProcessingPolicyRule rule) {
        CLabel clabel;
        MouseListener listener;
        Composite clientArea = new Composite(parent, 0);
        clientArea.setBackground(ThemeEngine.getBackgroundColor((String)"RuleEditor"));
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 0;
        clientArea.setLayout((Layout)layout);
        if ((rule.getFlags() & 8) != 0) {
            listener = this.createMouseListener("Alarm");
            if (rule.getAlarmSeverity().compareTo((Enum)Severity.TERMINATE) < 0) {
                this.addActionGroupLabel(clientArea, this.i18n.tr("Generate alarm"), this.editor.getImageAlarm(), listener);
                CLabel clabel2 = this.createCLabel(clientArea, 1, false);
                clabel2.setImage(StatusDisplayInfo.getStatusImage((Severity)rule.getAlarmSeverity()));
                clabel2.setText(rule.getAlarmMessage());
                clabel2.addMouseListener(listener);
                if (rule.getAlarmKey() != null && !rule.getAlarmKey().isEmpty()) {
                    this.createLabel(clientArea, 1, false, String.format(this.i18n.tr("with key \"%s\""), rule.getAlarmKey()), listener);
                }
                if (rule.getRcaScriptName() != null && !rule.getRcaScriptName().isEmpty()) {
                    this.createLabel(clientArea, 1, false, String.format(this.i18n.tr("using root cause analysis script \"%s\""), rule.getRcaScriptName()), listener);
                }
            } else if (rule.getAlarmSeverity() == Severity.TERMINATE) {
                this.addActionGroupLabel(clientArea, this.i18n.tr("Terminate alarms"), this.editor.getImageTerminate(), listener);
                this.createLabel(clientArea, 1, false, String.format(this.i18n.tr("with key \"%s\""), rule.getAlarmKey()), listener);
                if ((rule.getFlags() & 0x20) != 0) {
                    this.createLabel(clientArea, 1, false, this.i18n.tr("(use regular expression for alarm termination)"), listener);
                }
            } else if (rule.getAlarmSeverity() == Severity.RESOLVE) {
                this.addActionGroupLabel(clientArea, this.i18n.tr("Resolve alarms"), this.editor.getImageTerminate(), listener);
                this.createLabel(clientArea, 1, false, String.format(this.i18n.tr("with key \"%s\""), rule.getAlarmKey()), listener);
                if ((rule.getFlags() & 0x20) != 0) {
                    this.createLabel(clientArea, 1, false, this.i18n.tr("(use regular expression for alarm resolve)"), listener);
                }
            }
            if (rule.getAlarmCategories().size() > 0) {
                this.createLabel(clientArea, 1, false, rule.getAlarmCategories().size() == 1 ? this.i18n.tr("with category: ") : this.i18n.tr("with categories: "), listener);
                for (Long l : rule.getAlarmCategories()) {
                    AlarmCategory category = this.session.findAlarmCategoryById(l.longValue());
                    if (category == null) continue;
                    this.createLabel(clientArea, 2, false, category.getName(), listener);
                }
            }
            if ((rule.getFlags() & 0x2000) != 0) {
                this.createLabel(clientArea, 1, false, this.i18n.tr("and create helpdesk ticket"), listener);
            }
        }
        if (!rule.getPStorageSet().isEmpty() || !rule.getPStorageDelete().isEmpty()) {
            listener = this.createMouseListener("PersistentStorage");
            this.addActionGroupLabel(clientArea, this.i18n.tr("Update persistent storage entries"), this.editor.getImagePersistentStorage(), listener);
            if (!rule.getPStorageSet().isEmpty()) {
                this.createLabel(clientArea, 1, false, this.i18n.tr("Set persistent storage values:"), listener);
                for (Map.Entry entry : rule.getPStorageSet().entrySet()) {
                    this.createLabel(clientArea, 2, false, (String)entry.getKey() + " = \"" + (String)entry.getValue() + "\"", listener);
                }
            }
            if (!rule.getPStorageDelete().isEmpty()) {
                void var7_11;
                this.createLabel(clientArea, 1, false, this.i18n.tr("Delete persistent storage values:"), listener);
                List pStorageList = rule.getPStorageDelete();
                boolean bl = false;
                while (var7_11 < pStorageList.size()) {
                    this.createLabel(clientArea, 2, false, (String)pStorageList.get((int)var7_11), listener);
                    ++var7_11;
                }
            }
        }
        if (rule.getCustomAttributeStorageSet().size() != 0 || rule.getCustomAttributeStorageDelete().size() != 0) {
            listener = this.createMouseListener("CustomAttributes");
            this.addActionGroupLabel(clientArea, this.i18n.tr("Update custom attribute entries"), this.editor.getImagePersistentStorage(), listener);
            if (rule.getCustomAttributeStorageSet().size() != 0) {
                this.createLabel(clientArea, 1, false, this.i18n.tr("Set custom attribute values"), listener);
                for (Map.Entry entry : rule.getCustomAttributeStorageSet().entrySet()) {
                    this.createLabel(clientArea, 2, false, (String)entry.getKey() + " = \"" + (String)entry.getValue() + "\"", listener);
                }
            }
            if (rule.getCustomAttributeStorageDelete().size() != 0) {
                void var7_14;
                this.createLabel(clientArea, 1, false, this.i18n.tr("Delete custom attribute values"), listener);
                List customAttributeList = rule.getCustomAttributeStorageDelete();
                boolean bl = false;
                while (var7_14 < customAttributeList.size()) {
                    this.createLabel(clientArea, 2, false, (String)customAttributeList.get((int)var7_14), listener);
                    ++var7_14;
                }
            }
        }
        if (!rule.getActions().isEmpty()) {
            listener = this.createMouseListener("ServerActions");
            this.addActionGroupLabel(clientArea, this.i18n.tr("Execute the following predefined actions:"), this.editor.getImageExecute(), listener);
            for (ActionExecutionConfiguration actionExecutionConfiguration : rule.getActions()) {
                clabel = this.createCLabel(clientArea, 1, false);
                clabel.addMouseListener(listener);
                ServerAction action = this.editor.findActionById(Long.valueOf(actionExecutionConfiguration.getActionId()));
                if (action != null) {
                    clabel.setText(action.getName());
                    clabel.setImage(this.editor.getActionLabelProvider().getImage((Object)action));
                } else {
                    clabel.setText("[" + Long.toString(actionExecutionConfiguration.getActionId()) + "]");
                }
                if (!actionExecutionConfiguration.getTimerDelay().isEmpty()) {
                    clabel = this.createCLabel(clientArea, 2, false);
                    clabel.addMouseListener(listener);
                    if (actionExecutionConfiguration.getTimerKey().isEmpty()) {
                        clabel.setText(String.format(this.i18n.tr("Delayed by %s seconds"), actionExecutionConfiguration.getTimerDelay()));
                    } else {
                        clabel.setText(String.format(this.i18n.tr("Delayed by %s seconds with timer key set to \"%s\""), actionExecutionConfiguration.getTimerDelay(), actionExecutionConfiguration.getTimerKey()));
                    }
                }
                if (!actionExecutionConfiguration.getBlockingTimerKey().isEmpty()) {
                    clabel = this.createCLabel(clientArea, 2, false);
                    clabel.addMouseListener(listener);
                    clabel.setText(String.format(this.i18n.tr("Do not run if timer with key \"%s\" is active"), actionExecutionConfiguration.getBlockingTimerKey()));
                }
                if (actionExecutionConfiguration.getSnoozeTime().isEmpty()) continue;
                clabel = this.createCLabel(clientArea, 2, false);
                clabel.addMouseListener(listener);
                clabel.setText(String.format(this.i18n.tr("Set snooze timer for %s seconds after execution with key %s"), actionExecutionConfiguration.getSnoozeTime(), actionExecutionConfiguration.getBlockingTimerKey()));
            }
        }
        if (rule.getActionScript() != null && !rule.getActionScript().isEmpty()) {
            listener = this.createMouseListener("ActionScript");
            this.addActionGroupLabel(clientArea, this.i18n.tr("Execute script"), this.editor.getImageExecute(), listener);
            ScriptEditor scriptEditor = new ScriptEditor(clientArea, 2048, 0, true, false);
            GridData gridData = new GridData();
            gridData.horizontalIndent = 40;
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            scriptEditor.setLayoutData((Object)gridData);
            scriptEditor.setText(rule.getActionScript());
            scriptEditor.getTextWidget().setEditable(false);
            scriptEditor.getTextWidget().addMouseListener(listener);
        }
        if (!rule.getTimerCancellations().isEmpty()) {
            listener = this.createMouseListener("TimerCancellations");
            this.addActionGroupLabel(clientArea, this.i18n.tr("Cancel the following timers:"), this.editor.getImageCancelTimer(), listener);
            for (String string : rule.getTimerCancellations()) {
                clabel = this.createCLabel(clientArea, 1, false);
                clabel.addMouseListener(listener);
                clabel.setText(string);
            }
        }
        if ((rule.getFlags() & 1) != 0) {
            listener = this.createMouseListener("Action");
            this.addActionGroupLabel(clientArea, this.i18n.tr("Stop event processing"), this.editor.getImageStop(), listener);
        }
        return clientArea;
    }

    private void addActionGroupLabel(Composite parent, String title, Image image, MouseListener mouseListener) {
        CLabel label = this.createCLabel(parent, 0, true);
        label.setImage(image);
        label.setText(title);
        label.addMouseListener(mouseListener);
    }

    public int getRuleNumber() {
        return this.ruleNumber;
    }

    public void setRuleNumber(int ruleNumber) {
        this.ruleNumber = ruleNumber;
        this.rule.setRuleNumber(ruleNumber);
        if (!this.isDisposed()) {
            this.ruleNumberLabel.setText(Integer.toString(ruleNumber));
            this.leftPanel.layout();
        }
    }

    public void setVerticalLayout(boolean verticalLayout, boolean doLayout) {
        this.verticalLayout = verticalLayout;
        GridLayout layout = (GridLayout)this.mainArea.getLayout();
        int n = layout.numColumns = verticalLayout ? 1 : 2;
        if (doLayout) {
            this.layout();
        }
    }

    public boolean isCollapsed() {
        return this.collapsed;
    }

    public void setCollapsed(boolean collapsed, boolean doLayout) {
        this.collapsed = collapsed;
        this.expandButton.setImage(collapsed ? SharedIcons.IMG_EXPAND : SharedIcons.IMG_COLLAPSE);
        this.expandButton.setToolTipText(collapsed ? this.i18n.tr("Expand rule") : this.i18n.tr("Collapse rule"));
        this.mainArea.setVisible(!collapsed);
        ((GridData)this.mainArea.getLayoutData()).exclude = collapsed;
        int n = ((GridData)this.leftPanel.getLayoutData()).verticalSpan = collapsed ? 1 : 2;
        if (doLayout) {
            this.editor.updateEditorAreaLayout();
        }
    }

    private void editRule(String pageId) {
        this.modified = false;
        PreferenceManager pm = new PreferenceManager();
        pm.addToRoot((IPreferenceNode)new PreferenceNode("Condition", (IPreferencePage)new RuleCondition(this)));
        pm.addTo("Condition", (IPreferenceNode)new PreferenceNode("Events", (IPreferencePage)new RuleEvents(this)));
        pm.addTo("Condition", (IPreferenceNode)new PreferenceNode("SourceObjects", (IPreferencePage)new RuleSourceObjects(this)));
        pm.addTo("Condition", (IPreferenceNode)new PreferenceNode("TimeFilter", (IPreferencePage)new RuleTimeFilter(this)));
        pm.addTo("Condition", (IPreferenceNode)new PreferenceNode("SeverityFilter", (IPreferencePage)new RuleSeverityFilter(this)));
        pm.addTo("Condition", (IPreferenceNode)new PreferenceNode("FilteringScript", (IPreferencePage)new RuleFilteringScript(this)));
        pm.addToRoot((IPreferenceNode)new PreferenceNode("Action", (IPreferencePage)new RuleAction(this)));
        pm.addTo("Action", (IPreferenceNode)new PreferenceNode("Alarm", (IPreferencePage)new RuleAlarm(this)));
        pm.addTo("Action", (IPreferenceNode)new PreferenceNode("PersistentStorage", (IPreferencePage)new RulePersistentStorage(this)));
        pm.addTo("Action", (IPreferenceNode)new PreferenceNode("CustomAttributes", (IPreferencePage)new RuleCustomAttribute(this)));
        pm.addTo("Action", (IPreferenceNode)new PreferenceNode("ServerActions", (IPreferencePage)new RuleServerActions(this)));
        pm.addTo("Action", (IPreferenceNode)new PreferenceNode("ActionScript", (IPreferencePage)new RuleActionScript(this)));
        pm.addTo("Action", (IPreferenceNode)new PreferenceNode("TimerCancellations", (IPreferencePage)new RuleTimerCancellations(this)));
        pm.addToRoot((IPreferenceNode)new PreferenceNode("Comments", (IPreferencePage)new RuleComments(this)));
        14 dlg = new /* Unavailable Anonymous Inner Class!! */;
        dlg.setSelectedNode(pageId);
        dlg.open();
        if (this.modified) {
            if (this.rule.isDisabled()) {
                this.headerLabel.setText(this.rule.getComments() + this.i18n.tr(" (disabled)"));
            } else {
                this.headerLabel.setText(this.rule.getComments());
            }
            this.updateBackground();
            this.condition.replaceClientArea();
            this.action.replaceClientArea();
            this.editor.updateEditorAreaLayout();
            this.editor.setModified(true);
        }
    }

    public EventProcessingPolicyRule getRule() {
        return this.rule;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }

    public EventProcessingPolicyEditor getEditorView() {
        return this.editor;
    }

    private void processRuleMouseEvent(MouseEvent e) {
        boolean shiftPressed;
        boolean ctrlPressed = (e.stateMask & SWT.MOD1) != 0;
        boolean bl = shiftPressed = (e.stateMask & 0x20000) != 0;
        if (ctrlPressed) {
            if (this.selected) {
                this.editor.removeFromSelection(this);
            } else {
                this.editor.addToSelection(this, false);
            }
        } else if (shiftPressed) {
            this.editor.addToSelection(this, true);
        } else if (!this.selected) {
            this.editor.setSelection(this);
        }
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
        Color color = ThemeEngine.getBackgroundColor((String)(selected ? "RuleEditor.Title.Selected" : (this.rule.isDisabled() ? "RuleEditor.Title.Disabled" : "RuleEditor.Title.Normal")));
        this.leftPanel.setBackground(color);
        for (Control c : this.leftPanel.getChildren()) {
            c.setBackground(color);
        }
        this.leftPanel.redraw();
        this.header.setBackground(color);
        this.headerLabel.setBackground(color);
        this.expandButton.setBackground(color);
        this.editButton.setBackground(color);
        this.header.redraw();
    }

    public void enableRule(boolean enabled) {
        if (enabled == !this.rule.isDisabled()) {
            return;
        }
        if (enabled) {
            this.rule.setFlags(this.rule.getFlags() & 0xFFFFFFEF);
            this.headerLabel.setText(this.rule.getComments());
        } else {
            this.rule.setFlags(this.rule.getFlags() | 0x10);
            this.headerLabel.setText(this.rule.getComments() + this.i18n.tr(" (disabled)"));
        }
        this.modified = true;
        this.updateBackground();
        this.editor.setModified(true);
    }

    private void updateBackground() {
        Color color = ThemeEngine.getBackgroundColor((String)(this.selected ? "RuleEditor.Title.Selected" : (this.rule.isDisabled() ? "RuleEditor.Title.Disabled" : "RuleEditor.Title.Normal")));
        this.leftPanel.setBackground(color);
        for (Control c : this.leftPanel.getChildren()) {
            c.setBackground(color);
        }
        this.header.setBackground(color);
        this.headerLabel.setBackground(color);
        this.expandButton.setBackground(color);
        this.editButton.setBackground(color);
    }
}

