/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.logviewer;

import org.netxms.client.NXCSession;
import org.netxms.client.constants.ColumnFilterSetOperation;
import org.netxms.client.constants.ColumnFilterType;
import org.netxms.client.log.ColumnFilter;
import org.netxms.client.log.LogFilter;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.DataCollectionTarget;
import org.netxms.client.objecttools.ObjectTool;

public class LogDescriptor {
    protected String viewName;
    protected String logName;
    protected String filterColumn;

    public LogDescriptor(String viewName, String logName, String filterColumn) {
        this.viewName = viewName;
        this.logName = logName;
        this.filterColumn = filterColumn;
    }

    public boolean isValidForSession(NXCSession session) {
        return true;
    }

    public LogFilter createFilter(AbstractObject object) {
        ColumnFilter cf = new ColumnFilter();
        cf.setOperation(ColumnFilterSetOperation.OR);
        cf.addSubFilter(new ColumnFilter(object instanceof AbstractNode ? ColumnFilterType.EQUALS : ColumnFilterType.CHILDOF, object.getObjectId()));
        LogFilter filter = new LogFilter();
        filter.setColumnFilter(this.filterColumn, cf);
        return filter;
    }

    public boolean isApplicableForObject(AbstractObject object) {
        return object instanceof DataCollectionTarget || ObjectTool.isContainerObject((AbstractObject)object);
    }

    public String getLogName() {
        return this.logName;
    }

    public String getViewName() {
        return this.viewName;
    }
}

