/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.logviewer;

import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import org.eclipse.swt.widgets.Display;
import org.netxms.client.NXCSession;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.logviewer.LogDescriptor;
import org.xnap.commons.i18n.I18n;

public final class LogDescriptorRegistry {
    private final I18n i18n = LocalizationHelper.getI18n(LogDescriptorRegistry.class);
    private List<LogDescriptor> descriptors = new ArrayList();

    public static void attachSession(Display display, NXCSession session) {
        LogDescriptorRegistry instance = new LogDescriptorRegistry(session);
        Registry.setSingleton((Display)display, LogDescriptorRegistry.class, (Object)instance);
    }

    private LogDescriptorRegistry(NXCSession session) {
        this.descriptors.add(new LogDescriptor(this.i18n.tr("Alarms"), "AlarmLog", "source_object_id"));
        this.descriptors.add(new LogDescriptor(this.i18n.tr("Events"), "EventLog", "event_source"));
        this.descriptors.add(new LogDescriptor(this.i18n.tr("SNMP Traps"), "SnmpTrapLog", "object_id"));
        this.descriptors.add(new LogDescriptor(this.i18n.tr("Syslog"), "syslog", "source_object_id"));
        this.descriptors.add(new /* Unavailable Anonymous Inner Class!! */);
        ServiceLoader<LogDescriptor> loader = ServiceLoader.load(LogDescriptor.class, this.getClass().getClassLoader());
        for (LogDescriptor d : loader) {
            if (!d.isValidForSession(session)) continue;
            this.descriptors.add(d);
        }
    }

    public List<LogDescriptor> getDescriptors() {
        return this.descriptors;
    }
}

