/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.networkmaps;

import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Chassis;
import org.netxms.client.objects.Dashboard;
import org.netxms.client.objects.NetworkMap;
import org.netxms.client.objects.Rack;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.modules.dashboards.views.AdHocDashboardView;
import org.netxms.nxmc.modules.networkmaps.views.AdHocPredefinedMapView;
import org.netxms.nxmc.modules.objects.views.AdHocChassisView;
import org.netxms.nxmc.modules.objects.views.AdHocRackView;
import org.netxms.nxmc.modules.objects.views.ObjectView;
import org.netxms.nxmc.services.ObjectDoubleClickHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectDoubleClickHandlerRegistry {
    private static final Logger logger = LoggerFactory.getLogger(ObjectDoubleClickHandlerRegistry.class);
    private NXCSession session = Registry.getSession();
    private View view;
    private List<ObjectDoubleClickHandler> doubleClickHandlers = new ArrayList(0);

    public ObjectDoubleClickHandlerRegistry(View view) {
        this.view = view;
        this.registerDoubleClickHandlers();
    }

    public boolean handleDoubleClick(AbstractObject object) {
        for (ObjectDoubleClickHandler h : this.doubleClickHandlers) {
            if (h.enabledFor() != null && !h.enabledFor().isInstance(object) || !h.onDoubleClick(object, this.view)) continue;
            return true;
        }
        return this.openDrillDownObject(object);
    }

    private boolean openDrillDownObject(AbstractObject object) {
        long contextObjectId;
        AbstractObject drillDownObject;
        long drillDownObjectId;
        if (this.view == null) {
            return false;
        }
        long l = drillDownObjectId = object instanceof NetworkMap ? object.getObjectId() : object.getDrillDownObjectId();
        if (drillDownObjectId == 0L) {
            if (object instanceof Rack || object instanceof Chassis) {
                drillDownObjectId = object.getObjectId();
            } else {
                return false;
            }
        }
        if ((drillDownObject = this.session.findObjectById(drillDownObjectId)) == null) {
            return false;
        }
        long l2 = contextObjectId = this.view instanceof ObjectView ? ((ObjectView)this.view).getObjectId() : 0L;
        if (drillDownObject instanceof NetworkMap) {
            this.view.openView((View)new AdHocPredefinedMapView(contextObjectId, (NetworkMap)drillDownObject));
        } else if (drillDownObject instanceof Dashboard) {
            this.view.openView((View)new AdHocDashboardView(contextObjectId, (Dashboard)drillDownObject, object));
        } else if (drillDownObject instanceof Chassis) {
            this.view.openView((View)new AdHocChassisView(contextObjectId, (Chassis)drillDownObject));
        } else if (drillDownObject instanceof Rack) {
            this.view.openView((View)new AdHocRackView(contextObjectId, (Rack)drillDownObject));
        } else {
            return false;
        }
        return true;
    }

    private void registerDoubleClickHandlers() {
        ServiceLoader<ObjectDoubleClickHandler> loader = ServiceLoader.load(ObjectDoubleClickHandler.class, this.getClass().getClassLoader());
        for (ObjectDoubleClickHandler h : loader) {
            logger.debug("Adding object double click handler " + h.getDescription());
            this.doubleClickHandlers.add(h);
        }
        this.doubleClickHandlers.sort(new /* Unavailable Anonymous Inner Class!! */);
    }
}

