/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.networkmaps.views;

import java.util.List;
import org.netxms.client.NXCException;
import org.netxms.client.maps.NetworkMapLink;
import org.netxms.client.maps.NetworkMapPage;
import org.netxms.client.maps.elements.NetworkMapElement;
import org.netxms.client.maps.elements.NetworkMapObject;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Interface;
import org.netxms.client.objects.Node;
import org.netxms.client.topology.Port;
import org.netxms.client.topology.VlanInfo;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.networkmaps.views.AbstractNetworkMapView;
import org.netxms.nxmc.resources.ResourceManager;
import org.xnap.commons.i18n.I18n;

public class VlanMapView
extends AbstractNetworkMapView {
    private static final I18n i18n = LocalizationHelper.getI18n(VlanMapView.class);
    public static final String ID = "VlanMap";
    private int vlanId;
    private AbstractObject rootObject;

    public VlanMapView(AbstractObject rootObject, int vlanId) {
        super(String.format(i18n.tr("Vlan Map - %d@%s"), vlanId, rootObject.getObjectName()), ResourceManager.getImageDescriptor((String)"icons/object-views/vpn.png"), String.format(i18n.tr("VlanMap%d@%s"), vlanId, rootObject.getObjectName()));
        this.rootObject = rootObject;
        this.vlanId = vlanId;
    }

    protected VlanMapView() {
        super(null, null, "");
    }

    public View cloneView() {
        VlanMapView view = (VlanMapView)super.cloneView();
        view.vlanId = this.vlanId;
        view.rootObject = this.rootObject;
        return view;
    }

    protected void buildMapPage() {
        if (this.mapPage == null) {
            this.mapPage = new NetworkMapPage(ID + this.vlanId);
        }
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private long collectVlanInfo(NetworkMapPage page, Node root) throws Exception {
        if (page.findObjectElement(root.getObjectId()) != null) {
            return -1L;
        }
        long rootElementId = this.mapPage.createElementId();
        page.addElement((NetworkMapElement)new NetworkMapObject(rootElementId, root.getObjectId()));
        List vlans = this.session.getVlans(root.getObjectId());
        for (VlanInfo vlan : vlans) {
            Port[] ports;
            if (vlan.getVlanId() != this.vlanId) continue;
            for (Port port : ports = vlan.getPorts()) {
                this.processVlanPort(page, root, port, rootElementId);
            }
        }
        return rootElementId;
    }

    private void processVlanPort(NetworkMapPage page, Node root, Port port, long rootElementId) throws Exception {
        Node peerNode;
        Interface iface = (Interface)this.session.findObjectById(port.getObjectId(), Interface.class);
        if (iface != null && (peerNode = (Node)this.session.findObjectById(iface.getPeerNodeId(), Node.class)) != null && (peerNode.getCapabilities() & 4) != 0) {
            try {
                long nodeElementId = this.collectVlanInfo(page, peerNode);
                if (nodeElementId != -1L) {
                    Interface peerIf = (Interface)this.session.findObjectById(iface.getPeerInterfaceId(), Interface.class);
                    page.addLink(new NetworkMapLink(page.createLinkId(), null, 0, rootElementId, nodeElementId, iface.getObjectName(), peerIf != null ? peerIf.getObjectName() : "???", 0));
                }
            }
            catch (NXCException nXCException) {
                // empty catch block
            }
        }
    }

    public boolean isCloseable() {
        return true;
    }

    public boolean isValidForContext(Object context) {
        return context != null && ((AbstractObject)context).getObjectId() == this.rootObject.getObjectId();
    }

    protected void onObjectChange(AbstractObject object) {
    }
}

