/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.networkmaps.widgets.helpers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.eclipse.draw2d.AbsoluteBendpoint;
import org.eclipse.draw2d.Bendpoint;
import org.eclipse.draw2d.BendpointConnectionRouter;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.ConnectionEndpointLocator;
import org.eclipse.draw2d.ConnectionLocator;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ManhattanConnectionRouter;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.PolylineDecoration;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.gef4.zest.core.viewers.IFigureProvider;
import org.eclipse.gef4.zest.core.viewers.ISelfStyleProvider;
import org.eclipse.gef4.zest.core.widgets.GraphConnection;
import org.eclipse.gef4.zest.core.widgets.GraphNode;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.netxms.base.NXCommon;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.ObjectStatus;
import org.netxms.client.constants.Severity;
import org.netxms.client.datacollection.DciValue;
import org.netxms.client.maps.MapObjectDisplayMode;
import org.netxms.client.maps.NetworkMapLink;
import org.netxms.client.maps.elements.NetworkMapDCIContainer;
import org.netxms.client.maps.elements.NetworkMapDCIImage;
import org.netxms.client.maps.elements.NetworkMapDecoration;
import org.netxms.client.maps.elements.NetworkMapElement;
import org.netxms.client.maps.elements.NetworkMapObject;
import org.netxms.client.maps.elements.NetworkMapResource;
import org.netxms.client.maps.elements.NetworkMapTextBox;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Node;
import org.netxms.nxmc.PreferenceStore;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.modules.imagelibrary.ImageProvider;
import org.netxms.nxmc.modules.networkmaps.MapImageProvidersManager;
import org.netxms.nxmc.modules.networkmaps.widgets.helpers.ConnectorLabel;
import org.netxms.nxmc.modules.networkmaps.widgets.helpers.DCIContainerFigure;
import org.netxms.nxmc.modules.networkmaps.widgets.helpers.DCIImageFigure;
import org.netxms.nxmc.modules.networkmaps.widgets.helpers.DecorationFigure;
import org.netxms.nxmc.modules.networkmaps.widgets.helpers.ExtendedGraphViewer;
import org.netxms.nxmc.modules.networkmaps.widgets.helpers.LinkDciValueProvider;
import org.netxms.nxmc.modules.networkmaps.widgets.helpers.MapContentProvider;
import org.netxms.nxmc.modules.networkmaps.widgets.helpers.MapLabelProvider;
import org.netxms.nxmc.modules.networkmaps.widgets.helpers.MultiConnectionAnchor;
import org.netxms.nxmc.modules.networkmaps.widgets.helpers.MultiLabelConnectionLocator;
import org.netxms.nxmc.modules.networkmaps.widgets.helpers.ObjectFigureIcon;
import org.netxms.nxmc.modules.networkmaps.widgets.helpers.ObjectFigureLargeLabel;
import org.netxms.nxmc.modules.networkmaps.widgets.helpers.ObjectFigureSmallLabel;
import org.netxms.nxmc.modules.networkmaps.widgets.helpers.ObjectFloorPlan;
import org.netxms.nxmc.modules.networkmaps.widgets.helpers.ObjectStatusIcon;
import org.netxms.nxmc.modules.networkmaps.widgets.helpers.ObjectTooltip;
import org.netxms.nxmc.modules.networkmaps.widgets.helpers.ResourceFigure;
import org.netxms.nxmc.modules.networkmaps.widgets.helpers.TextBoxFigure;
import org.netxms.nxmc.modules.objects.widgets.helpers.DecoratingObjectLabelProvider;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.resources.StatusDisplayInfo;
import org.netxms.nxmc.tools.ColorCache;
import org.netxms.nxmc.tools.ColorConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapLabelProvider
extends LabelProvider
implements IFigureProvider,
ISelfStyleProvider {
    private static final Logger logger = LoggerFactory.getLogger(MapLabelProvider.class);
    private static final Color COLOR_AGENT_TUNNEL = new Color((Device)Display.getDefault(), new RGB(255, 0, 0));
    private static final Color COLOR_AGENT_PROXY = new Color((Device)Display.getDefault(), new RGB(0, 255, 0));
    private static final Color COLOR_ICMP_PROXY = new Color((Device)Display.getDefault(), new RGB(0, 0, 255));
    private static final Color COLOR_SNMP_PROXY = new Color((Device)Display.getDefault(), new RGB(255, 255, 0));
    private static final Color COLOR_SSH_PROXY = new Color((Device)Display.getDefault(), new RGB(0, 255, 255));
    private static final Color COLOR_ZONE_PROXY = new Color((Device)Display.getDefault(), new RGB(255, 0, 255));
    private NXCSession session;
    private ExtendedGraphViewer viewer;
    private Image[] statusImages;
    private Image imgNetMap;
    private Image imgNodeGeneric;
    private Image imgNodeWindows;
    private Image imgNodeOSX;
    private Image imgNodeLinux;
    private Image imgNodeFreeBSD;
    private Image imgNodeSwitch;
    private Image imgNodeRouter;
    private Image imgNodePrinter;
    private Image imgSubnet;
    private Image imgService;
    private Image imgCluster;
    private Image imgAccessPoint;
    private Image imgInterface;
    private Image imgOther;
    private Image imgUnknown;
    private Image imgResCluster;
    private Font fontLabel;
    private Font fontTitle;
    private boolean showStatusIcons = false;
    private boolean showStatusBackground = true;
    private boolean showStatusFrame = true;
    private boolean showLinkDirection = false;
    private boolean translucentLabelBackground = true;
    private boolean enableLongObjectName = false;
    private boolean connectionLabelsVisible = true;
    private boolean connectionsVisible = true;
    private MapObjectDisplayMode objectFigureType = MapObjectDisplayMode.ICON;
    private ColorCache colors;
    private Color defaultLinkColor = null;
    private ManhattanConnectionRouter manhattanRouter = new ManhattanConnectionRouter();
    private BendpointConnectionRouter bendpointRouter = new BendpointConnectionRouter();
    private LinkDciValueProvider dciValueProvider;
    private DecoratingObjectLabelProvider objectLabelProvider;

    public MapLabelProvider(ExtendedGraphViewer viewer) {
        this.viewer = viewer;
        this.session = Registry.getSession();
        this.statusImages = new Image[9];
        for (int i = 0; i < this.statusImages.length; ++i) {
            this.statusImages[i] = StatusDisplayInfo.getStatusImageDescriptor((int)i).createImage();
        }
        this.imgNetMap = ResourceManager.getImage((String)"icons/netmap/objects/netmap.png");
        this.imgNodeGeneric = ResourceManager.getImage((String)"icons/netmap/objects/node.png");
        this.imgNodeOSX = ResourceManager.getImage((String)"icons/netmap/objects/macserver.png");
        this.imgNodeWindows = ResourceManager.getImage((String)"icons/netmap/objects/windowsserver.png");
        this.imgNodeLinux = ResourceManager.getImage((String)"icons/netmap/objects/linuxserver.png");
        this.imgNodeFreeBSD = ResourceManager.getImage((String)"icons/netmap/objects/freebsdserver.png");
        this.imgNodeSwitch = ResourceManager.getImage((String)"icons/netmap/objects/switch.png");
        this.imgNodeRouter = ResourceManager.getImage((String)"icons/netmap/objects/router.png");
        this.imgNodePrinter = ResourceManager.getImage((String)"icons/netmap/objects/printer.png");
        this.imgSubnet = ResourceManager.getImage((String)"icons/netmap/objects/subnet.png");
        this.imgService = ResourceManager.getImage((String)"icons/netmap/objects/service.png");
        this.imgCluster = ResourceManager.getImage((String)"icons/netmap/objects/cluster.png");
        this.imgAccessPoint = ResourceManager.getImage((String)"icons/netmap/objects/accesspoint.png");
        this.imgInterface = ResourceManager.getImage((String)"icons/netmap/objects/interface.png");
        this.imgOther = ResourceManager.getImage((String)"icons/netmap/objects/other.png");
        this.imgUnknown = ResourceManager.getImage((String)"icons/netmap/objects/unknown.png");
        this.imgResCluster = ResourceManager.getImage((String)"icons/netmap/cluster_resource.png");
        Display display = viewer.getControl().getDisplay();
        this.fontLabel = new Font((Device)display, "Verdana", 7, 0);
        this.fontTitle = new Font((Device)display, "Verdana", 10, 0);
        PreferenceStore settings = PreferenceStore.getInstance();
        this.showStatusIcons = settings.getAsBoolean("NetMap.ShowStatusIcon", false);
        this.showStatusFrame = settings.getAsBoolean("NetMap.ShowStatusFrame", true);
        this.showStatusBackground = settings.getAsBoolean("NetMap.ShowStatusBackground", true);
        this.showLinkDirection = settings.getAsBoolean("NetMap.ShowLinkDirection", false);
        this.enableLongObjectName = settings.getAsBoolean("NetMap.LongObjectNames", false);
        this.translucentLabelBackground = settings.getAsBoolean("NetMap.TranslucentLabelBkgnd", true);
        this.colors = new ColorCache();
        this.dciValueProvider = LinkDciValueProvider.getInstance();
        this.objectLabelProvider = new DecoratingObjectLabelProvider();
    }

    public String getText(Object element) {
        if (element instanceof NetworkMapObject) {
            AbstractObject object = this.session.findObjectById(((NetworkMapObject)element).getObjectId());
            return object != null ? object.getNameOnMap() : null;
        }
        return null;
    }

    public Image getImage(Object element) {
        if (element instanceof NetworkMapObject) {
            AbstractObject object = this.session.findObjectById(((NetworkMapObject)element).getObjectId());
            if (object != null) {
                UUID objectImageGuid = object.getMapImage();
                if (objectImageGuid != null && !objectImageGuid.equals(NXCommon.EMPTY_GUID)) {
                    return ImageProvider.getInstance().getImage(objectImageGuid);
                }
                Image img = MapImageProvidersManager.getInstance().getMapImage(object);
                if (img != null) {
                    return img;
                }
                switch (object.getObjectClass()) {
                    case 2: {
                        if ((((Node)object).getCapabilities() & 4) != 0) {
                            return this.imgNodeSwitch;
                        }
                        if ((((Node)object).getCapabilities() & 8) != 0) {
                            return this.imgNodeRouter;
                        }
                        if ((((Node)object).getCapabilities() & 0x20) != 0) {
                            return this.imgNodePrinter;
                        }
                        if (((Node)object).getPlatformName().startsWith("windows")) {
                            return this.imgNodeWindows;
                        }
                        if (((Node)object).getPlatformName().startsWith("Linux")) {
                            return this.imgNodeLinux;
                        }
                        if (((Node)object).getPlatformName().startsWith("FreeBSD")) {
                            return this.imgNodeFreeBSD;
                        }
                        return this.imgNodeGeneric;
                    }
                    case 1: {
                        return this.imgSubnet;
                    }
                    case 5: {
                        return this.imgService;
                    }
                    case 14: {
                        return this.imgCluster;
                    }
                    case 33: {
                        return this.imgAccessPoint;
                    }
                    case 21: {
                        return this.imgNetMap;
                    }
                    case 3: {
                        return this.imgInterface;
                    }
                }
                return this.imgOther;
            }
            return this.imgUnknown;
        }
        if (element instanceof NetworkMapResource) {
            return this.imgResCluster;
        }
        return null;
    }

    public IFigure getFigure(Object element) {
        if (element instanceof NetworkMapObject) {
            switch (1.$SwitchMap$org$netxms$client$maps$MapObjectDisplayMode[this.objectFigureType.ordinal()]) {
                case 1: {
                    return new ObjectFigureLargeLabel((NetworkMapObject)element, this);
                }
                case 2: {
                    return new ObjectFigureSmallLabel((NetworkMapObject)element, this);
                }
                case 3: {
                    return new ObjectFigureIcon((NetworkMapObject)element, this);
                }
                case 4: {
                    return new ObjectStatusIcon((NetworkMapObject)element, this);
                }
                case 5: {
                    return new ObjectFloorPlan((NetworkMapObject)element, this);
                }
            }
            return null;
        }
        if (element instanceof NetworkMapResource) {
            return new ResourceFigure((NetworkMapResource)element, this);
        }
        if (element instanceof NetworkMapDecoration) {
            return new DecorationFigure((NetworkMapDecoration)element, this, this.viewer);
        }
        if (element instanceof NetworkMapDCIContainer) {
            return new DCIContainerFigure((NetworkMapDCIContainer)element, this, this.viewer);
        }
        if (element instanceof NetworkMapDCIImage) {
            return new DCIImageFigure((NetworkMapDCIImage)element, this, this.viewer);
        }
        if (element instanceof NetworkMapTextBox) {
            return new TextBoxFigure((NetworkMapTextBox)element, this, this.viewer);
        }
        return null;
    }

    public Image getStatusImage(AbstractObject object) {
        Image image = MapImageProvidersManager.getInstance().getStatusIcon(object.getStatus());
        if (image == null) {
            try {
                image = this.statusImages[object.getStatus().getValue()];
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        return image;
    }

    public void dispose() {
        for (int i = 0; i < this.statusImages.length; ++i) {
            this.statusImages[i].dispose();
        }
        this.imgNetMap.dispose();
        this.imgNodeGeneric.dispose();
        this.imgNodeWindows.dispose();
        this.imgNodeLinux.dispose();
        this.imgNodeOSX.dispose();
        this.imgNodeFreeBSD.dispose();
        this.imgNodeSwitch.dispose();
        this.imgNodeRouter.dispose();
        this.imgNodePrinter.dispose();
        this.imgSubnet.dispose();
        this.imgService.dispose();
        this.imgCluster.dispose();
        this.imgAccessPoint.dispose();
        this.imgInterface.dispose();
        this.imgOther.dispose();
        this.imgUnknown.dispose();
        this.imgResCluster.dispose();
        this.fontLabel.dispose();
        this.fontTitle.dispose();
        this.colors.dispose();
        this.objectLabelProvider.dispose();
        super.dispose();
    }

    public Font getLabelFont() {
        return this.fontLabel;
    }

    public Font getTitleFont() {
        return this.fontTitle;
    }

    public boolean isShowStatusIcons() {
        return this.showStatusIcons;
    }

    public void setShowStatusIcons(boolean showStatusIcons) {
        this.showStatusIcons = showStatusIcons;
    }

    public boolean isShowStatusBackground() {
        return this.showStatusBackground;
    }

    public void setShowStatusBackground(boolean showStatusBackground) {
        this.showStatusBackground = showStatusBackground;
    }

    public boolean isShowLinkDirection() {
        return this.showLinkDirection;
    }

    public void setShowLinkDirection(boolean showLinkDirection) {
        this.showLinkDirection = showLinkDirection;
    }

    public boolean isTranslucentLabelBackground() {
        return this.translucentLabelBackground;
    }

    public void setTranslucentLabelBackground(boolean translucent) {
        this.translucentLabelBackground = translucent;
    }

    public boolean isElementSelected(NetworkMapElement element) {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        return selection != null ? selection.toList().contains(element) : false;
    }

    public void selfStyleConnection(Object element, GraphConnection connection) {
        ConnectorLabel label;
        connection.setVisible(this.connectionsVisible);
        NetworkMapLink link = (NetworkMapLink)connection.getData();
        if (link.getType() == 1) {
            connection.setLineStyle(3);
        }
        if (link.hasConnectorName1() && this.connectionLabelsVisible) {
            ConnectionEndpointLocator sourceEndpointLocator = new ConnectionEndpointLocator(connection.getConnectionFigure(), false);
            sourceEndpointLocator.setVDistance(0);
            label = new ConnectorLabel(link.getConnectorName1());
            label.setFont(this.fontLabel);
            connection.getConnectionFigure().add((IFigure)label, (Object)sourceEndpointLocator);
        }
        if (link.hasConnectorName2() && this.connectionLabelsVisible) {
            ConnectionEndpointLocator targetEndpointLocator = new ConnectionEndpointLocator(connection.getConnectionFigure(), true);
            targetEndpointLocator.setVDistance(0);
            label = new ConnectorLabel(link.getConnectorName2());
            label.setFont(this.fontLabel);
            connection.getConnectionFigure().add((IFigure)label, (Object)targetEndpointLocator);
        }
        if (this.showLinkDirection) {
            ((PolylineConnection)connection.getConnectionFigure()).setSourceDecoration((RotatableDecoration)new PolylineDecoration());
        }
        IFigure owner = ((PolylineConnection)connection.getConnectionFigure()).getTargetAnchor().getOwner();
        ((PolylineConnection)connection.getConnectionFigure()).setTargetAnchor((ConnectionAnchor)new MultiConnectionAnchor(owner, link));
        owner = ((PolylineConnection)connection.getConnectionFigure()).getSourceAnchor().getOwner();
        ((PolylineConnection)connection.getConnectionFigure()).setSourceAnchor((ConnectionAnchor)new MultiConnectionAnchor(owner, link));
        boolean hasDciData = link.hasDciData();
        boolean hasName = link.hasName();
        if (link.getColorSource() == 1) {
            ObjectStatus status = ObjectStatus.UNKNOWN;
            ObjectStatus altStatus = ObjectStatus.UNKNOWN;
            for (Long id : link.getStatusObjects()) {
                AbstractObject object = this.session.findObjectById(id.longValue());
                if (object == null) continue;
                ObjectStatus s = object.getStatus();
                if (s.compareTo((Enum)ObjectStatus.UNKNOWN) < 0 && (status.compareTo((Enum)s) < 0 || status == ObjectStatus.UNKNOWN) && (status = s) == ObjectStatus.CRITICAL) break;
                if (s == ObjectStatus.UNKNOWN) continue;
                altStatus = s;
            }
            if (link.getConfig().isUseActiveThresholds() && !link.getDciAsList().isEmpty()) {
                Severity severity = Severity.UNKNOWN;
                try {
                    DciValue v;
                    Severity s;
                    List values = this.dciValueProvider.getDciData(link.getDciAsList());
                    Iterator iterator = values.iterator();
                    while (iterator.hasNext() && ((s = (v = (DciValue)iterator.next()).getMostCriticalSeverity()).compareTo((Enum)Severity.UNKNOWN) >= 0 || severity.compareTo((Enum)s) >= 0 && severity != Severity.UNKNOWN || (severity = s) != Severity.CRITICAL)) {
                    }
                }
                catch (Exception e) {
                    logger.error("Exception in map label provider", (Throwable)e);
                }
                if (severity != Severity.UNKNOWN && (severity.getValue() > status.getValue() || status.compareTo((Enum)ObjectStatus.UNKNOWN) >= 0)) {
                    status = ObjectStatus.getByValue((int)severity.getValue());
                }
            }
            connection.setLineColor(StatusDisplayInfo.getStatusColor((ObjectStatus)(status != ObjectStatus.UNKNOWN ? status : altStatus)));
        } else if (link.getColorSource() == 2 || link.getColorSource() == 3) {
            connection.setLineColor(this.colors.create(ColorConverter.rgbFromInt((int)link.getColor())));
        } else if (link.getType() == 3) {
            connection.setLineColor(COLOR_AGENT_TUNNEL);
        } else if (link.getType() == 4) {
            connection.setLineColor(COLOR_AGENT_PROXY);
        } else if (link.getType() == 7) {
            connection.setLineColor(COLOR_ICMP_PROXY);
        } else if (link.getType() == 6) {
            connection.setLineColor(COLOR_SNMP_PROXY);
        } else if (link.getType() == 5) {
            connection.setLineColor(COLOR_SSH_PROXY);
        } else if (link.getType() == 9) {
            connection.setLineColor(COLOR_ZONE_PROXY);
        } else if (this.defaultLinkColor != null) {
            connection.setLineColor(this.defaultLinkColor);
        }
        if ((hasName || hasDciData) && this.connectionLabelsVisible) {
            MultiLabelConnectionLocator nameLocator;
            if (link.getRouting() == 3 && link.getBendPoints() != null && link.getBendPoints().length > 0) {
                nameLocator = new ConnectionLocator(connection.getConnectionFigure());
                nameLocator.setRelativePosition(2);
            } else {
                nameLocator = new MultiLabelConnectionLocator(connection.getConnectionFigure(), link);
            }
            Object labelString = "";
            if (hasName) {
                labelString = (String)labelString + link.getName();
            }
            if (hasName && hasDciData) {
                labelString = (String)labelString + "\n";
            }
            if (hasDciData) {
                labelString = (String)labelString + this.dciValueProvider.getDciDataAsString(link);
            }
            ConnectorLabel label2 = link.getType() == 3 || link.getType() == 4 || link.getType() == 7 || link.getType() == 6 || link.getType() == 5 || link.getType() == 9 ? new ConnectorLabel((String)labelString, connection.getLineColor()) : new ConnectorLabel((String)labelString);
            label2.setFont(this.fontLabel);
            connection.getConnectionFigure().add((IFigure)label2, (Object)nameLocator);
        }
        switch (link.getRouting()) {
            case 1: {
                connection.setRouter(ConnectionRouter.NULL);
                break;
            }
            case 2: {
                connection.setRouter((ConnectionRouter)this.manhattanRouter);
                break;
            }
            case 3: {
                connection.setRouter((ConnectionRouter)this.bendpointRouter);
                connection.setData("ROUTER", (Object)this.bendpointRouter);
                List bp = this.getConnectionPoints(link);
                this.bendpointRouter.setConstraint(connection.getConnectionFigure(), (Object)bp);
                connection.getConnectionFigure().setRoutingConstraint((Object)bp);
                break;
            }
            default: {
                connection.setRouter(null);
            }
        }
        connection.setLineWidth(2);
    }

    private List<Bendpoint> getConnectionPoints(NetworkMapLink link) {
        long[] points = link.getBendPoints();
        if (points != null) {
            ArrayList<Bendpoint> list = new ArrayList<Bendpoint>(points.length / 2);
            for (int i = 0; i < points.length && points[i] != Integer.MAX_VALUE; i += 2) {
                list.add((Bendpoint)new AbsoluteBendpoint((int)points[i], (int)points[i + 1]));
            }
            return list;
        }
        return new ArrayList<Bendpoint>(0);
    }

    public boolean isShowStatusFrame() {
        return this.showStatusFrame;
    }

    public void setShowStatusFrame(boolean showStatusFrame) {
        this.showStatusFrame = showStatusFrame;
    }

    public Image getSmallIcon(Object object) {
        return this.objectLabelProvider.getImage(object);
    }

    public MapObjectDisplayMode getObjectFigureType() {
        return this.objectFigureType;
    }

    public void setObjectFigureType(MapObjectDisplayMode objectFigureType) {
        this.objectFigureType = objectFigureType;
    }

    protected ColorCache getColors() {
        return this.colors;
    }

    public void selfStyleNode(Object element, GraphNode node) {
        node.setTooltip((IFigure)new ObjectTooltip((NetworkMapObject)element, this));
    }

    public final Color getDefaultLinkColor() {
        return this.defaultLinkColor;
    }

    public final void setDefaultLinkColor(Color defaultLinkColor) {
        this.defaultLinkColor = defaultLinkColor;
    }

    public DciValue[] getNodeLastValues(long nodeId) {
        return ((MapContentProvider)this.viewer.getContentProvider()).getNodeLastValues(nodeId);
    }

    public boolean areLongObjectNamesEnabled() {
        return this.enableLongObjectName;
    }

    public boolean areConnectionLabelsVisible() {
        return this.connectionLabelsVisible;
    }

    public void setConnectionLabelsVisible(boolean connectionLabelsVisible) {
        this.connectionLabelsVisible = connectionLabelsVisible;
    }

    public boolean areConnectionsVisible() {
        return this.connectionsVisible;
    }

    public void setConnectionsVisible(boolean connectionsVisible) {
        this.connectionsVisible = connectionsVisible;
    }

    public ExtendedGraphViewer getViewer() {
        return this.viewer;
    }
}

