/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.networkmaps.widgets.helpers;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.text.FlowPage;
import org.eclipse.draw2d.text.TextFlow;
import org.eclipse.jface.resource.JFaceResources;
import org.netxms.base.MacAddress;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.ObjectStatus;
import org.netxms.client.datacollection.DciValue;
import org.netxms.client.maps.MapObjectDisplayMode;
import org.netxms.client.maps.elements.NetworkMapObject;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.AccessPoint;
import org.netxms.client.objects.DataCollectionTarget;
import org.netxms.client.objects.Node;
import org.netxms.client.objects.UnknownObject;
import org.netxms.client.topology.RadioInterface;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.networkmaps.widgets.helpers.MapLabelProvider;
import org.netxms.nxmc.modules.networkmaps.widgets.helpers.NodeLastValuesFigure;
import org.netxms.nxmc.modules.networkmaps.widgets.helpers.ObjectTooltip;
import org.netxms.nxmc.resources.SharedIcons;
import org.netxms.nxmc.resources.StatusDisplayInfo;
import org.netxms.nxmc.resources.ThemeEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;

public class ObjectTooltip
extends Figure {
    private static final Logger logger = LoggerFactory.getLogger(ObjectTooltip.class);
    private final I18n i18n = LocalizationHelper.getI18n(ObjectTooltip.class);
    private NXCSession session = Registry.getSession();
    private NodeLastValuesFigure lastValuesFigure = null;
    private int index;
    private AbstractObject object;
    private MapLabelProvider labelProvider;
    private long refreshTimestamp = 0L;

    public ObjectTooltip(NetworkMapObject element, MapLabelProvider labelProvider) {
        DciValue[] values;
        MacAddress mac;
        StringBuilder sb;
        this.labelProvider = labelProvider;
        this.object = this.session.findObjectById(element.getObjectId());
        if (this.object == null) {
            this.object = new UnknownObject(element.getObjectId(), this.session);
        }
        this.setBorder((Border)new MarginBorder(3));
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 10;
        this.setLayoutManager((LayoutManager)layout);
        this.setOpaque(true);
        this.setBackgroundColor(ThemeEngine.getBackgroundColor((String)"Map.ObjectTooltip"));
        Label title = new Label();
        title.setIcon(labelProvider.getSmallIcon((Object)this.object));
        title.setText(this.object.getObjectName());
        title.setFont(JFaceResources.getBannerFont());
        this.add((IFigure)title);
        Label status = new Label();
        status.setIcon(StatusDisplayInfo.getStatusImage((ObjectStatus)this.object.getStatus()));
        status.setText(StatusDisplayInfo.getStatusText((ObjectStatus)this.object.getStatus()));
        this.add((IFigure)status);
        GridData gd = new GridData();
        gd.horizontalAlignment = 131072;
        this.setConstraint((IFigure)status, (Object)gd);
        if (this.object instanceof Node) {
            if ((((Node)this.object).getCapabilities() & 0x800000) != 0) {
                if (((Node)this.object).getHardwareProductName() != null && !((Node)this.object).getHardwareProductName().isEmpty()) {
                    this.addInformationBlock(((Node)this.object).getHardwareProductName() + " (" + ((Node)this.object).getCipDeviceTypeName() + ")", null);
                } else {
                    this.addInformationBlock(((Node)this.object).getCipDeviceTypeName(), null);
                }
            } else {
                this.addInformationBlock(((Node)this.object).getHardwareProductName(), null);
            }
            this.addInformationBlock(((Node)this.object).getHardwareVendor(), "Vendor: ");
        }
        if (this.object instanceof Node && ((Node)this.object).getPrimaryIP().isValidAddress() && !((Node)this.object).getPrimaryIP().getAddress().isAnyLocalAddress()) {
            sb = new StringBuilder(((Node)this.object).getPrimaryIP().getHostAddress());
            mac = ((Node)this.object).getPrimaryMAC();
            if (mac != null) {
                sb.append(" (");
                sb.append(mac.toString());
                sb.append(')');
            }
            RadioInterface[] iface = new Label();
            iface.setIcon(SharedIcons.IMG_IP_ADDRESS);
            iface.setText(sb.toString());
            this.add((IFigure)iface);
            gd = new GridData();
            gd.horizontalSpan = 2;
            this.setConstraint((IFigure)iface, (Object)gd);
        }
        this.index = this.getChildren().size();
        if (this.object instanceof Node && labelProvider.getObjectFigureType() == MapObjectDisplayMode.LARGE_LABEL && (values = labelProvider.getNodeLastValues(this.object.getObjectId())) != null && values.length > 0) {
            this.lastValuesFigure = new NodeLastValuesFigure(values);
            this.add((IFigure)this.lastValuesFigure);
            gd = new GridData();
            gd.horizontalSpan = 2;
            this.setConstraint((IFigure)this.lastValuesFigure, (Object)gd);
        }
        if (this.object instanceof AccessPoint) {
            sb = new StringBuilder(((AccessPoint)this.object).getModel());
            mac = ((AccessPoint)this.object).getMacAddress();
            if (mac != null) {
                sb.append('\n');
                sb.append(mac.toString());
            }
            for (RadioInterface rif : ((AccessPoint)this.object).getRadios()) {
                sb.append(this.i18n.tr("\nRadio"));
                sb.append(rif.getIndex());
                sb.append(" (");
                sb.append(rif.getMacAddress().toString());
                sb.append(this.i18n.tr(")\n\tChannel: "));
                sb.append(rif.getChannel());
                sb.append(this.i18n.tr("\n\tTX power: "));
                sb.append(rif.getPowerMW());
                sb.append(this.i18n.tr(" mW"));
            }
            Label info = new Label();
            info.setText(sb.toString());
            this.add((IFigure)info);
            gd = new GridData();
            gd.horizontalSpan = 2;
            this.setConstraint((IFigure)info, (Object)gd);
        }
        if (!this.object.getComments().isEmpty()) {
            FlowPage page = new FlowPage();
            this.add((IFigure)page);
            gd = new GridData();
            gd.horizontalSpan = 2;
            this.setConstraint((IFigure)page, (Object)gd);
            TextFlow text = new TextFlow();
            text.setText("\n" + this.object.getComments());
            page.add((IFigure)text);
        }
    }

    public void refresh() {
        long now = System.currentTimeMillis();
        if (now < this.refreshTimestamp + 15000L) {
            return;
        }
        this.refreshTimestamp = now;
        if (this.labelProvider.getObjectFigureType() == MapObjectDisplayMode.LARGE_LABEL || !(this.object instanceof DataCollectionTarget)) {
            return;
        }
        long nodeId = this.object.getObjectId();
        1 job = new /* Unavailable Anonymous Inner Class!! */;
        job.setUser(false);
        job.setSystem(true);
        job.start();
    }

    private void addInformationBlock(String text, String prefix) {
        if (text == null || text.isEmpty()) {
            return;
        }
        Label info = new Label();
        info.setText((String)(prefix != null ? prefix + text : text));
        this.add((IFigure)info);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        this.setConstraint((IFigure)info, (Object)gd);
    }

    static /* synthetic */ void access$000(ObjectTooltip x0) {
        x0.layout();
    }
}

