/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.xnap.commons.i18n.I18n;

public class CreateZoneDialog
extends Dialog {
    private final I18n i18n = LocalizationHelper.getI18n(CreateZoneDialog.class);
    private LabeledText nameField;
    private LabeledText aliasField;
    private LabeledText uinField;
    private String name;
    private String alias;
    private int zoneUIN;

    public CreateZoneDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.i18n.tr("Create Zone"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 5;
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        dialogArea.setLayout((Layout)layout);
        this.nameField = new LabeledText(dialogArea, 0);
        this.nameField.setLabel(this.i18n.tr("Name"));
        this.nameField.getTextControl().setTextLimit(255);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 300;
        this.nameField.setLayoutData((Object)gd);
        this.aliasField = new LabeledText(dialogArea, 0);
        this.aliasField.setLabel(this.i18n.tr("Alias"));
        this.aliasField.getTextControl().setTextLimit(255);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.aliasField.setLayoutData((Object)gd);
        this.uinField = new LabeledText(dialogArea, 0);
        this.uinField.setLabel(this.i18n.tr("Zone UIN (leave empty for autogenerated UIN)"));
        this.uinField.getTextControl().setTextLimit(10);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.uinField.setLayoutData((Object)gd);
        return dialogArea;
    }

    protected void okPressed() {
        String zoneIdText = this.uinField.getText().trim();
        if (!zoneIdText.isEmpty()) {
            try {
                this.zoneUIN = Integer.parseInt(this.uinField.getText());
            }
            catch (NumberFormatException e) {
                MessageDialogHelper.openWarning((Shell)this.getShell(), (String)this.i18n.tr("Warning"), (String)this.i18n.tr("Zone UIN must be positive integer"));
                return;
            }
            if (this.zoneUIN <= 0) {
                MessageDialogHelper.openWarning((Shell)this.getShell(), (String)this.i18n.tr("Warning"), (String)this.i18n.tr("Zone UIN must be positive integer"));
                return;
            }
        } else {
            this.zoneUIN = 0;
        }
        this.name = this.nameField.getText().trim();
        this.alias = this.aliasField.getText().trim();
        if (this.name.isEmpty()) {
            MessageDialogHelper.openWarning((Shell)this.getShell(), (String)this.i18n.tr("Warning"), (String)this.i18n.tr("Please provide non-empty object name"));
            return;
        }
        super.okPressed();
    }

    public String getName() {
        return this.name;
    }

    public String getAlias() {
        return this.alias;
    }

    public int getZoneUIN() {
        return this.zoneUIN;
    }
}

