/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views;

import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Scrollable;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Subnet;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.views.ObjectView;
import org.netxms.nxmc.modules.objects.widgets.SubnetAddressMap;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class AddressMapView
extends ObjectView {
    private static final I18n i18n = LocalizationHelper.getI18n(AddressMapView.class);
    private ScrolledComposite scroller;
    private SubnetAddressMap addressMap;

    public AddressMapView() {
        super(i18n.tr("Address map"), ResourceManager.getImageDescriptor((String)"icons/object-views/address_map.png"), "AddressMap", false);
    }

    protected void postClone(View view) {
        super.postClone(view);
        this.refresh();
    }

    protected void createContent(Composite parent) {
        this.scroller = new ScrolledComposite(parent, 768);
        this.addressMap = new SubnetAddressMap((Composite)this.scroller, 0, (ObjectView)this);
        this.scroller.setContent((Control)this.addressMap);
        this.scroller.setExpandVertical(true);
        this.scroller.setExpandHorizontal(true);
        WidgetHelper.setScrollBarIncrement((Scrollable)this.scroller, (int)512, (int)20);
        WidgetHelper.setScrollBarIncrement((Scrollable)this.scroller, (int)256, (int)20);
        this.scroller.addControlListener((ControlListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void onObjectChange(AbstractObject object) {
        if (object != null && this.isActive()) {
            this.refresh();
        }
    }

    public void activate() {
        this.refresh();
        super.activate();
    }

    public void refresh() {
        this.addressMap.setSubnet((Subnet)this.getObject());
        this.scroller.setMinSize(this.addressMap.computeSize(-1, -1));
    }

    public boolean isValidForContext(Object context) {
        return context instanceof Subnet;
    }
}

