/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Node;
import org.netxms.nxmc.base.actions.CopyTableRowsAction;
import org.netxms.nxmc.base.actions.ExportToCsvAction;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.widgets.Section;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.views.ObjectView;
import org.netxms.nxmc.modules.objects.views.helpers.OSPFAreaComparator;
import org.netxms.nxmc.modules.objects.views.helpers.OSPFAreaLabelProvider;
import org.netxms.nxmc.modules.objects.views.helpers.OSPFNeighborComparator;
import org.netxms.nxmc.modules.objects.views.helpers.OSPFNeighborLabelProvider;
import org.netxms.nxmc.resources.ResourceManager;
import org.xnap.commons.i18n.I18n;

public class OSPFView
extends ObjectView {
    private static final I18n i18n = LocalizationHelper.getI18n(OSPFView.class);
    public static final int COLUMN_AREA_ID = 0;
    public static final int COLUMN_AREA_LSA = 1;
    public static final int COLUMN_AREA_ABR = 2;
    public static final int COLUMN_AREA_ASBR = 3;
    public static final int COLUMN_NEIGHBOR_ROUTER_ID = 0;
    public static final int COLUMN_NEIGHBOR_IP_ADDRESS = 1;
    public static final int COLUMN_NEIGHBOR_NODE = 2;
    public static final int COLUMN_NEIGHBOR_IF_INDEX = 3;
    public static final int COLUMN_NEIGHBOR_INTERFACE = 4;
    public static final int COLUMN_NEIGHBOR_VIRTUAL = 5;
    public static final int COLUMN_NEIGHBOR_AREA_ID = 6;
    public static final int COLUMN_NEIGHBOR_STATE = 7;
    private SortableTableViewer viewerAreas;
    private SortableTableViewer viewerNeighbors;
    private Action actionAreasExportToCsv;
    private Action actionAreasExportAllToCsv;
    private Action actionAreasCopyRowToClipboard;
    private Action actionNeighborsExportToCsv;
    private Action actionNeighborsExportAllToCsv;
    private Action actionNeighborsCopyRowToClipboard;

    public OSPFView() {
        super(i18n.tr("OSPF"), ResourceManager.getImageDescriptor((String)"icons/object-views/ospf.png"), "OSPF", false);
    }

    public boolean isValidForContext(Object context) {
        return context != null && context instanceof Node && ((Node)context).isOSPF();
    }

    public int getPriority() {
        return 190;
    }

    protected void createContent(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = true;
        parent.setLayout((Layout)layout);
        this.createAreasSection(parent);
        this.createNeighborsSection(parent);
        this.createActions();
        this.createPopupMenu();
    }

    private void createAreasSection(Composite parent) {
        Section section = new Section(parent, i18n.tr("Areas"), false);
        section.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        String[] names = new String[]{i18n.tr("Area"), i18n.tr("LSA"), i18n.tr("ABR"), i18n.tr("ASBR")};
        int[] widths = new int[]{120, 90, 90, 90};
        this.viewerAreas = new SortableTableViewer(section.getClient(), names, widths, 0, 1024, 65538);
        this.viewerAreas.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewerAreas.setLabelProvider((IBaseLabelProvider)new OSPFAreaLabelProvider());
        this.viewerAreas.setComparator((ViewerComparator)new OSPFAreaComparator());
    }

    private void createNeighborsSection(Composite parent) {
        Section section = new Section(parent, i18n.tr("Neighbors"), false);
        section.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        String[] names = new String[]{i18n.tr("Router ID"), i18n.tr("IP address"), i18n.tr("Node"), i18n.tr("ifIndex"), i18n.tr("Interface"), i18n.tr("Virtual"), i18n.tr("Area"), i18n.tr("State")};
        int[] widths = new int[]{120, 120, 200, 90, 200, 60, 120, 150};
        this.viewerNeighbors = new SortableTableViewer(section.getClient(), names, widths, 0, 1024, 65538);
        this.viewerNeighbors.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewerNeighbors.setLabelProvider((IBaseLabelProvider)new OSPFNeighborLabelProvider());
        this.viewerNeighbors.setComparator((ViewerComparator)new OSPFNeighborComparator());
    }

    private void createActions() {
        this.actionAreasCopyRowToClipboard = new CopyTableRowsAction((ColumnViewer)this.viewerAreas, true);
        this.actionAreasExportToCsv = new ExportToCsvAction((View)this, (ColumnViewer)this.viewerAreas, true);
        this.actionAreasExportAllToCsv = new ExportToCsvAction((View)this, (ColumnViewer)this.viewerAreas, false);
        this.actionNeighborsCopyRowToClipboard = new CopyTableRowsAction((ColumnViewer)this.viewerNeighbors, true);
        this.actionNeighborsExportToCsv = new ExportToCsvAction((View)this, (ColumnViewer)this.viewerNeighbors, true);
        this.actionNeighborsExportAllToCsv = new ExportToCsvAction((View)this, (ColumnViewer)this.viewerNeighbors, false);
    }

    private void createPopupMenu() {
        MenuManager manager = new MenuManager();
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener((IMenuListener)new /* Unavailable Anonymous Inner Class!! */);
        Menu menu = manager.createContextMenu(this.viewerAreas.getControl());
        this.viewerAreas.getControl().setMenu(menu);
        manager = new MenuManager();
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener((IMenuListener)new /* Unavailable Anonymous Inner Class!! */);
        menu = manager.createContextMenu(this.viewerNeighbors.getControl());
        this.viewerNeighbors.getControl().setMenu(menu);
    }

    public void refresh() {
        if (this.getObject() == null) {
            return;
        }
        AbstractObject object = this.getObject();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    protected void onObjectChange(AbstractObject object) {
        if (this.isActive()) {
            this.refresh();
        }
    }

    public void activate() {
        super.activate();
        this.refresh();
    }
}

