/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scrollable;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Chassis;
import org.netxms.client.objects.DataCollectionTarget;
import org.netxms.client.objects.Interface;
import org.netxms.client.objects.Subnet;
import org.netxms.client.objects.Zone;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.views.ObjectView;
import org.netxms.nxmc.modules.objects.views.elements.Capabilities;
import org.netxms.nxmc.modules.objects.views.elements.Commands;
import org.netxms.nxmc.modules.objects.views.elements.Comments;
import org.netxms.nxmc.modules.objects.views.elements.Communications;
import org.netxms.nxmc.modules.objects.views.elements.Connection;
import org.netxms.nxmc.modules.objects.views.elements.ExternalResources;
import org.netxms.nxmc.modules.objects.views.elements.Inventory;
import org.netxms.nxmc.modules.objects.views.elements.LastValues;
import org.netxms.nxmc.modules.objects.views.elements.Location;
import org.netxms.nxmc.modules.objects.views.elements.ObjectInfo;
import org.netxms.nxmc.modules.objects.views.elements.ObjectState;
import org.netxms.nxmc.modules.objects.views.elements.OverviewPageElement;
import org.netxms.nxmc.modules.objects.views.elements.PollStates;
import org.netxms.nxmc.modules.objects.views.elements.Topology;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.resources.ThemeEngine;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class ObjectOverviewView
extends ObjectView {
    private static I18n i18n = LocalizationHelper.getI18n(ObjectOverviewView.class);
    private Set<OverviewPageElement> elements = new HashSet();
    private ScrolledComposite scroller;
    private Composite viewArea;
    private Composite leftColumn;
    private Composite rightColumn;
    private boolean updateLayoutOnSelect = false;

    public ObjectOverviewView() {
        super(i18n.tr("Overview"), ResourceManager.getImageDescriptor((String)"icons/object-views/overview.gif"), "ObjectOverview", false);
    }

    public boolean isValidForContext(Object context) {
        return context != null && (context instanceof DataCollectionTarget || context instanceof Chassis || context instanceof Interface || context instanceof Subnet || context instanceof Zone);
    }

    public int getPriority() {
        return 10;
    }

    protected void createContent(Composite parent) {
        this.scroller = new ScrolledComposite(parent, 512);
        this.scroller.setExpandVertical(true);
        this.scroller.setExpandHorizontal(true);
        WidgetHelper.setScrollBarIncrement((Scrollable)this.scroller, (int)512, (int)20);
        this.scroller.addControlListener((ControlListener)new /* Unavailable Anonymous Inner Class!! */);
        this.viewArea = new Composite((Composite)this.scroller, 0);
        this.viewArea.setBackground(ThemeEngine.getBackgroundColor((String)"Dashboard"));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this.viewArea.setLayout((Layout)layout);
        this.scroller.setContent((Control)this.viewArea);
        this.leftColumn = new Composite(this.viewArea, 0);
        this.leftColumn.setLayout(this.createColumnLayout());
        this.leftColumn.setBackground(this.viewArea.getBackground());
        GridData gd = new GridData();
        gd.verticalAlignment = 128;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.leftColumn.setLayoutData((Object)gd);
        this.rightColumn = new Composite(this.viewArea, 0);
        this.rightColumn.setLayout(this.createColumnLayout());
        this.rightColumn.setBackground(this.viewArea.getBackground());
        gd = new GridData();
        gd.verticalAlignment = 128;
        gd.horizontalAlignment = 16384;
        gd.grabExcessHorizontalSpace = true;
        gd.minimumWidth = -1;
        this.rightColumn.setLayoutData((Object)gd);
        ObjectInfo e = new ObjectInfo(this.leftColumn, null, (ObjectView)this);
        this.elements.add(e);
        e = new ObjectState(this.leftColumn, (OverviewPageElement)e, (ObjectView)this);
        this.elements.add(e);
        e = new Communications(this.leftColumn, (OverviewPageElement)e, (ObjectView)this);
        this.elements.add(e);
        e = new Topology(this.leftColumn, (OverviewPageElement)e, (ObjectView)this);
        this.elements.add(e);
        e = new Inventory(this.leftColumn, (OverviewPageElement)e, (ObjectView)this);
        this.elements.add(e);
        e = new Location(this.leftColumn, (OverviewPageElement)e, (ObjectView)this);
        this.elements.add(e);
        e = new LastValues(this.leftColumn, (OverviewPageElement)e, (ObjectView)this);
        this.elements.add(e);
        e = new ExternalResources(this.leftColumn, (OverviewPageElement)e, (ObjectView)this);
        this.elements.add(e);
        e = new Comments(this.leftColumn, (OverviewPageElement)e, (ObjectView)this);
        this.elements.add(e);
        e = new Commands(this.rightColumn, null, (ObjectView)this);
        this.elements.add(e);
        e = new Capabilities(this.rightColumn, (OverviewPageElement)e, (ObjectView)this);
        this.elements.add(e);
        e = new PollStates(this.rightColumn, (OverviewPageElement)e, (ObjectView)this);
        this.elements.add(e);
        e = new Connection(this.rightColumn, (OverviewPageElement)e, (ObjectView)this);
        this.elements.add(e);
    }

    private Layout createColumnLayout() {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 5;
        return layout;
    }

    protected void onObjectUpdate(AbstractObject object) {
        super.onObjectUpdate(object);
        this.onObjectChange(object);
    }

    protected void onObjectChange(AbstractObject object) {
        if (this.isActive()) {
            this.updateLayout();
        } else {
            this.updateLayoutOnSelect = true;
        }
    }

    public void activate() {
        super.activate();
        if (this.updateLayoutOnSelect) {
            this.updateLayout();
            this.updateLayoutOnSelect = false;
        }
    }

    private void updateLayout() {
        AbstractObject object = this.getObject();
        this.viewArea.setRedraw(false);
        for (OverviewPageElement element : this.elements) {
            if (object != null && element.isApplicableForObject(object)) {
                element.setObject(object);
                continue;
            }
            element.dispose();
        }
        for (OverviewPageElement element : this.elements) {
            element.fixPlacement();
        }
        this.viewArea.layout(true, true);
        this.viewArea.setRedraw(true);
        Rectangle r = this.scroller.getClientArea();
        this.scroller.setMinSize(this.viewArea.computeSize(r.width, -1));
        Point s = this.viewArea.getSize();
        this.viewArea.redraw(0, 0, s.x, s.y, true);
    }

    public void refresh() {
        new /* Unavailable Anonymous Inner Class!! */.start();
    }
}

