/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views;

import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Node;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.views.ObjectView;
import org.netxms.nxmc.modules.objects.views.ProcessesView;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class ProcessesView
extends ObjectView {
    private static final I18n i18n = LocalizationHelper.getI18n(ProcessesView.class);
    public static final int COLUMN_PID = 0;
    public static final int COLUMN_NAME = 1;
    public static final int COLUMN_USER = 2;
    public static final int COLUMN_THREADS = 3;
    public static final int COLUMN_HANDLES = 4;
    public static final int COLUMN_VMSIZE = 5;
    public static final int COLUMN_RSS = 6;
    public static final int COLUMN_PAGE_FAULTS = 7;
    public static final int COLUMN_KTIME = 8;
    public static final int COLUMN_UTIME = 9;
    public static final int COLUMN_CMDLINE = 10;
    private SortableTableViewer viewer;
    private Action actionTerminate;
    private String filterString = null;

    public ProcessesView() {
        super(i18n.tr("Processes"), ResourceManager.getImageDescriptor((String)"icons/object-views/processes.png"), "Processes", true);
    }

    public boolean isValidForContext(Object context) {
        return context != null && context instanceof Node && ((Node)context).hasAgent();
    }

    public int getPriority() {
        return 70;
    }

    protected void onObjectChange(AbstractObject object) {
        this.clearMessages();
        if (this.isActive()) {
            this.refresh();
        } else {
            this.viewer.setInput((Object)new Object[0]);
        }
    }

    public void activate() {
        super.activate();
        this.refresh();
    }

    protected void createContent(Composite parent) {
        String[] names = new String[]{"PID", "Name", "User", "Threads", "Handles", "VM Size", "RSS", "Page faults", "System time", "User time", "Command line"};
        int[] widths = new int[]{90, 200, 140, 90, 90, 90, 90, 90, 90, 90, 500};
        this.viewer = new SortableTableViewer(parent, names, widths, 1, 128, 65538);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ProcessLabelProvider());
        this.viewer.setComparator((ViewerComparator)new ProcessComparator());
        this.viewer.addFilter((ViewerFilter)new ProcessFilter(this));
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (String)"ProcessTable");
        this.viewer.getTable().addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.createActions();
        this.createContextMenu();
    }

    private void createActions() {
        this.actionTerminate = new /* Unavailable Anonymous Inner Class!! */;
    }

    private void createContextMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)new /* Unavailable Anonymous Inner Class!! */);
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionTerminate);
    }

    public void refresh() {
        long nodeId = this.getObjectId();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void terminateProcess() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.isEmpty()) {
            return;
        }
        if (!MessageDialogHelper.openQuestion((Shell)this.getWindow().getShell(), (String)i18n.tr("Terminate Process"), (String)i18n.tr("Selected processes will be terminated. Are you sure?"))) {
            return;
        }
        ArrayList<Long> processes = new ArrayList<Long>(selection.size());
        for (Object o : selection.toList()) {
            processes.add(((Process)o).data[0]);
        }
        long nodeId = this.getObjectId();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    protected void onFilterModify() {
        this.filterString = this.getFilterText();
        this.viewer.refresh(false);
    }
}

