/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views;

import java.util.ArrayList;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.DisposeListener;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.AccessPoint;
import org.netxms.client.objects.Interface;
import org.netxms.client.topology.RadioInterface;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.views.NodeSubObjectTableView;
import org.netxms.nxmc.modules.objects.views.helpers.RadioInterfaceComparator;
import org.netxms.nxmc.modules.objects.views.helpers.RadioInterfaceLabelProvider;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class RadioInterfaces
extends NodeSubObjectTableView {
    private static final I18n i18n = LocalizationHelper.getI18n(RadioInterfaces.class);
    public static final int COLUMN_AP_NAME = 0;
    public static final int COLUMN_AP_MAC_ADDR = 1;
    public static final int COLUMN_AP_VENDOR = 2;
    public static final int COLUMN_AP_MODEL = 3;
    public static final int COLUMN_AP_SERIAL = 4;
    public static final int COLUMN_INDEX = 5;
    public static final int COLUMN_NAME = 6;
    public static final int COLUMN_MAC_ADDR = 7;
    public static final int COLUMN_NIC_VENDOR = 8;
    public static final int COLUMN_CHANNEL = 9;
    public static final int COLUMN_TX_POWER_DBM = 10;
    public static final int COLUMN_TX_POWER_MW = 11;

    public RadioInterfaces() {
        super(i18n.tr("Radios"), ResourceManager.getImageDescriptor((String)"icons/object-views/radio_interfaces.png"), "Radios", false);
    }

    public int getPriority() {
        return 53;
    }

    public boolean isValidForContext(Object context) {
        return context != null && (context instanceof AbstractNode && ((AbstractNode)context).isWirelessController() || context instanceof AccessPoint);
    }

    protected void createViewer() {
        String[] names = new String[]{i18n.tr("AP Name"), i18n.tr("AP MAC Address"), i18n.tr("AP Vendor"), i18n.tr("AP Model"), i18n.tr("AP Serial"), i18n.tr("Radio Index"), i18n.tr("Radio Name"), i18n.tr("Radio MAC Address"), "NIC vendor", i18n.tr("Channel"), i18n.tr("Tx Power dBm"), i18n.tr("Tx Power mW")};
        int[] widths = new int[]{120, 100, 140, 140, 100, 90, 120, 100, 200, 90, 90, 90};
        this.viewer = new SortableTableViewer(this.mainArea, names, widths, 1, 128, 65538);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new RadioInterfaceLabelProvider((TableViewer)this.viewer));
        this.viewer.setComparator((ViewerComparator)new RadioInterfaceComparator());
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (String)"RadioInterfaces");
        this.viewer.getTable().addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.createPopupMenu();
    }

    public void refresh() {
        if (this.getObject() == null) {
            this.viewer.setInput((Object)new Interface[0]);
            return;
        }
        ArrayList<RadioInterface> list = new ArrayList<RadioInterface>();
        if (this.getObject() instanceof AccessPoint) {
            for (RadioInterface rif : ((AccessPoint)this.getObject()).getRadios()) {
                list.add(rif);
            }
        } else {
            for (AbstractObject o : this.getObject().getAllChildren(33)) {
                for (RadioInterface rif : ((AccessPoint)o).getRadios()) {
                    list.add(rif);
                }
            }
        }
        this.viewer.setInput(list);
    }

    public boolean needRefreshOnObjectChange(AbstractObject object) {
        return object instanceof AccessPoint && object.isChildOf(this.getObjectId());
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionCopyToClipboard);
        manager.add((IAction)this.actionExportToCsv);
    }
}

