/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views;

import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Cluster;
import org.netxms.client.objects.ClusterResource;
import org.netxms.nxmc.base.views.AbstractViewerFilter;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.views.ObjectView;
import org.netxms.nxmc.modules.objects.views.helpers.ClusterResourceListComparator;
import org.netxms.nxmc.modules.objects.views.helpers.ClusterResourceListFilter;
import org.netxms.nxmc.modules.objects.views.helpers.ClusterResourceListLabelProvider;
import org.netxms.nxmc.resources.ResourceManager;
import org.xnap.commons.i18n.I18n;

public class ResourcesView
extends ObjectView {
    private static I18n i18n = LocalizationHelper.getI18n(ResourcesView.class);
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_VIP = 1;
    public static final int COLUMN_OWNER = 2;
    private SortableTableViewer resourceList;
    private Cluster cluster;

    public ResourcesView() {
        super(i18n.tr("Resources"), ResourceManager.getImageDescriptor((String)"icons/object-views/cluster.png"), "Resources", true);
    }

    protected void createContent(Composite parent) {
        String[] names = new String[]{i18n.tr("Resource"), i18n.tr("VIP"), i18n.tr("Owner")};
        int[] widths = new int[]{200, 120, 150};
        this.resourceList = new SortableTableViewer(parent, names, widths, 0, 128, -1);
        this.resourceList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.resourceList.setLabelProvider((IBaseLabelProvider)new ClusterResourceListLabelProvider());
        this.resourceList.setComparator((ViewerComparator)new ClusterResourceListComparator());
        ClusterResourceListFilter filter = new ClusterResourceListFilter();
        this.resourceList.addFilter((ViewerFilter)filter);
        this.setFilterClient((ISelectionProvider)this.resourceList, (AbstractViewerFilter)filter);
    }

    protected void onObjectChange(AbstractObject object) {
        if (object instanceof Cluster) {
            this.cluster = (Cluster)object;
            this.resourceList.setInput((Object)this.cluster.getResources().toArray());
        } else {
            this.cluster = null;
            this.resourceList.setInput((Object)new ClusterResource[0]);
        }
    }

    public int getPriority() {
        return 15;
    }

    public boolean isValidForContext(Object context) {
        return context != null && context instanceof Cluster;
    }
}

