/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views.elements;

import java.util.Collections;
import java.util.List;
import org.eclipse.swt.widgets.Composite;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Asset;
import org.netxms.client.objects.Cluster;
import org.netxms.client.objects.NetworkMap;
import org.netxms.client.objects.Subnet;
import org.netxms.client.objects.Zone;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.localization.DateFormatFactory;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.views.ObjectView;
import org.netxms.nxmc.modules.objects.views.elements.OverviewPageElement;
import org.netxms.nxmc.modules.objects.views.elements.TableElement;
import org.xnap.commons.i18n.I18n;

public class ObjectInfo
extends TableElement {
    private final I18n i18n = LocalizationHelper.getI18n(ObjectInfo.class);

    public ObjectInfo(Composite parent, OverviewPageElement anchor, ObjectView objectView) {
        super(parent, anchor, objectView);
    }

    protected void fillTable() {
        Asset asset;
        AbstractObject object = this.getObject();
        NXCSession session = Registry.getSession();
        this.addPair(this.i18n.tr("ID"), Long.toString(object.getObjectId()));
        if (object.getGuid() != null) {
            this.addPair(this.i18n.tr("GUID"), object.getGuid().toString());
        }
        this.addPair(this.i18n.tr("Class"), object.getObjectClassName());
        this.addPair(this.i18n.tr("Alias"), object.getAlias(), false);
        if (object.getCreationTime() != null && object.getCreationTime().getTime() != 0L) {
            this.addPair(this.i18n.tr("Creation time"), DateFormatFactory.getDateTimeFormat().format(object.getCreationTime()), false);
        }
        if (object.getAssetId() != 0L && (asset = (AbstractObject)session.findObjectById(object.getAssetId(), Asset.class)) != null) {
            List parents = asset.getParentChain(null);
            Collections.reverse(parents);
            StringBuilder sb = new StringBuilder();
            for (AbstractObject parent : parents) {
                sb.append(parent.getObjectName());
                sb.append("/");
            }
            sb.append(asset.getObjectName());
            this.addPair(this.i18n.tr("Asset"), sb.toString(), false);
        }
        switch (object.getObjectClass()) {
            case 16: {
                asset = (Asset)object;
                if (asset.getLinkedObjectId() == 0L) break;
                this.addPair(this.i18n.tr("Linked to"), session.getObjectNameWithAlias(asset.getLinkedObjectId()));
                break;
            }
            case 14: {
                Cluster cluster = (Cluster)object;
                if (!session.isZoningEnabled()) break;
                this.addPair(this.i18n.tr("Zone UIN"), this.getZoneName(cluster.getZoneId()));
                break;
            }
            case 21: {
                NetworkMap map = (NetworkMap)object;
                this.addPair(this.i18n.tr("Map type"), this.getMapTypeDescription(map.getMapType()));
                break;
            }
            case 1: {
                Subnet subnet = (Subnet)object;
                if (session.isZoningEnabled()) {
                    this.addPair(this.i18n.tr("Zone UIN"), this.getZoneName(subnet.getZoneId()));
                }
                this.addPair(this.i18n.tr("IP address"), subnet.getNetworkAddress().toString());
                break;
            }
            case 6: {
                Zone zone = (Zone)object;
                this.addPair(this.i18n.tr("Zone UIN"), Long.toString(zone.getUIN()));
                break;
            }
        }
    }

    protected String getTitle() {
        return this.i18n.tr("Object");
    }

    private String getZoneName(int zoneId) {
        Zone zone = Registry.getSession().findZone(zoneId);
        if (zone == null) {
            return Long.toString(zoneId);
        }
        return String.format("%d (%s)", zoneId, zone.getObjectName());
    }

    private String getMapTypeDescription(int mapType) {
        switch (mapType) {
            case 0: {
                return this.i18n.tr("Custom");
            }
            case 3: {
                return this.i18n.tr("Internal Topology");
            }
            case 2: {
                return this.i18n.tr("IP Topology");
            }
            case 1: {
                return this.i18n.tr("L2 Tpology");
            }
            case 4: {
                return this.i18n.tr("OSPF Topology");
            }
        }
        return this.i18n.tr("Unknown ({0})", (Object)Integer.toString(mapType));
    }
}

