/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views.helpers;

import java.net.InetAddress;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.netxms.client.NXCSession;
import org.netxms.client.topology.ArpCacheEntry;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.tools.ComparatorHelper;

public class ArpCacheComparator
extends ViewerComparator {
    private NXCSession session = Registry.getSession();

    public int compare(Viewer viewer, Object e1, Object e2) {
        ArpCacheEntry arp1 = (ArpCacheEntry)e1;
        ArpCacheEntry arp2 = (ArpCacheEntry)e2;
        int result = switch ((Integer)((SortableTableViewer)viewer).getTable().getSortColumn().getData("ID")) {
            case 3 -> arp1.getInterfaceName().compareToIgnoreCase(arp2.getInterfaceName());
            case 0 -> ComparatorHelper.compareInetAddresses((InetAddress)arp1.getIpAddress(), (InetAddress)arp2.getIpAddress());
            case 1 -> arp1.getMacAddress().compareTo(arp2.getMacAddress());
            case 4 -> {
                String n1 = arp1.getNodeId() != 0L ? this.session.getObjectName(arp1.getNodeId()) : "";
                String n2 = arp2.getNodeId() != 0L ? this.session.getObjectName(arp2.getNodeId()) : "";
                yield n1.compareToIgnoreCase(n2);
            }
            case 2 -> this.getVendor(arp1).compareTo(this.getVendor(arp2));
            default -> 0;
        };
        return ((SortableTableViewer)viewer).getTable().getSortDirection() == 128 ? result : -result;
    }

    private String getVendor(ArpCacheEntry entry) {
        String vendor = this.session.getVendorByMac(entry.getMacAddress(), null);
        return vendor != null ? vendor : "";
    }
}

