/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.widgets;

import org.apache.commons.lang3.SystemUtils;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TableItem;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.views.ObjectView;
import org.netxms.nxmc.modules.objects.widgets.AbstractHardwareInventoryWidget;
import org.netxms.nxmc.modules.objects.widgets.helpers.HardwareComponentComparator;
import org.netxms.nxmc.modules.objects.widgets.helpers.HardwareComponentLabelProvider;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class HardwareInventoryTable
extends AbstractHardwareInventoryWidget {
    public static final int COLUMN_CATEGORY = 0;
    public static final int COLUMN_INDEX = 1;
    public static final int COLUMN_TYPE = 2;
    public static final int COLUMN_VENDOR = 3;
    public static final int COLUMN_MODEL = 4;
    public static final int COLUMN_CAPACITY = 5;
    public static final int COLUMN_PART_NUMBER = 6;
    public static final int COLUMN_SERIAL_NUMBER = 7;
    public static final int COLUMN_LOCATION = 8;
    public static final int COLUMN_DESCRIPTION = 9;
    private final I18n i18n = LocalizationHelper.getI18n(HardwareInventoryTable.class);
    private SortableTableViewer viewer;

    public HardwareInventoryTable(Composite parent, int style, ObjectView view) {
        super(parent, style, view);
        String[] names = new String[]{this.i18n.tr("Category"), this.i18n.tr("Index"), this.i18n.tr("Type"), this.i18n.tr("Vendor"), this.i18n.tr("Model"), this.i18n.tr("Capacity"), this.i18n.tr("Part number"), this.i18n.tr("Serial number"), this.i18n.tr("Location"), this.i18n.tr("Description")};
        int[] widths = new int[]{100, 70, 100, 200, 200, 90, 130, 130, 200, 300};
        this.viewer = new SortableTableViewer((Composite)this, names, widths, 0, 128, 65538);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new HardwareComponentLabelProvider());
        this.viewer.setComparator((ViewerComparator)new HardwareComponentComparator());
    }

    public void refresh() {
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    public ColumnViewer getViewer() {
        return this.viewer;
    }

    public void copySelectionToClipboard(int column) {
        TableItem[] selection = this.viewer.getTable().getSelection();
        if (selection.length > 0) {
            String newLine = SystemUtils.IS_OS_WINDOWS ? "\r\n" : "\n";
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < selection.length; ++i) {
                if (i > 0) {
                    sb.append(newLine);
                }
                if (column == -1) {
                    sb.append(selection[i].getText(0));
                    for (int j = 1; j < this.viewer.getTable().getColumnCount(); ++j) {
                        sb.append("\t");
                        sb.append(selection[i].getText(j));
                    }
                    continue;
                }
                sb.append(selection[i].getText(column));
            }
            WidgetHelper.copyToClipboard((String)sb.toString());
        }
    }

    public int getNameColumnIndex() {
        return -1;
    }

    public int getDescriptionColumnIndex() {
        return 9;
    }

    public int getModelColumnIndex() {
        return 4;
    }

    public int getSerialColumnIndex() {
        return 7;
    }
}

