/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.widgets;

import java.util.ArrayList;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Node;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.AbstractViewerFilter;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.base.widgets.SortableTreeViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.views.ObjectView;
import org.netxms.nxmc.modules.objects.widgets.helpers.SoftwareInventoryContentProvider;
import org.netxms.nxmc.modules.objects.widgets.helpers.SoftwarePackageComparator;
import org.netxms.nxmc.modules.objects.widgets.helpers.SoftwarePackageFilter;
import org.netxms.nxmc.modules.objects.widgets.helpers.SoftwarePackageLabelProvider;
import org.xnap.commons.i18n.I18n;

public class SoftwareInventory
extends Composite {
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_VERSION = 1;
    public static final int COLUMN_VENDOR = 2;
    public static final int COLUMN_DATE = 3;
    public static final int COLUMN_DESCRIPTION = 4;
    public static final int COLUMN_URL = 5;
    private final I18n i18n = LocalizationHelper.getI18n(SoftwareInventory.class);
    private final String[] names = new String[]{this.i18n.tr("Name"), this.i18n.tr("Version"), this.i18n.tr("Vendor"), this.i18n.tr("Install Date"), this.i18n.tr("Description"), this.i18n.tr("URL")};
    private final int[] widths = new int[]{200, 100, 200, 100, 300, 200};
    private ObjectView view;
    private ColumnViewer viewer;
    private SoftwarePackageFilter filter = new SoftwarePackageFilter();
    private MenuManager menuManager = null;

    public SoftwareInventory(Composite parent, int style, ObjectView view) {
        super(parent, style);
        this.view = view;
        this.setLayout((Layout)new FillLayout());
        this.createTableViewer();
    }

    private void createTableViewer() {
        this.viewer = new SortableTableViewer((Composite)this, this.names, this.widths, 0, 128, 65538);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new SoftwarePackageLabelProvider(false));
        this.viewer.setComparator((ViewerComparator)new SoftwarePackageComparator());
        this.viewer.addFilter((ViewerFilter)this.filter);
        this.view.setFilterClient((ISelectionProvider)this.viewer, (AbstractViewerFilter)this.filter);
        if (this.menuManager != null) {
            Menu menu = this.menuManager.createContextMenu(this.viewer.getControl());
            this.viewer.getControl().setMenu(menu);
        }
    }

    private void createTreeViewer() {
        this.viewer = new SortableTreeViewer((Composite)this, this.names, this.widths, 0, 128, 65538);
        this.viewer.setContentProvider((IContentProvider)new SoftwareInventoryContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new SoftwarePackageLabelProvider(true));
        this.viewer.setComparator((ViewerComparator)new SoftwarePackageComparator());
        this.viewer.addFilter((ViewerFilter)this.filter);
        this.view.setFilterClient((ISelectionProvider)this.viewer, (AbstractViewerFilter)this.filter);
        if (this.menuManager != null) {
            Menu menu = this.menuManager.createContextMenu(this.viewer.getControl());
            this.viewer.getControl().setMenu(menu);
        }
    }

    public void refresh() {
        NXCSession session = Registry.getSession();
        AbstractObject object = this.view.getObject();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    public void setRootObjectId(long rootObjectId) {
        AbstractObject object = Registry.getSession().findObjectById(rootObjectId);
        if (object instanceof Node) {
            if (!(this.viewer instanceof SortableTableViewer)) {
                this.viewer.getControl().dispose();
                this.createTableViewer();
                this.layout(true, true);
            }
        } else if (!(this.viewer instanceof SortableTreeViewer)) {
            this.viewer.getControl().dispose();
            this.createTreeViewer();
            this.layout(true, true);
        }
    }

    public ColumnViewer getViewer() {
        return this.viewer;
    }

    public void setViewerMenu(MenuManager manager) {
        this.menuManager = manager;
        if (this.viewer != null) {
            Menu menu = this.menuManager.createContextMenu(this.viewer.getControl());
            this.viewer.getControl().setMenu(menu);
        }
    }

    public void clear() {
        this.viewer.setInput(new ArrayList());
    }

    public SoftwarePackageFilter getFilter() {
        return this.filter;
    }
}

