/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.widgets.helpers;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.netxms.client.HardwareComponent;
import org.netxms.client.constants.DataType;
import org.netxms.client.constants.HardwareComponentCategory;
import org.netxms.client.datacollection.DataFormatter;
import org.netxms.client.datacollection.MeasurementUnit;
import org.netxms.nxmc.modules.objects.widgets.helpers.HardwareComponentLabelProvider;

public class HardwareComponentLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private Map<HardwareComponentCategory, String> categoryNames = new HashMap();

    public HardwareComponentLabelProvider() {
        this.categoryNames.put(HardwareComponentCategory.BASEBOARD, "Baseboard");
        this.categoryNames.put(HardwareComponentCategory.BATTERY, "Battery");
        this.categoryNames.put(HardwareComponentCategory.MEMORY_DEVICE, "Memory device");
        this.categoryNames.put(HardwareComponentCategory.NETWORK_ADAPTER, "Network adapter");
        this.categoryNames.put(HardwareComponentCategory.OTHER, "Other");
        this.categoryNames.put(HardwareComponentCategory.PROCESSOR, "Processor");
        this.categoryNames.put(HardwareComponentCategory.STORAGE_DEVICE, "Storage device");
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        HardwareComponent c = (HardwareComponent)element;
        switch (columnIndex) {
            case 5: {
                switch (1.$SwitchMap$org$netxms$client$constants$HardwareComponentCategory[c.getCategory().ordinal()]) {
                    case 1: {
                        return Long.toString(c.getCapacity()) + " mWh";
                    }
                    case 2: 
                    case 3: {
                        return new DataFormatter("%{u,m}s", DataType.UINT64, MeasurementUnit.BYTES_IEC).format(Long.toString(c.getCapacity()), null);
                    }
                    case 4: {
                        return new DataFormatter("%{u,m}s", DataType.UINT64, MeasurementUnit.BPS_METRIC).format(Long.toString(c.getCapacity()), null);
                    }
                    case 5: {
                        return new DataFormatter("%{u,m}s", DataType.UINT64, MeasurementUnit.HZ).format(Long.toString(c.getCapacity() * 1000000L), null);
                    }
                }
                return "";
            }
            case 0: {
                return (String)this.categoryNames.get(c.getCategory());
            }
            case 9: {
                return c.getDescription();
            }
            case 1: {
                return Integer.toString(c.getIndex());
            }
            case 8: {
                return c.getLocation();
            }
            case 4: {
                return c.getModel();
            }
            case 6: {
                return c.getPartNumber();
            }
            case 7: {
                return c.getSerialNumber();
            }
            case 2: {
                return c.getType();
            }
            case 3: {
                return c.getVendor();
            }
        }
        return null;
    }
}

