/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objecttools.views.helpers;

import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.netxms.client.constants.Severity;
import org.netxms.nxmc.modules.objects.widgets.helpers.BaseObjectLabelProvider;
import org.netxms.nxmc.modules.objecttools.widgets.AbstractObjectToolExecutor;
import org.netxms.nxmc.resources.SharedIcons;
import org.netxms.nxmc.resources.StatusDisplayInfo;

public class ExecutorListLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private BaseObjectLabelProvider objectLabelProvider = new BaseObjectLabelProvider();

    public Image getColumnImage(Object element, int columnIndex) {
        AbstractObjectToolExecutor e = (AbstractObjectToolExecutor)element;
        switch (columnIndex) {
            case 0: {
                return this.objectLabelProvider.getImage((Object)e.getObject());
            }
            case 1: {
                if (e.isRunning()) {
                    return SharedIcons.IMG_EXECUTE;
                }
                if (e.isFailed()) {
                    return StatusDisplayInfo.getStatusImage((Severity)Severity.CRITICAL);
                }
                return StatusDisplayInfo.getStatusImage((Severity)Severity.NORMAL);
            }
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        AbstractObjectToolExecutor e = (AbstractObjectToolExecutor)element;
        switch (columnIndex) {
            case 0: {
                return e.getObject().getObjectName();
            }
            case 1: {
                return e.isRunning() ? "Running" : (e.isFailed() ? "Failed (" + e.getFailureReason() + ")" : "Completed");
            }
        }
        return null;
    }

    public void dispose() {
        this.objectLabelProvider.dispose();
        super.dispose();
    }
}

