/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.reporting.widgets;

import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.reporting.ReportParameter;
import org.netxms.client.users.AbstractUserObject;
import org.netxms.client.users.User;
import org.netxms.nxmc.base.widgets.ImageHyperlink;
import org.netxms.nxmc.base.widgets.events.IHyperlinkListener;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.reporting.widgets.ReportFieldEditor;
import org.netxms.nxmc.modules.users.dialogs.UserSelectionDialog;
import org.netxms.nxmc.modules.users.views.helpers.DecoratingUserLabelProvider;
import org.netxms.nxmc.resources.SharedIcons;
import org.xnap.commons.i18n.I18n;

public class UserFieldEditor
extends ReportFieldEditor {
    private final I18n i18n = LocalizationHelper.getI18n(UserFieldEditor.class);
    private DecoratingUserLabelProvider labelProvider;
    private CLabel text;
    private boolean returnName;
    private AbstractUserObject user;
    private String emptySelectionText;

    public UserFieldEditor(ReportParameter parameter, Composite parent, boolean returnName) {
        super(parameter, parent);
        this.returnName = returnName;
        this.labelProvider = new DecoratingUserLabelProvider();
        this.addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.emptySelectionText = this.i18n.tr("None");
    }

    protected Control createContent(Composite parent) {
        Composite content = new Composite(parent, 2048);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.horizontalSpacing = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        content.setLayout((Layout)layout);
        this.text = new CLabel(content, 0);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 128;
        this.text.setLayoutData((Object)gd);
        this.text.setText(this.emptySelectionText);
        ImageHyperlink selectionLink = new ImageHyperlink(content, 0);
        selectionLink.setImage(SharedIcons.IMG_FIND);
        selectionLink.addHyperlinkListener((IHyperlinkListener)new /* Unavailable Anonymous Inner Class!! */);
        return content;
    }

    protected void selectUser() {
        UserSelectionDialog dialog = new UserSelectionDialog(this.getShell(), User.class);
        if (dialog.open() == 0) {
            AbstractUserObject[] selection = dialog.getSelection();
            if (selection.length > 0) {
                AbstractUserObject user;
                this.user = user = selection[0];
                this.text.setText(user.getName());
                this.text.setImage(this.labelProvider.getImage((Object)user));
            } else {
                this.user = null;
                this.text.setText(this.emptySelectionText);
                this.text.setImage(null);
            }
        }
    }

    public String getValue() {
        if (this.user != null) {
            if (this.returnName) {
                return this.user.getName();
            }
            return Long.toString(this.user.getId());
        }
        return null;
    }
}

