/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.serverconfig.dialogs;

import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.netxms.client.ScheduledTask;
import org.netxms.client.objects.AbstractObject;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.base.widgets.ScheduleEditor;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.widgets.ObjectSelector;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class ScheduledTaskEditDialog
extends Dialog {
    private final I18n i18n = LocalizationHelper.getI18n(ScheduledTaskEditDialog.class);
    private ScheduledTask task;
    private List<String> types;
    private LabeledText parameters;
    private Text comments;
    private Combo taskType;
    private ScheduleEditor scheduleEditor;
    private ObjectSelector objectSelector;

    public ScheduledTaskEditDialog(Shell shell, ScheduledTask task, List<String> types) {
        super(shell);
        this.task = task != null ? task : new ScheduledTask();
        this.types = types;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Edit Scheduled Task");
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        dialogArea.setLayout((Layout)layout);
        this.taskType = new Combo(dialogArea, 8);
        for (String type : this.types) {
            this.taskType.add(type);
        }
        int taskId = this.types.indexOf(this.task.getTaskHandlerId());
        this.taskType.select(taskId == -1 ? 0 : taskId);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        this.taskType.setLayoutData((Object)gd);
        this.objectSelector = new ObjectSelector(dialogArea, 0, true);
        this.objectSelector.setLabel("Select execution object");
        this.objectSelector.setObjectClass(AbstractObject.class);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        this.objectSelector.setLayoutData((Object)gd);
        this.objectSelector.setObjectId(this.task.getObjectId());
        this.parameters = new LabeledText(dialogArea, 0);
        this.parameters.setLabel("Parameters");
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        this.parameters.setLayoutData((Object)gd);
        this.parameters.setText(this.task.getParameters());
        this.comments = WidgetHelper.createLabeledText((Composite)dialogArea, (int)2050, (int)-1, (String)"Description", (String)this.task.getComments(), (Object)"WidgetHelper::default_layout_data");
        this.comments.setTextLimit(255);
        gd = new GridData();
        gd.horizontalSpan = 2;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.heightHint = 100;
        gd.verticalAlignment = 4;
        this.comments.setLayoutData((Object)gd);
        if ((this.task.getFlags() & 8) != 0) {
            this.taskType.add(this.task.getTaskHandlerId());
            this.taskType.select(this.types.size());
            this.taskType.setEnabled(false);
            this.objectSelector.setEnabled(false);
            this.parameters.setEnabled(false);
        }
        Group scheduleGroup = new Group(dialogArea, 0);
        scheduleGroup.setText(this.i18n.tr("Schedule"));
        scheduleGroup.setLayout((Layout)new GridLayout());
        this.scheduleEditor = new ScheduleEditor((Composite)scheduleGroup, 0);
        this.scheduleEditor.setSchedule(this.task);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        return dialogArea;
    }

    protected void okPressed() {
        ScheduledTask schedule = this.scheduleEditor.getSchedule();
        this.task.setSchedule(schedule.getSchedule());
        this.task.setExecutionTime(schedule.getExecutionTime());
        this.task.setComments(this.comments.getText());
        if ((this.task.getFlags() & 8) == 0) {
            this.task.setTaskHandlerId((String)this.types.get(this.taskType.getSelectionIndex()));
            this.task.setParameters(this.parameters.getText());
            this.task.setObjectId(this.objectSelector.getObjectId());
        }
        super.okPressed();
    }

    public ScheduledTask getTask() {
        return this.task;
    }
}

