/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.serverconfig.views;

import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.users.TwoFactorAuthenticationMethod;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.AbstractViewerFilter;
import org.netxms.nxmc.base.views.ConfigurationView;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.serverconfig.dialogs.TwoFactorAuthMethodEditDialog;
import org.netxms.nxmc.modules.serverconfig.views.helpers.TwoFactorMethodFilter;
import org.netxms.nxmc.modules.serverconfig.views.helpers.TwoFactorMethodLabelProvider;
import org.netxms.nxmc.modules.serverconfig.views.helpers.TwoFactorMethodListComparator;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class TwoFactorAuthenticationMethods
extends ConfigurationView {
    private static final I18n i18n = LocalizationHelper.getI18n(TwoFactorAuthenticationMethods.class);
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_DRIVER = 1;
    public static final int COLUMN_STATUS = 2;
    public static final int COLUMN_DESCRIPTION = 3;
    private NXCSession session = Registry.getSession();
    private SessionListener listener;
    private SortableTableViewer viewer;
    private Action actionNewMethod;
    private Action actionEditMethod;
    private Action actionDeleteMethod;

    public TwoFactorAuthenticationMethods() {
        super(i18n.tr("Two-Factor Authentication Methods"), ResourceManager.getImageDescriptor((String)"icons/config-views/2fa.png"), "TwoFactorAuthenticationMethods", true);
    }

    public void createContent(Composite parent) {
        int[] widths = new int[]{160, 120, 80, 500};
        String[] names = new String[]{"Name", "Driver", "Status", "Description"};
        this.viewer = new SortableTableViewer(parent, names, widths, 0, 128, 65538);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new TwoFactorMethodLabelProvider());
        this.viewer.setComparator((ViewerComparator)new TwoFactorMethodListComparator());
        this.viewer.addDoubleClickListener((IDoubleClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        TwoFactorMethodFilter filter = new TwoFactorMethodFilter();
        this.viewer.addFilter((ViewerFilter)filter);
        this.setFilterClient((ISelectionProvider)this.viewer, (AbstractViewerFilter)filter);
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (String)"TwoFactorAuthenticationMethods");
        this.viewer.getTable().addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.createActions();
        this.createPopupMenu();
        Display display = this.getDisplay();
        this.listener = new /* Unavailable Anonymous Inner Class!! */;
        this.session.addListener(this.listener);
    }

    protected void postContentCreate() {
        super.postContentCreate();
        this.refresh();
    }

    public void dispose() {
        if (this.listener != null) {
            this.session.removeListener(this.listener);
        }
        super.dispose();
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    private void createActions() {
        this.actionNewMethod = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("M1+N", (IAction)this.actionNewMethod);
        this.actionEditMethod = new /* Unavailable Anonymous Inner Class!! */;
        this.actionEditMethod.setEnabled(false);
        this.addKeyBinding("M3+ENTER", (IAction)this.actionEditMethod);
        this.actionDeleteMethod = new /* Unavailable Anonymous Inner Class!! */;
        this.actionDeleteMethod.setEnabled(false);
        this.addKeyBinding("M1+D", (IAction)this.actionDeleteMethod);
    }

    protected void fillLocalMenu(IMenuManager manager) {
        manager.add((IAction)this.actionNewMethod);
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionNewMethod);
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)new /* Unavailable Anonymous Inner Class!! */);
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager mgr) {
        mgr.add((IAction)this.actionNewMethod);
        mgr.add((IAction)this.actionEditMethod);
        mgr.add((IAction)this.actionDeleteMethod);
    }

    public void refresh() {
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void createNewMethod() {
        TwoFactorAuthMethodEditDialog dlg = new TwoFactorAuthMethodEditDialog(this.getWindow().getShell(), null);
        if (dlg.open() != 0) {
            return;
        }
        TwoFactorAuthenticationMethod method = dlg.getMethod();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void editMethod() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        TwoFactorAuthenticationMethod method = (TwoFactorAuthenticationMethod)selection.getFirstElement();
        TwoFactorAuthMethodEditDialog dlg = new TwoFactorAuthMethodEditDialog(this.getWindow().getShell(), method);
        if (dlg.open() != 0) {
            return;
        }
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void deleteMethods() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.isEmpty()) {
            return;
        }
        if (!MessageDialogHelper.openQuestion((Shell)this.getWindow().getShell(), (String)i18n.tr("Delete Methods"), (String)i18n.tr("Are you sure you want to delete selected methods?"))) {
            return;
        }
        ArrayList<String> methods = new ArrayList<String>(selection.size());
        for (Object o : selection.toList()) {
            if (!(o instanceof TwoFactorAuthenticationMethod)) continue;
            methods.add(((TwoFactorAuthenticationMethod)o).getName());
        }
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    public boolean isModified() {
        return false;
    }

    public void save() {
    }
}

