/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.tools.views;

import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.base.MacAddress;
import org.netxms.base.MacAddressFormatException;
import org.netxms.client.NXCSession;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.tools.widgets.SearchResult;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.resources.SharedIcons;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.xnap.commons.i18n.I18n;

public class MACAddressSearchView
extends View {
    private static final I18n i18n = LocalizationHelper.getI18n(MACAddressSearchView.class);
    private SearchResult searchResultWidget;
    private Button startButton;
    private LabeledText queryEditor;

    public MACAddressSearchView() {
        super(i18n.tr("MAC Address Search"), ResourceManager.getImageDescriptor((String)"icons/tool-views/search_history.png"), "MACAddressSearch", false);
    }

    protected void postClone(View origin) {
        super.postClone(origin);
        MACAddressSearchView view = (MACAddressSearchView)origin;
        this.queryEditor.setText(view.queryEditor.getText());
        this.searchResultWidget.copyResults(view.searchResultWidget);
    }

    protected void createContent(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        parent.setLayout((Layout)layout);
        Composite searchBar = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        searchBar.setLayout((Layout)gridLayout);
        searchBar.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.queryEditor = new LabeledText(searchBar, 0);
        this.queryEditor.setLabel("Search string");
        this.queryEditor.getTextControl().addKeyListener((KeyListener)new /* Unavailable Anonymous Inner Class!! */);
        this.queryEditor.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.startButton = new Button(searchBar, 8);
        this.startButton.setImage(SharedIcons.IMG_EXECUTE);
        this.startButton.setText("Start");
        this.startButton.setToolTipText("Start search");
        this.startButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.startButton.setLayoutData((Object)new GridData(4, 1024, false, false));
        new Label(parent, 258).setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.searchResultWidget = new SearchResult((View)this, parent, 0, this.getBaseId());
        this.searchResultWidget.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        this.searchResultWidget.fillLocalToolBar(manager);
    }

    protected void fillLocalMenu(IMenuManager manager) {
        this.searchResultWidget.fillLocalPullDown(manager);
    }

    public void setFocus() {
        this.queryEditor.setFocus();
    }

    void search() {
        MacAddress macAddress;
        String macAddr = this.queryEditor.getText();
        try {
            macAddress = MacAddress.parseMacAddress((String)macAddr, (boolean)false);
        }
        catch (MacAddressFormatException e) {
            MessageDialogHelper.openError((Shell)this.searchResultWidget.getShell(), (String)i18n.tr("Error"), (String)i18n.tr("MAC address entered is incorrect. Please enter correct MAC address."));
            return;
        }
        this.startButton.setEnabled(false);
        NXCSession session = Registry.getSession();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }
}

