/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.tools.views;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.NXCSession;
import org.netxms.client.server.ServerConsoleListener;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.widgets.TextConsole;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.resources.ResourceManager;
import org.xnap.commons.i18n.I18n;

public class ServerConsole
extends View {
    private static final I18n i18n = LocalizationHelper.getI18n(ServerConsole.class);
    private NXCSession session = Registry.getSession();
    private ServerConsoleListener listener = new /* Unavailable Anonymous Inner Class!! */;
    private TextConsole console;
    private Combo commandInput;
    private TextConsole.IOConsoleOutputStream outputStream = null;
    private boolean connected = false;
    private Action actionClearOutput;
    private Action actionScrollLock;
    private Action actionCopy;
    private Action actionSave;
    private Action actionConnect;
    private Action actionDisconnect;

    public ServerConsole() {
        super(i18n.tr("Server Debug Console"), ResourceManager.getImageDescriptor((String)"icons/tool-views/server-debug-console.png"), "ServerConsole", false);
    }

    protected void postClone(View origin) {
        super.postClone(origin);
        ServerConsole view = (ServerConsole)origin;
        this.console.setText(view.console.getText());
        for (String s : view.commandInput.getItems()) {
            this.commandInput.add(s);
        }
        this.commandInput.select(this.commandInput.getItems().length - 1);
        if (view.connected) {
            this.connect();
        }
    }

    protected void postContentCreate() {
        super.postContentCreate();
        this.commandInput.add("");
        this.commandInput.select(0);
        this.outputStream.safeWrite("\r\n\r\n\u001b[34;1m*** Press ENTER to connect ***\u001b[0m\r\n");
    }

    protected void createContent(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        parent.setLayout((Layout)layout);
        this.console = new TextConsole(parent, 0);
        this.console.setLayoutData((Object)new GridData(4, 4, true, true));
        this.outputStream = this.console.newOutputStream();
        Label separator = new Label(parent, 258);
        separator.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Composite commandArea = new Composite(parent, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 8;
        commandArea.setLayout((Layout)layout);
        commandArea.setLayoutData((Object)new GridData(4, 4, true, false));
        Label label = new Label(commandArea, 0);
        label.setText(i18n.tr("Command:"));
        label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.commandInput = new Combo(commandArea, 2048);
        this.commandInput.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.commandInput.addKeyListener((KeyListener)new /* Unavailable Anonymous Inner Class!! */);
        this.createActions();
        this.setConnectionState(false);
    }

    private void createActions() {
        this.actionClearOutput = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("M1+L", (IAction)this.actionClearOutput);
        this.actionScrollLock = new /* Unavailable Anonymous Inner Class!! */;
        this.actionScrollLock.setImageDescriptor(ResourceManager.getImageDescriptor((String)"icons/scroll-lock.png"));
        this.actionScrollLock.setChecked(false);
        this.addKeyBinding("SCROLLLOCK", (IAction)this.actionScrollLock);
        this.actionCopy = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("M1+C", (IAction)this.actionCopy);
        this.actionSave = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("M1+S", (IAction)this.actionSave);
        this.actionConnect = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("ENTER", (IAction)this.actionConnect);
        this.actionDisconnect = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("M1+D", (IAction)this.actionDisconnect);
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionConnect);
        manager.add((IAction)this.actionDisconnect);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionCopy);
        manager.add((IAction)this.actionSave);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionClearOutput);
        manager.add((IAction)this.actionScrollLock);
    }

    protected void fillLocalMenu(IMenuManager manager) {
        manager.add((IAction)this.actionConnect);
        manager.add((IAction)this.actionDisconnect);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionCopy);
        manager.add((IAction)this.actionSave);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionClearOutput);
        manager.add((IAction)this.actionScrollLock);
    }

    public void dispose() {
        this.session.removeConsoleListener(this.listener);
        this.disconnect();
        super.dispose();
    }

    public void setFocus() {
        this.commandInput.setFocus();
    }

    private void connect() {
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void disconnect() {
        if (!this.connected) {
            return;
        }
        this.setConnectionState(false);
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void setConnectionState(boolean connected) {
        this.connected = connected;
        this.actionConnect.setEnabled(!connected);
        this.actionDisconnect.setEnabled(connected);
        this.commandInput.setEnabled(connected);
    }

    private void sendCommand() {
        String command = this.commandInput.getText().trim();
        if (command.isEmpty()) {
            this.outputStream.safeWrite("\r\n");
            this.commandInput.select(this.commandInput.getItems().length - 1);
            return;
        }
        String[] items = this.commandInput.getItems();
        if (items.length == 1 || items[items.length - 2].compareToIgnoreCase(command) != 0) {
            this.commandInput.add(command, items.length - 1);
        }
        this.commandInput.select(this.commandInput.getItems().length - 1);
        this.outputStream.safeWrite("\u001b[33;1;7m " + command + " \u001b[0m\r\n");
        if (this.connected) {
            new /* Unavailable Anonymous Inner Class!! */.start();
        } else {
            this.outputStream.safeWrite("\u001b[31;1mNOT CONNECTED\u001b[0m\r\n");
        }
    }
}

