/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.tools.widgets.helpers;

import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.ConnectionPointType;
import org.netxms.client.objects.Interface;
import org.netxms.client.topology.ConnectionPoint;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.tools.widgets.helpers.ConnectionPointLabelProvider;
import org.netxms.nxmc.resources.ThemeEngine;
import org.netxms.nxmc.tools.ColorConverter;
import org.netxms.nxmc.tools.ViewerElementUpdater;
import org.xnap.commons.i18n.I18n;

public class ConnectionPointLabelProvider
extends LabelProvider
implements ITableLabelProvider,
IColorProvider {
    private final I18n i18n = LocalizationHelper.getI18n(ConnectionPointLabelProvider.class);
    private static final Color COLOR_FOUND_OBJECT_DIRECT = new Color((Device)Display.getDefault(), ColorConverter.parseColorDefinition((String)"DarkGreen"));
    private static final Color COLOR_FOUND_OBJECT_INDIRECT = new Color((Device)Display.getDefault(), ColorConverter.parseColorDefinition((String)"SeaGreen"));
    private static final Color COLOR_FOUND_OBJECT_WIRELESS = new Color((Device)Display.getDefault(), ColorConverter.parseColorDefinition((String)"Teal"));
    private static final Color COLOR_FOUND_OBJECT_UNKNOWN = new Color((Device)Display.getDefault(), ColorConverter.parseColorDefinition((String)"Peru"));
    private static final Color COLOR_FOUND_MAC_DIRECT = new Color((Device)Display.getDefault(), ColorConverter.parseColorDefinition((String)"DarkBlue"));
    private static final Color COLOR_FOUND_MAC_INDIRECT = new Color((Device)Display.getDefault(), ColorConverter.parseColorDefinition((String)"DarkSlateBlue"));
    private static final Color COLOR_FOUND_MAC_WIRELESS = new Color((Device)Display.getDefault(), ColorConverter.parseColorDefinition((String)"SteelBlue"));
    private static final Color COLOR_NOT_FOUND = new Color((Device)Display.getDefault(), ColorConverter.parseColorDefinition((String)"DarkRed"));
    private static final Color COLOR_HISTORICAL = ThemeEngine.getForegroundColor((String)"List.DisabledItem");
    private Map<Long, String> cachedObjectNames = new HashMap();
    private NXCSession session = Registry.getSession();
    private TableViewer viewer;

    public ConnectionPointLabelProvider(TableViewer viewer) {
        this.viewer = viewer;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    private String getObjectName(long id) {
        if (id == 0L) {
            return "";
        }
        String name = (String)this.cachedObjectNames.get(id);
        if (name == null) {
            name = this.session.getObjectName(id);
            this.cachedObjectNames.put(id, name);
        }
        return name;
    }

    public String getColumnText(Object element, int columnIndex) {
        ConnectionPoint cp = (ConnectionPoint)element;
        switch (columnIndex) {
            case 0: {
                return Integer.toString((Integer)cp.getData() + 1);
            }
            case 1: {
                return this.getObjectName(cp.getLocalNodeId());
            }
            case 2: {
                return this.getObjectName(cp.getLocalInterfaceId());
            }
            case 3: {
                return cp.getLocalMacAddress() != null ? cp.getLocalMacAddress().toString() : "n/a";
            }
            case 4: {
                if (cp.getLocalMacAddress() == null) {
                    return "";
                }
                return this.session.getVendorByMac(cp.getLocalMacAddress(), (Runnable)new ViewerElementUpdater((ColumnViewer)this.viewer, element));
            }
            case 5: {
                InetAddress addr = cp.getLocalIpAddress();
                if (addr != null) {
                    return addr.getHostAddress();
                }
                Interface iface = (Interface)this.session.findObjectById(cp.getLocalInterfaceId(), Interface.class);
                if (iface == null) {
                    return "";
                }
                InetAddress a = iface.getFirstUnicastAddress();
                return a != null ? a.getHostAddress() : "";
            }
            case 6: {
                return cp.getNodeId() != 0L ? this.getObjectName(cp.getNodeId()) : "n/a";
            }
            case 7: {
                return cp.getInterfaceId() != 0L ? this.getObjectName(cp.getInterfaceId()) : "n/a";
            }
            case 8: {
                if (cp.getType() == null) {
                    return "n/a";
                }
                switch (1.$SwitchMap$org$netxms$client$constants$ConnectionPointType[cp.getType().ordinal()]) {
                    case 1: {
                        return this.i18n.tr("direct");
                    }
                    case 2: {
                        return this.i18n.tr("indirect");
                    }
                    case 3: {
                        return this.i18n.tr("wireless");
                    }
                }
                return this.i18n.tr("unknown");
            }
        }
        return null;
    }

    public Color getForeground(Object element) {
        ConnectionPoint cp = (ConnectionPoint)element;
        if (!cp.hasConnection()) {
            return COLOR_NOT_FOUND;
        }
        if (cp.getLocalNodeId() == 0L) {
            return cp.getType() == ConnectionPointType.DIRECT ? COLOR_FOUND_MAC_DIRECT : (cp.getType() == ConnectionPointType.WIRELESS ? COLOR_FOUND_MAC_WIRELESS : COLOR_FOUND_MAC_INDIRECT);
        }
        switch (1.$SwitchMap$org$netxms$client$constants$ConnectionPointType[cp.getType().ordinal()]) {
            case 1: {
                return COLOR_FOUND_OBJECT_DIRECT;
            }
            case 2: {
                return COLOR_FOUND_OBJECT_INDIRECT;
            }
            case 3: {
                return COLOR_FOUND_OBJECT_WIRELESS;
            }
            case 4: {
                return COLOR_FOUND_OBJECT_UNKNOWN;
            }
        }
        return null;
    }

    public Color getBackground(Object element) {
        ConnectionPoint cp = (ConnectionPoint)element;
        if (cp.isHistorical()) {
            return COLOR_HISTORICAL;
        }
        return null;
    }
}

