/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.resources;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.netxms.client.constants.ObjectStatus;
import org.netxms.client.constants.Severity;
import org.netxms.nxmc.PreferenceStore;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.resources.ThemeEngine;
import org.netxms.nxmc.tools.ColorCache;
import org.xnap.commons.i18n.I18n;

/*
 * Exception performing whole class analysis ignored.
 */
public final class StatusDisplayInfo {
    private I18n i18n = LocalizationHelper.getI18n(StatusDisplayInfo.class);
    private String[] statusText = new String[9];
    private ImageDescriptor[] statusImageDescriptors = new ImageDescriptor[9];
    private Image[] statusImages = new Image[9];
    private ImageDescriptor[] overlayImageDescriptors = new ImageDescriptor[9];
    private ColorCache colorCache;
    private Color[] statusColor = new Color[9];

    public static void init(Display display) {
        StatusDisplayInfo instance = new StatusDisplayInfo();
        instance.statusText[ObjectStatus.NORMAL.getValue()] = instance.i18n.tr("Normal");
        instance.statusText[ObjectStatus.WARNING.getValue()] = instance.i18n.tr("Warning");
        instance.statusText[ObjectStatus.MINOR.getValue()] = instance.i18n.tr("Minor");
        instance.statusText[ObjectStatus.MAJOR.getValue()] = instance.i18n.tr("Major");
        instance.statusText[ObjectStatus.CRITICAL.getValue()] = instance.i18n.tr("Critical");
        instance.statusText[ObjectStatus.UNKNOWN.getValue()] = instance.i18n.tr("Unknown");
        instance.statusText[ObjectStatus.UNMANAGED.getValue()] = instance.i18n.tr("Unmanaged");
        instance.statusText[ObjectStatus.DISABLED.getValue()] = instance.i18n.tr("Disabled");
        instance.statusText[ObjectStatus.TESTING.getValue()] = instance.i18n.tr("Testing");
        instance.statusImageDescriptors[ObjectStatus.NORMAL.getValue()] = ResourceManager.getImageDescriptor((String)"icons/status/normal.png");
        instance.statusImageDescriptors[ObjectStatus.WARNING.getValue()] = ResourceManager.getImageDescriptor((String)"icons/status/warning.png");
        instance.statusImageDescriptors[ObjectStatus.MINOR.getValue()] = ResourceManager.getImageDescriptor((String)"icons/status/minor.png");
        instance.statusImageDescriptors[ObjectStatus.MAJOR.getValue()] = ResourceManager.getImageDescriptor((String)"icons/status/major.png");
        instance.statusImageDescriptors[ObjectStatus.CRITICAL.getValue()] = ResourceManager.getImageDescriptor((String)"icons/status/critical.png");
        instance.statusImageDescriptors[ObjectStatus.UNKNOWN.getValue()] = ResourceManager.getImageDescriptor((String)"icons/status/unknown.png");
        instance.statusImageDescriptors[ObjectStatus.UNMANAGED.getValue()] = ResourceManager.getImageDescriptor((String)"icons/status/unmanaged.png");
        instance.statusImageDescriptors[ObjectStatus.DISABLED.getValue()] = ResourceManager.getImageDescriptor((String)"icons/status/disabled.png");
        instance.statusImageDescriptors[ObjectStatus.TESTING.getValue()] = ResourceManager.getImageDescriptor((String)"icons/status/testing.png");
        for (int i = 0; i < instance.statusImageDescriptors.length; ++i) {
            instance.statusImages[i] = instance.statusImageDescriptors[i].createImage((Device)display);
        }
        instance.overlayImageDescriptors[ObjectStatus.WARNING.getValue()] = ResourceManager.getImageDescriptor((String)"icons/status/overlay/warning.png");
        instance.overlayImageDescriptors[ObjectStatus.MINOR.getValue()] = ResourceManager.getImageDescriptor((String)"icons/status/overlay/minor.png");
        instance.overlayImageDescriptors[ObjectStatus.MAJOR.getValue()] = ResourceManager.getImageDescriptor((String)"icons/status/overlay/major.png");
        instance.overlayImageDescriptors[ObjectStatus.CRITICAL.getValue()] = ResourceManager.getImageDescriptor((String)"icons/status/overlay/critical.png");
        instance.overlayImageDescriptors[ObjectStatus.UNKNOWN.getValue()] = ResourceManager.getImageDescriptor((String)"icons/status/overlay/unknown.gif");
        instance.overlayImageDescriptors[ObjectStatus.UNMANAGED.getValue()] = ResourceManager.getImageDescriptor((String)"icons/status/overlay/unmanaged.gif");
        instance.overlayImageDescriptors[ObjectStatus.DISABLED.getValue()] = ResourceManager.getImageDescriptor((String)"icons/status/overlay/disabled.gif");
        instance.overlayImageDescriptors[ObjectStatus.TESTING.getValue()] = ResourceManager.getImageDescriptor((String)"icons/status/overlay/testing.png");
        instance.colorCache = new ColorCache();
        instance.updateStatusColors();
        display.disposeExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        RWT.getUISession().setAttribute("netxms.statusDisplayInfo", (Object)instance);
    }

    private static StatusDisplayInfo getInstance() {
        return (StatusDisplayInfo)RWT.getUISession().getAttribute("netxms.statusDisplayInfo");
    }

    private void updateStatusColors() {
        PreferenceStore ps = PreferenceStore.getInstance();
        this.statusColor[0] = this.colorCache.create(ps.getAsColor("Status.Colors.Normal", ThemeEngine.getForegroundColorDefinition((String)"Status.Normal")));
        this.statusColor[1] = this.colorCache.create(ps.getAsColor("Status.Colors.Warning", ThemeEngine.getForegroundColorDefinition((String)"Status.Warning")));
        this.statusColor[2] = this.colorCache.create(ps.getAsColor("Status.Colors.Minor", ThemeEngine.getForegroundColorDefinition((String)"Status.Minor")));
        this.statusColor[3] = this.colorCache.create(ps.getAsColor("Status.Colors.Major", ThemeEngine.getForegroundColorDefinition((String)"Status.Major")));
        this.statusColor[4] = this.colorCache.create(ps.getAsColor("Status.Colors.Critical", ThemeEngine.getForegroundColorDefinition((String)"Status.Critical")));
        this.statusColor[5] = this.colorCache.create(ps.getAsColor("Status.Colors.Unknown", ThemeEngine.getForegroundColorDefinition((String)"Status.Unknown")));
        this.statusColor[6] = this.colorCache.create(ps.getAsColor("Status.Colors.Unmanaged", ThemeEngine.getForegroundColorDefinition((String)"Status.Unmanaged")));
        this.statusColor[7] = this.colorCache.create(ps.getAsColor("Status.Colors.Disabled", ThemeEngine.getForegroundColorDefinition((String)"Status.Disabled")));
        this.statusColor[8] = this.colorCache.create(ps.getAsColor("Status.Colors.Testing", ThemeEngine.getForegroundColorDefinition((String)"Status.Testing")));
    }

    public static String getStatusText(ObjectStatus status) {
        return StatusDisplayInfo.getInstance().statusText[status.getValue()];
    }

    public static String getStatusText(Severity severity) {
        return StatusDisplayInfo.getInstance().statusText[severity.getValue()];
    }

    public static String getStatusText(int code) {
        return StatusDisplayInfo.getStatusText((ObjectStatus)ObjectStatus.getByValue((int)code));
    }

    public static ImageDescriptor getStatusImageDescriptor(ObjectStatus status) {
        return StatusDisplayInfo.getInstance().statusImageDescriptors[status.getValue()];
    }

    public static ImageDescriptor getStatusImageDescriptor(Severity severity) {
        return StatusDisplayInfo.getInstance().statusImageDescriptors[severity.getValue()];
    }

    public static ImageDescriptor getStatusImageDescriptor(int code) {
        return StatusDisplayInfo.getStatusImageDescriptor((ObjectStatus)ObjectStatus.getByValue((int)code));
    }

    public static Image getStatusImage(ObjectStatus status) {
        return StatusDisplayInfo.getInstance().statusImages[status.getValue()];
    }

    public static Image getStatusImage(int code) {
        return StatusDisplayInfo.getStatusImage((ObjectStatus)ObjectStatus.getByValue((int)code));
    }

    public static Image getStatusImage(Severity severity) {
        return StatusDisplayInfo.getInstance().statusImages[severity.getValue()];
    }

    public static ImageDescriptor getStatusOverlayImageDescriptor(ObjectStatus status) {
        return StatusDisplayInfo.getInstance().overlayImageDescriptors[status.getValue()];
    }

    public static ImageDescriptor getStatusOverlayImageDescriptor(Severity severity) {
        return StatusDisplayInfo.getInstance().overlayImageDescriptors[severity.getValue()];
    }

    public static ImageDescriptor getStatusOverlayImageDescriptor(int code) {
        return StatusDisplayInfo.getStatusOverlayImageDescriptor((ObjectStatus)ObjectStatus.getByValue((int)code));
    }

    public static Color getStatusColor(ObjectStatus status) {
        return StatusDisplayInfo.getInstance().statusColor[status.getValue()];
    }

    public static Color getStatusColor(Severity severity) {
        return StatusDisplayInfo.getInstance().statusColor[severity.getValue()];
    }

    public static Color getStatusColor(int code) {
        return StatusDisplayInfo.getStatusColor((ObjectStatus)ObjectStatus.getByValue((int)code));
    }
}

