/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.resources;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Listener;
import org.netxms.nxmc.PreferenceStore;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.resources.DefaultDarkTheme;
import org.netxms.nxmc.resources.DefaultLightTheme;
import org.netxms.nxmc.resources.Theme;
import org.netxms.nxmc.resources.ThemeElement;
import org.netxms.nxmc.tools.ColorCache;
import org.netxms.nxmc.tools.ColorConverter;
import org.netxms.nxmc.tools.FontCache;
import org.netxms.nxmc.tools.WidgetHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ThemeEngine {
    private static final Logger logger = LoggerFactory.getLogger(ThemeEngine.class);
    private static final Map<Display, ThemeEngine> instances = new HashMap();
    private ColorCache colors = new ColorCache();
    private FontCache fonts = new FontCache();
    private Map<String, ThemeElement> elements = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ThemeEngine getInstance(Display display) {
        ThemeEngine instance;
        Map map = instances;
        synchronized (map) {
            instance = (ThemeEngine)instances.get(display);
            if (instance == null) {
                instance = new ThemeEngine(display);
                instances.put(display, instance);
            }
        }
        return instance;
    }

    private ThemeEngine(Display display) {
        display.addListener(12, (Listener)new /* Unavailable Anonymous Inner Class!! */);
        this.reload(display);
    }

    public static RGB getBackgroundColorDefinition(String path) {
        ThemeEngine instance = ThemeEngine.getInstance((Display)Display.getCurrent());
        for (ThemeElement e : instance.getElementChain(path)) {
            if (e.background == null) continue;
            return e.background;
        }
        return Display.getCurrent().getSystemColor(22).getRGB();
    }

    public static String getBackgroundColorDefinitionAsText(String path) {
        RGB rgb = ThemeEngine.getBackgroundColorDefinition((String)path);
        return rgb.red + "," + rgb.green + "," + rgb.blue;
    }

    public static Color getBackgroundColor(String path) {
        return ThemeEngine.getInstance((Display)Display.getCurrent()).colors.create(ThemeEngine.getBackgroundColorDefinition((String)path));
    }

    public static RGB getForegroundColorDefinition(String path) {
        ThemeEngine instance = ThemeEngine.getInstance((Display)Display.getCurrent());
        for (ThemeElement e : instance.getElementChain(path)) {
            if (e.foreground == null) continue;
            return e.foreground;
        }
        return Display.getCurrent().getSystemColor(21).getRGB();
    }

    public static String getForegroundColorDefinitionAsText(String path) {
        RGB rgb = ThemeEngine.getForegroundColorDefinition((String)path);
        return rgb.red + "," + rgb.green + "," + rgb.blue;
    }

    public static Color getForegroundColor(String path) {
        return ThemeEngine.getInstance((Display)Display.getCurrent()).colors.create(ThemeEngine.getForegroundColorDefinition((String)path));
    }

    public static Font getFont(String path) {
        ThemeEngine instance = ThemeEngine.getInstance((Display)Display.getCurrent());
        for (ThemeElement e : instance.getElementChain(path)) {
            if (e.fontName == null) continue;
            return instance.fonts.create(e.fontName, e.fontHeight);
        }
        return Display.getCurrent().getSystemFont();
    }

    public static File getThemeStorageDirectory() {
        return new File(Registry.getStateDir(), "themes");
    }

    public static void saveTheme(Theme theme) throws Exception {
        File storage = ThemeEngine.getThemeStorageDirectory();
        if (!storage.exists()) {
            storage.mkdirs();
        }
        File file = new File(storage, theme.getName() + ".xml");
        theme.save(file);
    }

    public static boolean deleteTheme(String name) {
        return new File(ThemeEngine.getThemeStorageDirectory(), name + ".xml").delete();
    }

    public static void reload() {
        Display display = Display.getCurrent();
        ThemeEngine.getInstance((Display)display).reload(display);
    }

    private void reload(Display display) {
        PreferenceStore ps = PreferenceStore.getInstance((Display)display);
        String currentTheme = ps.getString("CurrentTheme");
        if (currentTheme == null || currentTheme.isEmpty() || currentTheme.equalsIgnoreCase("[automatic]")) {
            this.loadDefaultTheme(display);
        } else if (currentTheme.equalsIgnoreCase("Light [built-in]")) {
            this.loadTheme((Theme)new DefaultLightTheme());
        } else if (currentTheme.equalsIgnoreCase("Dark [built-in]")) {
            this.loadTheme((Theme)new DefaultDarkTheme());
        } else {
            boolean loaded = false;
            File base = ThemeEngine.getThemeStorageDirectory();
            if (base.isDirectory()) {
                for (File f : base.listFiles((FilenameFilter)new /* Unavailable Anonymous Inner Class!! */)) {
                    logger.info("Loading theme file " + f.getAbsolutePath());
                    try {
                        Theme t = Theme.load((File)f);
                        if (!t.getName().equalsIgnoreCase(currentTheme)) continue;
                        logger.info("Applying theme " + t.getName());
                        boolean darkOSTheme = ColorConverter.isDarkColor((RGB)display.getSystemColor(22).getRGB());
                        t.setMissingElements((Theme)(darkOSTheme ? new DefaultDarkTheme() : new DefaultLightTheme()));
                        this.loadTheme(t);
                        loaded = true;
                        break;
                    }
                    catch (Exception e) {
                        logger.error("Error loading theme file " + f.getAbsolutePath(), (Throwable)e);
                    }
                }
            }
            if (!loaded) {
                this.loadDefaultTheme(display);
            }
        }
    }

    private List<ThemeElement> getElementChain(String path) {
        ArrayList<ThemeElement> chain = new ArrayList<ThemeElement>(16);
        while (!path.isEmpty()) {
            int index;
            ThemeElement e = (ThemeElement)this.elements.get(path);
            if (e != null) {
                chain.add(e);
            }
            path = (index = path.lastIndexOf(46)) != -1 ? path.substring(0, index) : "";
        }
        chain.add((ThemeElement)this.elements.get("."));
        return chain;
    }

    private void loadTheme(Theme theme) {
        this.elements.clear();
        this.elements.putAll(theme.elements);
    }

    private void loadDefaultTheme(Display display) {
        this.loadTheme((Theme)(WidgetHelper.isSystemDarkTheme((Display)display) ? new DefaultDarkTheme() : new DefaultLightTheme()));
    }
}

