/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.alarmviewer.widgets.helpers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.netxms.client.events.AlarmHandle;

public class AlarmTreeContentProvider
implements ITreeContentProvider {
    private Map<Long, AlarmHandle> alarms = new HashMap<Long, AlarmHandle>();

    public Object[] getElements(Object inputElement) {
        this.alarms.clear();
        for (AlarmHandle a : ((Map)inputElement).values()) {
            this.alarms.put(a.id, a);
        }
        ArrayList<AlarmHandle> rootElements = new ArrayList<AlarmHandle>(this.alarms.size());
        for (AlarmHandle a : ((Map)inputElement).values()) {
            if (a.alarm.getParentId() != 0L && this.alarms.containsKey(a.alarm.getParentId())) continue;
            rootElements.add(a);
        }
        return rootElements.toArray();
    }

    public Object[] getChildren(Object parentElement) {
        ArrayList<AlarmHandle> children = new ArrayList<AlarmHandle>();
        long[] lArray = ((AlarmHandle)parentElement).alarm.getSubordinateAlarms();
        int n = lArray.length;
        int n2 = 0;
        while (n2 < n) {
            long id = lArray[n2];
            AlarmHandle a = this.alarms.get(id);
            if (a != null) {
                children.add(a);
            }
            ++n2;
        }
        return children.toArray();
    }

    public Object getParent(Object element) {
        return ((AlarmHandle)element).alarm.getParentId() != 0L ? this.alarms.get(((AlarmHandle)element).alarm.getParentId()) : null;
    }

    public boolean hasChildren(Object element) {
        return ((AlarmHandle)element).alarm.hasSubordinatedAlarms();
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

