/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.reporter.widgets;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.reporting.ReportParameter;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.objectbrowser.dialogs.ObjectSelectionDialog;
import org.netxms.ui.eclipse.reporter.Messages;
import org.netxms.ui.eclipse.reporter.widgets.FieldEditor;

public class ObjectListFieldEditor
extends FieldEditor {
    private TableViewer viewer;
    private Map<Long, AbstractObject> objects = new HashMap<Long, AbstractObject>();

    public ObjectListFieldEditor(ReportParameter parameter, Composite parent) {
        super(parameter, parent);
    }

    @Override
    protected Control createContent(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        content.setLayout((Layout)layout);
        this.viewer = new TableViewer(content, 67586);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.viewer.setInput((Object)new Object[0]);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.verticalSpan = 2;
        this.viewer.getControl().setLayoutData((Object)gd);
        ImageHyperlink link = new ImageHyperlink(content, 0);
        link.setImage(SharedIcons.IMG_ADD_OBJECT);
        Messages.get();
        link.setText(Messages.ObjectListFieldEditor_Add);
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                ObjectListFieldEditor.this.addObjects();
            }
        });
        gd = new GridData();
        gd.verticalAlignment = 128;
        link.setLayoutData((Object)gd);
        link = new ImageHyperlink(content, 0);
        link.setImage(SharedIcons.IMG_DELETE_OBJECT);
        Messages.get();
        link.setText(Messages.ObjectListFieldEditor_Delete);
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                ObjectListFieldEditor.this.deleteObjects();
            }
        });
        gd = new GridData();
        gd.verticalAlignment = 128;
        link.setLayoutData((Object)gd);
        return content;
    }

    private void addObjects() {
        ObjectSelectionDialog dlg = new ObjectSelectionDialog(this.getShell());
        if (dlg.open() == 0) {
            for (AbstractObject o : dlg.getSelectedObjects()) {
                this.objects.put(o.getObjectId(), o);
            }
            this.viewer.setInput((Object)this.objects.values().toArray());
        }
    }

    private void deleteObjects() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        for (Object o : selection.toList()) {
            this.objects.remove(((AbstractObject)o).getObjectId());
        }
        this.viewer.setInput((Object)this.objects.values().toArray());
    }

    @Override
    public String getValue() {
        if (this.objects.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (AbstractObject o : this.objects.values()) {
            sb.append(o.getObjectId());
            sb.append(',');
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }
}

