/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.widgets.internal;

import java.util.Map;
import java.util.Set;
import org.netxms.client.xml.XMLTools;
import org.netxms.ui.eclipse.dashboard.dialogs.helpers.ObjectIdMatchingData;
import org.netxms.ui.eclipse.dashboard.widgets.internal.DashboardElementConfig;
import org.simpleframework.xml.Element;

public class EmbeddedDashboardConfig
extends DashboardElementConfig {
    @Element(required=false)
    private long objectId = 0L;
    @Element(required=false)
    private long[] dashboardObjects = new long[0];
    @Element(required=false)
    private int displayInterval = 60;

    public static EmbeddedDashboardConfig createFromXml(String xml) throws Exception {
        EmbeddedDashboardConfig config = (EmbeddedDashboardConfig)XMLTools.createFromXml(EmbeddedDashboardConfig.class, (String)xml);
        if (config.objectId != 0L && config.dashboardObjects.length == 0) {
            config.dashboardObjects = new long[1];
            config.dashboardObjects[0] = config.objectId;
            config.objectId = 0L;
        }
        return config;
    }

    @Override
    public Set<Long> getObjects() {
        Set<Long> objects = super.getObjects();
        objects.add(this.objectId);
        long[] lArray = this.dashboardObjects;
        int n = this.dashboardObjects.length;
        int n2 = 0;
        while (n2 < n) {
            long id = lArray[n2];
            objects.add(id);
            ++n2;
        }
        return objects;
    }

    @Override
    public void remapObjects(Map<Long, ObjectIdMatchingData> remapData) {
        super.remapObjects(remapData);
        ObjectIdMatchingData md = remapData.get(this.objectId);
        if (md != null) {
            this.objectId = md.dstId;
        }
        int i = 0;
        while (i < this.dashboardObjects.length) {
            md = remapData.get(this.dashboardObjects[i]);
            if (md != null) {
                this.dashboardObjects[i] = md.dstId;
            }
            ++i;
        }
    }

    public long[] getDashboardObjects() {
        return this.dashboardObjects;
    }

    public void setDashboardObjects(long[] dashboardObjects) {
        this.dashboardObjects = dashboardObjects;
    }

    public int getDisplayInterval() {
        return this.displayInterval;
    }

    public void setDisplayInterval(int displayInterval) {
        this.displayInterval = displayInterval;
    }
}

