/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.widgets.internal;

import java.util.Map;
import java.util.Set;
import org.netxms.client.objects.interfaces.NodeItemPair;
import org.netxms.ui.eclipse.dashboard.dialogs.helpers.ObjectIdMatchingData;
import org.netxms.ui.eclipse.dashboard.widgets.internal.DashboardElementConfig;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementArray;
import org.simpleframework.xml.Root;

public class StatusIndicatorConfig
extends DashboardElementConfig {
    public static final int SHAPE_CIRCLE = 0;
    public static final int SHAPE_RECTANGLE = 1;
    public static final int SHAPE_ROUNDED_RECTANGLE = 2;
    public static final int LABEL_NONE = 0;
    public static final int LABEL_INSIDE = 1;
    public static final int LABEL_OUTSIDE = 2;
    public static final int ELEMENT_TYPE_OBJECT = 0;
    public static final int ELEMENT_TYPE_DCI = 1;
    public static final int ELEMENT_TYPE_DCI_TEMPLATE = 2;
    public static final int ELEMENT_TYPE_SCRIPT = 3;
    @ElementArray(required=false)
    private StatusIndicatorElementConfig[] elements = new StatusIndicatorElementConfig[0];
    @Element(required=false)
    private long objectId = 0L;
    @Element(required=false)
    private String script = null;
    @Element(required=false)
    private long scriptContextObjectId = 0L;
    @Element(required=false)
    private int numColumns = 1;
    @Element(required=false)
    private boolean fullColorRange = false;
    @Element(required=false)
    private int shape = 0;
    @Element(required=false)
    private int labelType = 0;

    @Override
    public Set<Long> getObjects() {
        Set<Long> objects = super.getObjects();
        objects.add(this.objectId);
        return objects;
    }

    @Override
    public void remapObjects(Map<Long, ObjectIdMatchingData> remapData) {
        super.remapObjects(remapData);
        ObjectIdMatchingData md = remapData.get(this.objectId);
        if (md != null) {
            this.objectId = md.dstId;
        }
    }

    public boolean isFullColorRange() {
        return this.fullColorRange;
    }

    public void setFullColorRange(boolean fullColorRange) {
        this.fullColorRange = fullColorRange;
    }

    public StatusIndicatorElementConfig[] getElements() {
        if (this.elements.length == 0 && this.objectId != 0L) {
            StatusIndicatorElementConfig element = new StatusIndicatorElementConfig();
            element.setType(0);
            element.setObjectId(this.objectId);
            this.elements = new StatusIndicatorElementConfig[]{element};
        }
        return this.elements;
    }

    public void setElements(StatusIndicatorElementConfig[] elements) {
        this.elements = elements;
    }

    public int getNumColumns() {
        return this.numColumns;
    }

    public void setNumColumns(int numColumns) {
        this.numColumns = numColumns;
    }

    public int getShape() {
        return this.shape;
    }

    public void setShape(int shape) {
        this.shape = shape;
    }

    public int getLabelType() {
        return this.labelType;
    }

    public void setLabelType(int labelType) {
        this.labelType = labelType;
    }

    public String getScript() {
        return this.script;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public long getScriptContextObjectId() {
        return this.scriptContextObjectId;
    }

    public void setScriptContextObjectId(long scriptContextObjectId) {
        this.scriptContextObjectId = scriptContextObjectId;
    }

    @Root(name="element", strict=false)
    public static class StatusIndicatorElementConfig
    implements NodeItemPair {
        @Element
        private int type;
        @Element(required=false)
        private String label;
        @Element(required=false)
        private long objectId;
        @Element(required=false)
        private long dciId;
        @Element(required=false)
        private String dciName;
        @Element(required=false)
        private String dciDescription;
        @Element(required=false)
        private String tag;
        @Element(required=false)
        private long drilldownObjectId;

        public StatusIndicatorElementConfig() {
            this.type = 0;
            this.label = null;
            this.objectId = 0L;
            this.dciId = 0L;
            this.dciName = null;
            this.dciDescription = null;
            this.tag = null;
            this.drilldownObjectId = 0L;
        }

        public StatusIndicatorElementConfig(StatusIndicatorElementConfig src) {
            this.type = src.type;
            this.label = src.label;
            this.objectId = src.objectId;
            this.dciId = src.dciId;
            this.dciName = src.dciName;
            this.dciDescription = src.dciDescription;
            this.tag = src.tag;
            this.drilldownObjectId = src.drilldownObjectId;
        }

        public int getType() {
            return this.type;
        }

        public void setType(int type) {
            this.type = type;
        }

        public String getLabel() {
            if (this.label != null && !this.label.isEmpty()) {
                return this.label;
            }
            if (this.type == 3) {
                return this.tag;
            }
            if (this.type == 2) {
                if (this.dciDescription != null && !this.dciDescription.isEmpty()) {
                    return this.dciDescription;
                }
                if (this.dciName != null && !this.dciName.isEmpty()) {
                    return this.dciName;
                }
            }
            return "";
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public long getObjectId() {
            return this.objectId;
        }

        public void setObjectId(long objectId) {
            this.objectId = objectId;
        }

        public long getDciId() {
            return this.dciId;
        }

        public void setDciId(long dciId) {
            this.dciId = dciId;
        }

        public String getDciName() {
            return this.dciName != null ? this.dciName : "";
        }

        public void setDciName(String dciName) {
            this.dciName = dciName;
        }

        public String getDciDescription() {
            return this.dciDescription != null ? this.dciDescription : "";
        }

        public void setDciDescription(String dciDescription) {
            this.dciDescription = dciDescription;
        }

        public String getTag() {
            return this.tag;
        }

        public void setTag(String tag) {
            this.tag = tag;
        }

        public long getDrilldownObjectId() {
            return this.drilldownObjectId;
        }

        public void setDrilldownObjectId(long drilldownObjectId) {
            this.drilldownObjectId = drilldownObjectId;
        }

        public long getNodeId() {
            return this.objectId;
        }
    }
}

