/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.console.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class KeyValuePairEditDialog
extends Dialog {
    private LabeledText textName;
    private LabeledText textValue;
    private String pStorageKey;
    private String pStorageValue;
    private String label;
    private boolean showValue;
    private boolean isNew;

    public KeyValuePairEditDialog(Shell parentShell, String key, String value, boolean showValue, boolean isNew, String label) {
        super(parentShell);
        this.pStorageKey = key;
        this.pStorageValue = value;
        this.showValue = showValue;
        this.isNew = isNew;
        this.label = label;
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.verticalSpacing = 5;
        dialogArea.setLayout((Layout)layout);
        this.textName = new LabeledText(dialogArea, 0);
        this.textName.setLabel(this.label);
        this.textName.getTextControl().setTextLimit(256);
        if (this.pStorageKey != null) {
            this.textName.setText(this.pStorageKey);
        }
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 300;
        this.textName.setLayoutData(gd);
        if (this.showValue && !this.isNew) {
            this.textName.setEditable(false);
        }
        if (this.showValue) {
            this.textValue = new LabeledText(dialogArea, 0);
            this.textValue.setLabel("Value");
            if (this.pStorageValue != null) {
                this.textValue.setText(this.pStorageValue);
            }
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            this.textValue.setLayoutData(gd);
            if (this.pStorageKey != null) {
                this.textValue.setFocus();
            }
        }
        return dialogArea;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.isNew ? "Create Value" : "Change Value");
    }

    public String getAtributeName() {
        return this.pStorageKey;
    }

    public String getAttributeValue() {
        return this.pStorageValue;
    }

    protected void okPressed() {
        this.pStorageKey = this.textName.getText();
        if (this.showValue) {
            this.pStorageValue = this.textValue.getText();
        }
        super.okPressed();
    }
}

