/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.datacollection;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.netxms.client.TimePeriod;
import org.netxms.client.constants.TimeFrameType;
import org.netxms.client.constants.TimeUnit;
import org.netxms.client.datacollection.ChartConfigurationChangeListener;
import org.netxms.client.xml.XMLTools;
import org.netxms.client.xml.XmlDateConverter;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.Serializer;
import org.simpleframework.xml.convert.Convert;

@Root(name="chart", strict=false)
public class ChartConfiguration {
    public static final int MAX_GRAPH_ITEM_COUNT = 16;
    public static final int POSITION_LEFT = 1;
    public static final int POSITION_RIGHT = 2;
    public static final int POSITION_TOP = 4;
    public static final int POSITION_BOTTOM = 8;
    public static final int GAUGE_COLOR_MODE_ZONE = 0;
    public static final int GAUGE_COLOR_MODE_CUSTOM = 1;
    public static final int GAUGE_COLOR_MODE_THRESHOLD = 2;
    @Element(required=false)
    protected String title = "";
    @Element(required=false)
    protected int legendPosition = 8;
    @Element(required=false)
    protected boolean showLegend = true;
    @Element(required=false)
    protected boolean extendedLegend = true;
    @Element(required=false)
    protected boolean showTitle = false;
    @Element(required=false)
    protected boolean showGrid = true;
    @Element(required=false)
    protected boolean showLabels = true;
    @Element(required=false)
    protected boolean showHostNames = false;
    @Element(required=false)
    protected boolean autoRefresh = true;
    @Element(required=false)
    protected boolean logScale = false;
    @Element(required=false)
    protected boolean stacked = false;
    @Element(required=false)
    protected boolean transposed = false;
    @Element(required=false)
    protected boolean translucent = false;
    @Element(required=false)
    protected boolean doughnutRendering = true;
    @Element(required=false)
    protected boolean showTotal = false;
    @Element(required=false)
    protected boolean area = false;
    @Element(required=false)
    protected int lineWidth = 2;
    @Element(required=false)
    protected boolean autoScale = true;
    @Element(required=false)
    protected double minYScaleValue = 0.0;
    @Element(required=false)
    protected double maxYScaleValue = 100.0;
    @Element(required=false)
    protected int refreshRate = 30;
    @Element(required=false)
    protected TimePeriod timePeriod = new TimePeriod();
    @Element(required=false)
    protected Integer timeUnit = null;
    @Element(required=false)
    protected Integer timeRange = null;
    @Element(required=false)
    protected Integer timeFrameType = null;
    @Element(required=false)
    @Convert(value=XmlDateConverter.class)
    protected Date timeFrom = null;
    @Element(required=false)
    @Convert(value=XmlDateConverter.class)
    protected Date timeTo = null;
    @Element(required=false)
    protected boolean modifyYBase = false;
    @Element(required=false)
    protected boolean useMultipliers = true;
    @Element(required=false)
    protected double rotation = 0.0;
    @Element(required=false)
    protected boolean zoomEnabled = false;
    @Element(required=false)
    private boolean labelsInside = false;
    @Element(required=false)
    private double leftYellowZone = 0.0;
    @Element(required=false)
    private double leftRedZone = 0.0;
    @Element(required=false)
    private double rightYellowZone = 70.0;
    @Element(required=false)
    private double rightRedZone = 90.0;
    @Element(required=false)
    private boolean elementBordersVisible = false;
    @Element(required=false)
    private int gaugeColorMode = 0;
    @Element(required=false)
    private String fontName = "";
    @Element(required=false)
    private int fontSize = 0;
    @Element(required=false)
    private int expectedTextWidth = 0;
    private Set<ChartConfigurationChangeListener> changeListeners = new HashSet<ChartConfigurationChangeListener>(0);

    public static ChartConfiguration createFromXml(String xml) throws Exception {
        ChartConfiguration config = XMLTools.createFromXml(ChartConfiguration.class, xml);
        if (config.timeFrameType != null) {
            config.timePeriod = new TimePeriod(TimeFrameType.getByValue(config.timeFrameType), config.timeRange != null ? config.timeRange : 1, config.timeUnit != null ? TimeUnit.getByValue(config.timeUnit) : TimeUnit.HOUR, config.timeFrom, config.timeTo);
            config.timeFrameType = null;
            config.timeRange = null;
            config.timeUnit = null;
            config.timeFrom = null;
            config.timeTo = null;
        }
        return config;
    }

    public ChartConfiguration() {
    }

    public ChartConfiguration(ChartConfiguration src) {
        this.title = src.title;
        this.legendPosition = src.legendPosition;
        this.showLegend = src.showLegend;
        this.extendedLegend = src.extendedLegend;
        this.showTitle = src.showTitle;
        this.showLabels = src.showLabels;
        this.showGrid = src.showGrid;
        this.showHostNames = src.showHostNames;
        this.autoRefresh = src.autoRefresh;
        this.logScale = src.logScale;
        this.stacked = src.stacked;
        this.transposed = src.transposed;
        this.translucent = src.translucent;
        this.doughnutRendering = src.doughnutRendering;
        this.showTotal = src.showTotal;
        this.area = src.area;
        this.lineWidth = src.lineWidth;
        this.autoScale = src.autoScale;
        this.minYScaleValue = src.minYScaleValue;
        this.maxYScaleValue = src.maxYScaleValue;
        this.refreshRate = src.refreshRate;
        this.timePeriod = src.timePeriod;
        this.modifyYBase = src.modifyYBase;
        this.useMultipliers = src.useMultipliers;
        this.rotation = src.rotation;
        this.zoomEnabled = src.zoomEnabled;
        this.labelsInside = src.labelsInside;
        this.leftYellowZone = src.leftYellowZone;
        this.leftRedZone = src.leftRedZone;
        this.rightYellowZone = src.rightYellowZone;
        this.rightRedZone = src.rightRedZone;
        this.elementBordersVisible = src.elementBordersVisible;
        this.gaugeColorMode = src.gaugeColorMode;
        this.fontName = src.fontName;
        this.fontSize = src.fontSize;
        this.expectedTextWidth = src.expectedTextWidth;
    }

    public String createXml() throws Exception {
        Serializer serializer = XMLTools.createSerializer();
        StringWriter writer = new StringWriter();
        serializer.write((Object)this, (Writer)writer);
        return ((Object)writer).toString();
    }

    public long getTimeRangeMillis() {
        switch (this.timePeriod.getTimeUnit()) {
            case MINUTE: {
                return (long)this.timePeriod.getTimeRange() * 60L * 1000L;
            }
            case HOUR: {
                return (long)this.timePeriod.getTimeRange() * 60L * 60L * 1000L;
            }
            case DAY: {
                return (long)this.timePeriod.getTimeRange() * 24L * 60L * 60L * 1000L;
            }
        }
        return 0L;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public int getLegendPosition() {
        return this.legendPosition;
    }

    public void setLegendPosition(int legendPosition) {
        this.legendPosition = legendPosition;
    }

    public boolean isLegendVisible() {
        return this.showLegend;
    }

    public void setLegendVisible(boolean visible) {
        this.showLegend = visible;
    }

    public boolean areLabelsVisible() {
        return this.showLabels;
    }

    public void setLabelsVisible(boolean visible) {
        this.showLabels = visible;
    }

    public int getRefreshRate() {
        return this.refreshRate;
    }

    public void setRefreshRate(int refreshRate) {
        this.refreshRate = refreshRate;
    }

    public boolean isTitleVisible() {
        return this.showTitle;
    }

    public void setTitleVisible(boolean visible) {
        this.showTitle = visible;
    }

    public boolean isShowHostNames() {
        return this.showHostNames;
    }

    public void setShowHostNames(boolean showHostNames) {
        this.showHostNames = showHostNames;
    }

    public boolean isAutoRefresh() {
        return this.autoRefresh;
    }

    public void setAutoRefresh(boolean autoRefresh) {
        this.autoRefresh = autoRefresh;
    }

    public boolean isLogScale() {
        return this.logScale;
    }

    public void setLogScale(boolean logScale) {
        this.logScale = logScale;
    }

    public boolean isGridVisible() {
        return this.showGrid;
    }

    public void setGridVisible(boolean visible) {
        this.showGrid = visible;
    }

    public boolean isStacked() {
        return this.stacked;
    }

    public void setStacked(boolean stacked) {
        this.stacked = stacked;
    }

    public boolean isTransposed() {
        return this.transposed;
    }

    public void setTransposed(boolean transposed) {
        this.transposed = transposed;
    }

    public boolean isTranslucent() {
        return this.translucent;
    }

    public void setTranslucent(boolean translucent) {
        this.translucent = translucent;
    }

    public boolean isDoughnutRendering() {
        return this.doughnutRendering;
    }

    public void setDoughnutRendering(boolean doughnutRendering) {
        this.doughnutRendering = doughnutRendering;
    }

    public boolean isShowTotal() {
        return this.showTotal;
    }

    public void setShowTotal(boolean showTotal) {
        this.showTotal = showTotal;
    }

    public boolean isExtendedLegend() {
        return this.extendedLegend;
    }

    public void setExtendedLegend(boolean extendedLegend) {
        this.extendedLegend = extendedLegend;
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(int lineWidth) {
        this.lineWidth = lineWidth;
    }

    public boolean isAutoScale() {
        return this.autoScale;
    }

    public void setAutoScale(boolean autoScale) {
        this.autoScale = autoScale;
    }

    public boolean isArea() {
        return this.area;
    }

    public void setArea(boolean area) {
        this.area = area;
    }

    public double getMinYScaleValue() {
        return this.minYScaleValue;
    }

    public void setMinYScaleValue(double minYScaleValue) {
        this.minYScaleValue = minYScaleValue;
    }

    public double getMaxYScaleValue() {
        return this.maxYScaleValue;
    }

    public void setMaxYScaleValue(double maxYScaleValue) {
        this.maxYScaleValue = maxYScaleValue;
    }

    public TimePeriod getTimePeriod() {
        return this.timePeriod;
    }

    public void setTimePeriod(TimePeriod timePeriod) {
        this.timePeriod = timePeriod;
    }

    public Date getTimeFrom() {
        return this.timePeriod.getTimeFrom();
    }

    public void setTimeFrom(Date timeFrom) {
        this.timePeriod.setTimeFrom(timeFrom);
    }

    public Date getTimeTo() {
        return this.timePeriod.getTimeTo();
    }

    public void setTimeTo(Date timeTo) {
        this.timePeriod.setTimeTo(timeTo);
    }

    public void addChangeListener(ChartConfigurationChangeListener listener) {
        this.changeListeners.add(listener);
    }

    public void removeChangeListener(ChartConfigurationChangeListener listener) {
        this.changeListeners.remove(listener);
    }

    public void fireChangeNotification() {
        for (ChartConfigurationChangeListener l : this.changeListeners) {
            l.onChartConfigurationChange(this);
        }
    }

    public void setModifyYBase(boolean modifyYBase) {
        this.modifyYBase = modifyYBase;
    }

    public boolean isModifyYBase() {
        return this.modifyYBase;
    }

    public boolean isUseMultipliers() {
        return this.useMultipliers;
    }

    public void setUseMultipliers(boolean useMultipliers) {
        this.useMultipliers = useMultipliers;
    }

    public boolean isZoomEnabled() {
        return this.zoomEnabled;
    }

    public void setZoomEnabled(boolean enabled) {
        this.zoomEnabled = enabled;
    }

    public void setRotation(double angle) {
        this.rotation = angle;
    }

    public double getRotation() {
        return this.rotation;
    }

    public boolean areLabelsInside() {
        return this.labelsInside;
    }

    public void setLabelsInside(boolean labelsInside) {
        this.labelsInside = labelsInside;
    }

    public double getLeftYellowZone() {
        return this.leftYellowZone;
    }

    public void setLeftYellowZone(double leftYellowZone) {
        this.leftYellowZone = leftYellowZone;
    }

    public double getLeftRedZone() {
        return this.leftRedZone;
    }

    public void setLeftRedZone(double leftRedZone) {
        this.leftRedZone = leftRedZone;
    }

    public double getRightYellowZone() {
        return this.rightYellowZone;
    }

    public void setRightYellowZone(double rightYellowZone) {
        this.rightYellowZone = rightYellowZone;
    }

    public double getRightRedZone() {
        return this.rightRedZone;
    }

    public void setRightRedZone(double rightRedZone) {
        this.rightRedZone = rightRedZone;
    }

    public boolean isElementBordersVisible() {
        return this.elementBordersVisible;
    }

    public void setElementBordersVisible(boolean elementBordersVisible) {
        this.elementBordersVisible = elementBordersVisible;
    }

    public int getGaugeColorMode() {
        return this.gaugeColorMode;
    }

    public void setGaugeColorMode(int gaugeColorMode) {
        this.gaugeColorMode = gaugeColorMode;
    }

    public String getFontName() {
        return this.fontName != null && !this.fontName.isEmpty() ? this.fontName : "Verdana";
    }

    public void setFontName(String fontName) {
        this.fontName = fontName;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
    }

    public int getExpectedTextWidth() {
        return this.expectedTextWidth;
    }

    public void setExpectedTextWidth(int expectedTextWidth) {
        this.expectedTextWidth = expectedTextWidth;
    }
}

