/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.topology;

import java.net.InetAddress;
import org.netxms.base.MacAddress;
import org.netxms.base.NXCPMessage;

public class ArpCacheEntry {
    private InetAddress ipAddress;
    private MacAddress macAddress;
    private int interfaceIndex;
    private String interfaceName;
    private long nodeId;
    private String nodeName;

    public ArpCacheEntry(NXCPMessage msg, long baseId) {
        this.ipAddress = msg.getFieldAsInetAddress(baseId);
        this.macAddress = msg.getFieldAsMacAddress(baseId + 1L);
        this.interfaceIndex = msg.getFieldAsInt32(baseId + 2L);
        this.interfaceName = msg.getFieldAsString(baseId + 3L);
        this.nodeId = msg.getFieldAsInt64(baseId + 4L);
        this.nodeName = msg.getFieldAsString(baseId + 5L);
    }

    public InetAddress getIpAddress() {
        return this.ipAddress;
    }

    public MacAddress getMacAddress() {
        return this.macAddress;
    }

    public int getInterfaceIndex() {
        return this.interfaceIndex;
    }

    public String getInterfaceName() {
        return this.interfaceName.isEmpty() ? "[" + Integer.toString(this.interfaceIndex) + "]" : this.interfaceName;
    }

    public long getNodeId() {
        return this.nodeId;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public String toString() {
        return "ArpCacheEntry [ipAddress=" + this.ipAddress + ", macAddress=" + this.macAddress + ", interfaceIndex=" + this.interfaceIndex + ", interfaceName=" + this.interfaceName + ", nodeId=" + this.nodeId + ", nodeName=" + this.nodeName + "]";
    }
}

