/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.charts.widgets;

import java.util.List;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.netxms.client.datacollection.DataFormatter;
import org.netxms.client.datacollection.GraphItem;
import org.netxms.ui.eclipse.charts.api.DataSeries;
import org.netxms.ui.eclipse.charts.widgets.Chart;
import org.netxms.ui.eclipse.charts.widgets.GenericComparisonChart;
import org.netxms.ui.eclipse.console.resources.RegionalSettings;
import org.netxms.ui.eclipse.tools.ColorConverter;
import org.netxms.ui.eclipse.tools.WidgetHelper;

public class PieChart
extends GenericComparisonChart {
    private static final int MARGIN_WIDTH = 5;
    private static final int MARGIN_HEIGHT = 5;
    private static final int MARK_TEXT_HEIGHT = 20;
    private static final int MARK_TEXT_WIDTH = 30;
    private static final int MARKS_OFFSET = 10;
    private Font[] scaleFonts = null;
    private Font[] valueFonts = null;

    public PieChart(Chart parent) {
        super(parent);
    }

    @Override
    protected void createFonts() {
        String fontName = this.chart.getConfiguration().getFontName();
        this.scaleFonts = new Font[16];
        int i = 0;
        while (i < this.scaleFonts.length) {
            this.scaleFonts[i] = new Font((Device)this.getDisplay(), fontName, i + 6, 0);
            ++i;
        }
        this.valueFonts = new Font[16];
        i = 0;
        while (i < this.valueFonts.length) {
            this.valueFonts[i] = new Font((Device)this.getDisplay(), fontName, i * 2 + 6, 1);
            ++i;
        }
    }

    @Override
    protected void disposeFonts() {
        int i;
        if (this.scaleFonts != null) {
            i = 0;
            while (i < this.scaleFonts.length) {
                this.scaleFonts[i].dispose();
                ++i;
            }
        }
        if (this.valueFonts != null) {
            i = 0;
            while (i < this.valueFonts.length) {
                this.valueFonts[i].dispose();
                ++i;
            }
        }
    }

    @Override
    protected void render(GC gc) {
        Font markFont = WidgetHelper.getBestFittingFont((GC)gc, (Font[])this.scaleFonts, (String)"100%", (int)30, (int)20);
        gc.setFont(markFont);
        Point markSize = gc.textExtent("100%");
        Point size = this.getSize();
        List<GraphItem> items = this.chart.getItems();
        if (items.isEmpty() || size.x < 30 - markSize.x * 2 || size.y < 30 - markSize.y * 2) {
            return;
        }
        List<DataSeries> series = this.chart.getDataSeries();
        if (series.isEmpty()) {
            return;
        }
        double total = 0.0;
        double[] values = new double[series.size()];
        int i = 0;
        while (i < series.size()) {
            values[i] = series.get(i).getCurrentValue();
            total += values[i] < 0.0 ? 0.0 : values[i];
            ++i;
        }
        if (total == 0.0) {
            return;
        }
        double[] angularSize = new double[series.size()];
        int i2 = 0;
        while (i2 < values.length) {
            angularSize[i2] = (values[i2] < 0.0 ? 0.0 : values[i2]) / total * 360.0;
            ++i2;
        }
        if (this.chart.getConfiguration().isTranslucent()) {
            gc.setAlpha(127);
        }
        Color plotAreaColor = this.getColorFromPreferences("Chart.Colors.PlotArea");
        Color scaleColor = this.getColorFromPreferences("Chart.Colors.DialScale");
        gc.setForeground(scaleColor);
        int boxSize = Math.min(size.x - 10 - 20 - markSize.x * 2, size.y - 10 - 20 - markSize.y * 2);
        int x = (size.x - boxSize) / 2;
        int y = (size.y - boxSize) / 2;
        int cx = x + boxSize / 2 + 1;
        int cy = y + boxSize / 2 + 1;
        int startAngle = 0;
        int i3 = 0;
        while (i3 < values.length) {
            int color = items.get(i3).getColor();
            gc.setBackground(this.chart.getColorCache().create(color == -1 ? this.chart.getPaletteEntry(i3).getRGBObject() : ColorConverter.rgbFromInt((int)color)));
            int sectorSize = i3 == values.length - 1 ? 360 - startAngle : (int)Math.round(angularSize[i3]);
            gc.fillArc(x, y, boxSize, boxSize, startAngle, sectorSize);
            int pct = (int)(values[i3] / total * 100.0);
            if (pct > 0) {
                int centerAngle = startAngle + sectorSize / 2;
                Point l1 = this.positionOnArc(cx, cy, boxSize / 2 + 10, centerAngle);
                Point l2 = this.positionOnArc(cx, cy, boxSize / 2, centerAngle);
                gc.drawLine(l1.x, l1.y, l2.x, l2.y);
                gc.setBackground(plotAreaColor);
                Point tc = this.positionOnArc(cx, cy, boxSize / 2 + 10 + markSize.y, centerAngle);
                String mark = String.valueOf(Integer.toString(pct)) + "%";
                Point ext = gc.textExtent(mark);
                gc.drawText(mark, tc.x - ext.x / 2, tc.y - ext.y / 2);
            }
            startAngle += sectorSize;
            ++i3;
        }
        if (this.chart.getConfiguration().isDoughnutRendering()) {
            gc.setBackground(plotAreaColor);
            gc.setAlpha(255);
            int width = boxSize / 7;
            gc.fillArc(x + width, y + width, boxSize - width * 2, boxSize - width * 2, 0, 360);
        }
        if (this.chart.getConfiguration().isShowTotal()) {
            String v = new DataFormatter(items.get(0).getDisplayFormat(), series.get(0).getDataType(), items.get(0).getMeasurementUnit()).format(Double.toString(total), RegionalSettings.TIME_FORMATTER);
            int innerBoxSize = boxSize - boxSize / 6;
            gc.setFont(WidgetHelper.getBestFittingFont((GC)gc, (Font[])this.valueFonts, (String)"00000000", (int)innerBoxSize, (int)innerBoxSize));
            Point ext = gc.textExtent(v);
            if (ext.x <= innerBoxSize && ext.y <= innerBoxSize) {
                if (!this.chart.getConfiguration().isDoughnutRendering()) {
                    gc.setForeground(plotAreaColor);
                }
                gc.setAlpha(255);
                gc.drawText(v, cx - ext.x / 2, cy - ext.y / 2, 1);
            }
        }
    }

    private Point positionOnArc(int cx, int cy, int radius, int angle) {
        return new Point((int)((double)radius * Math.cos(Math.toRadians(angle)) + (double)cx), (int)((double)radius * -Math.sin(Math.toRadians(angle)) + (double)cy));
    }
}

